/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Nfdynm2AtomCoords;
import ciss.phase_viewer.atomcoord.io.DynmFileFilter;
import ciss.phase_viewer.atomcoord.io.FrameCombo;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.mainpanel.ChaseProgressMonitor;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class DynmImporter
implements Importer {
    private Logger logger = Logger.getLogger(DynmImporter.class.getName());
    private String frame = FrameCombo.FIRST_FRAME;
    private Nfdynm2AtomCoords parser;
    private int target = 0;
    private PropertyChangeListener listener;
    private FrameCombo select;
    private JTextField tfstart;
    private JTextField tfend;
    private JTextField tfgap;

    public AtomCoords[] getAtomCoordsFrom(String fileName) {
        this.parser = new Nfdynm2AtomCoords(fileName);
        ChaseProgressMonitor monitor = ChaseProgressMonitor.getMonitor();
        monitor.setProgress(this.parser);
        int numFrame = this.parser.getNumFrames();
        int targetFrame = -1;
        if (this.select != null) {
            targetFrame = this.select.getTargetFrame(numFrame);
        }
        if (targetFrame < 0) {
            try {
                int istart = Integer.parseInt(this.tfstart.getText().trim());
                int iend = Integer.parseInt(this.tfend.getText().trim());
                int igap = Integer.parseInt(this.tfgap.getText().trim());
                if (istart < 0 || igap > iend && iend >= 0) {
                    this.logger.error("invalid specifcation for the start, end or gap parameter");
                    this.logger.error("using the default values");
                } else {
                    this.parser.setStartEndGap(istart, iend, igap);
                }
            }
            catch (NumberFormatException nfe) {
                this.logger.error("invalid specifcation for the start, end or gap parameter");
                this.logger.error("using the default values");
            }
            Vector vec = this.parser.getFrames();
            Object[] cds = new AtomCoords[vec.size()];
            vec.copyInto(cds);
            return cds;
        }
        return new AtomCoords[]{this.parser.getFrameAt(targetFrame)};
    }

    public String getType() {
        return "F_DYNM file (phase)";
    }

    public FileFilter getFileFilter() {
        return new DynmFileFilter();
    }

    public boolean hasOptions() {
        return true;
    }

    public void createOptionsPanel(boolean isheavy, PropertyChangeListener listener, String fileName) {
        this.listener = listener;
        if (!isheavy) {
            OptionsPanel panel = new OptionsPanel(fileName);
        } else {
            OptionsPanelHeavy heavy = new OptionsPanelHeavy(fileName);
        }
    }

    public void setOptions(HashMap options) {
    }

    public boolean isImportable(String fileName) {
        if (new File(fileName).isDirectory()) {
            return false;
        }
        String fname = new File(fileName).getName();
        return fname.equals("nfdynm.data");
    }

    class OptPanel
    extends JPanel {
        private String fileName;

        OptPanel(String fileName) {
            this.fileName = fileName;
            this.init();
        }

        private void init() {
            Nfdynm2AtomCoords parser = new Nfdynm2AtomCoords(this.fileName);
            int nframe = parser.getNumFrames();
            JPanel pchoice = new JPanel();
            DynmImporter.this.select = new FrameCombo();
            pchoice.add(DynmImporter.this.select);
            DynmImporter.this.tfstart = new JTextField(5);
            DynmImporter.this.tfstart.setText("0");
            DynmImporter.this.tfstart.setEnabled(false);
            JPanel pstart = new JPanel();
            pstart.setBorder(new TitledBorder("start"));
            pstart.add(DynmImporter.this.tfstart);
            DynmImporter.this.tfend = new JTextField(5);
            DynmImporter.this.tfend.setText(String.valueOf(nframe - 1));
            DynmImporter.this.tfend.setEnabled(false);
            JPanel pend = new JPanel();
            pend.setBorder(new TitledBorder("end"));
            pend.add(DynmImporter.this.tfend);
            DynmImporter.this.tfgap = new JTextField(5);
            DynmImporter.this.tfgap.setText("1");
            DynmImporter.this.tfgap.setEnabled(false);
            JPanel pgap = new JPanel();
            pgap.setBorder(new TitledBorder("gap"));
            pgap.add(DynmImporter.this.tfgap);
            DynmImporter.this.select.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    String choi = DynmImporter.this.select.getChoice();
                    boolean enab = false;
                    if (choi.equals(FrameCombo.ALL_FRAME)) {
                        enab = true;
                    }
                    DynmImporter.this.tfstart.setEnabled(enab);
                    DynmImporter.this.tfend.setEnabled(enab);
                    DynmImporter.this.tfgap.setEnabled(enab);
                }
            });
            JPanel pp = new JPanel();
            pp.setLayout(new GridLayout(1, 3));
            pp.add(pstart);
            pp.add(pend);
            pp.add(pgap);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(pchoice);
            panel.add(pp);
            this.add(panel);
        }
    }

    class OptionsPanel
    extends InternalFrameChase {
        OptionsPanel(String fileName) {
            super("options", true, true, true, true, new Dimension(450, 150));
            this.init(fileName);
        }

        private void init(String fileName) {
            JPanel btnpanel = new JPanel();
            JButton ok = new JButton("ok");
            btnpanel.add(ok);
            JPanel panel = new JPanel();
            panel.add(new OptPanel(fileName));
            panel.add(btnpanel);
            this.getContentPane().add(panel);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.dispose();
                    DynmImporter.this.listener.propertyChange(null);
                }
            });
        }
    }

    class OptionsPanelHeavy
    extends InternalFrameChase {
        OptionsPanelHeavy(String fileName) {
            super("options", new Dimension(300, 150));
            this.init(fileName);
        }

        private void init(String fileName) {
            JPanel btnpanel = new JPanel();
            JButton ok = new JButton("ok");
            btnpanel.add(ok);
            JPanel panel = new JPanel();
            panel.add(new OptPanel(fileName));
            panel.add(btnpanel);
            this.getContentPane().add(panel);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsPanelHeavy.this.dispose();
                    DynmImporter.this.listener.propertyChange(null);
                }
            });
            this.pack();
            this.setVisible(true);
        }
    }
}

