/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFVec3f;
import org.cybergarage.x3d.node.GeometricPropertyNode;
import org.cybergarage.x3d.node.Node;

public class NormalNode
extends GeometricPropertyNode {
    private static final String vectorFieldName = "vector";
    private MFVec3f vectorField;

    public NormalNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.NORMAL);
        this.vectorField = new MFVec3f();
        this.vectorField.setName(vectorFieldName);
        this.addExposedField(this.vectorField);
    }

    public NormalNode(NormalNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFVec3f getVectorField() {
        if (!this.isInstanceNode()) {
            return this.vectorField;
        }
        return (MFVec3f)this.getExposedField(vectorFieldName);
    }

    public void addVector(float[] value) {
        this.getVectorField().addValue(value);
    }

    public void addVector(float x, float y, float z) {
        this.getVectorField().addValue(x, y, z);
    }

    public int getNVectors() {
        return this.getVectorField().getSize();
    }

    public void setVector(int index, float[] value) {
        this.getVectorField().set1Value(index, value);
    }

    public void setVector(int index, float x, float y, float z) {
        this.getVectorField().set1Value(index, x, y, z);
    }

    public void setVectors(String value) {
        this.getVectorField().setValues(value);
    }

    public void setVectors(String[] value) {
        this.getVectorField().setValues(value);
    }

    public void getVector(int index, float[] value) {
        this.getVectorField().get1Value(index, value);
    }

    public float[] getVector(int index) {
        float[] value = new float[3];
        this.getVector(index, value);
        return value;
    }

    public void removeVector(int index) {
        this.getVectorField().removeValue(index);
    }

    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void initialize() {
        super.initialize();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        float[] vector = new float[3];
        printStream.println(indentString + "\tvector [");
        for (int n = 0; n < this.getNVectors(); ++n) {
            this.getVector(n, vector);
            if (n < this.getNVectors() - 1) {
                printStream.println(indentString + "\t\t" + vector[0] + " " + vector[1] + " " + vector[2] + ",");
                continue;
            }
            printStream.println(indentString + "\t\t" + vector[0] + " " + vector[1] + " " + vector[2]);
        }
        printStream.println(indentString + "\t]");
    }
}

