/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFVec3f;
import org.cybergarage.x3d.node.GeometricPropertyNode;
import org.cybergarage.x3d.node.Node;

public class CoordinateNode
extends GeometricPropertyNode {
    private static final String pointFieldName = "point";
    private MFVec3f pointField;

    public CoordinateNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.COORD);
        this.pointField = new MFVec3f();
        this.pointField.setName(pointFieldName);
        this.addExposedField(this.pointField);
    }

    public CoordinateNode(CoordinateNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFVec3f getPointField() {
        if (!this.isInstanceNode()) {
            return this.pointField;
        }
        return (MFVec3f)this.getExposedField(pointFieldName);
    }

    public void addPoint(float[] point) {
        this.getPointField().addValue(point);
    }

    public void addPoint(float x, float y, float z) {
        this.getPointField().addValue(x, y, z);
    }

    public int getNPoints() {
        return this.getPointField().getSize();
    }

    public void setPoint(int index, float[] point) {
        this.getPointField().set1Value(index, point);
    }

    public void setPoint(int index, float x, float y, float z) {
        this.getPointField().set1Value(index, x, y, z);
    }

    public void setPoints(String value) {
        this.getPointField().setValues(value);
    }

    public void setPoints(String[] value) {
        this.getPointField().setValues(value);
    }

    public void getPoint(int index, float[] point) {
        this.getPointField().get1Value(index, point);
    }

    public float[] getPoint(int index) {
        float[] value = new float[3];
        this.getPoint(index, value);
        return value;
    }

    public void removePoint(int index) {
        this.getPointField().removeValue(index);
    }

    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void initialize() {
        super.initialize();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        float[] point = new float[3];
        printStream.println(indentString + "\tpoint [");
        for (int n = 0; n < this.getNPoints(); ++n) {
            this.getPoint(n, point);
            if (n < this.getNPoints() - 1) {
                printStream.println(indentString + "\t\t" + point[0] + " " + point[1] + " " + point[2] + ",");
                continue;
            }
            printStream.println(indentString + "\t\t" + point[0] + " " + point[1] + " " + point[2]);
        }
        printStream.println(indentString + "\t]");
    }
}

