/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFVec2f;
import org.cybergarage.x3d.node.InterpolatorNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.util.Debug;

public class CoordinateInterpolator2DNode
extends InterpolatorNode {
    private String keyValueFieldName = "keyValue";
    private MFVec2f keyValueField;
    private MFVec2f valueField;

    public CoordinateInterpolator2DNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.COORDINATEINTERPOLATOR2D);
        this.keyValueField = new MFVec2f();
        this.addExposedField(this.keyValueFieldName, this.keyValueField);
        this.valueField = new MFVec2f();
        this.addEventOut("value", this.valueField);
    }

    public CoordinateInterpolator2DNode(CoordinateInterpolator2DNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFVec2f getKeyValueField() {
        if (!this.isInstanceNode()) {
            return this.keyValueField;
        }
        return (MFVec2f)this.getExposedField(this.keyValueFieldName);
    }

    public void addKeyValue(float[] vector) {
        this.getKeyValueField().addValue(vector);
    }

    public void addKeyValue(float x, float y) {
        this.getKeyValueField().addValue(x, y);
    }

    public int getNKeyValues() {
        return this.getKeyValueField().getSize();
    }

    public void setKeyValue(int index, float[] vector) {
        this.getKeyValueField().set1Value(index, vector);
    }

    public void setKeyValue(int index, float x, float y) {
        this.getKeyValueField().set1Value(index, x, y);
    }

    public void setKeyValues(String value) {
        this.getKeyValueField().setValues(value);
    }

    public void setKeyValues(String[] value) {
        this.getKeyValueField().setValues(value);
    }

    public void getKeyValue(int index, float[] vector) {
        this.getKeyValueField().get1Value(index, vector);
    }

    public float[] getKeyValue(int index) {
        float[] value = new float[2];
        this.getKeyValue(index, value);
        return value;
    }

    public void removeKeyValue(int index) {
        this.getKeyValueField().removeValue(index);
    }

    public MFVec2f getValueField() {
        if (!this.isInstanceNode()) {
            return this.valueField;
        }
        return (MFVec2f)this.getEventOut("value");
    }

    public void setValue(float[][] vector) {
        this.getValueField().setValues(vector);
    }

    public float[][] getValue() {
        return this.getValueField().getValues();
    }

    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void initialize() {
        super.initialize();
    }

    public void uninitialize() {
    }

    public void update() {
        Debug.message("CoordinateInterpolator2DNode::update");
        float fraction = this.getFraction();
        int index = -1;
        int nKeys = this.getNKeys();
        for (int n = 0; n < nKeys - 1; ++n) {
            if (!(this.getKey(n) <= fraction) || !(fraction <= this.getKey(n + 1))) continue;
            index = n;
            break;
        }
        Debug.message("index = " + index);
        if (index == -1) {
            return;
        }
        float scale = (fraction - this.getKey(index)) / (this.getKey(index + 1) - this.getKey(index));
        int nKeyValues = this.getNKeyValues();
        int nCoodPerKeys = nKeyValues / nKeys;
        int beginCoodIdx = index * nCoodPerKeys;
        int endCoordIdx = (index + 1) * nCoodPerKeys;
        float[] vector1 = new float[2];
        float[] vector2 = new float[2];
        float[][] vectorOut = new float[nCoodPerKeys][2];
        for (int i = 0; i < nCoodPerKeys; ++i) {
            this.getKeyValue(beginCoodIdx + i, vector1);
            this.getKeyValue(endCoordIdx + i, vector2);
            for (int n = 0; n < 2; ++n) {
                vectorOut[i][n] = vector1[n] + (vector2[n] - vector1[n]) * scale;
            }
        }
        this.setValue(vectorOut);
        this.sendEvent(this.getValueField());
    }

    public void outputContext(PrintWriter printStream, String indentString) {
    }
}

