/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Group;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.j3d.SceneGraphJ3dObject;
import org.cybergarage.x3d.node.DirectionalLightNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;

public class DirectionalLightNodeObject
extends DirectionalLight
implements NodeObject {
    public DirectionalLightNodeObject(DirectionalLightNode node) {
        this.setCapability(18);
        this.setCapability(19);
        this.setCapability(14);
        this.setCapability(15);
        this.setCapability(16);
        this.setCapability(17);
        this.setCapability(12);
        this.setCapability(13);
        this.initialize(node);
    }

    public boolean initialize(Node node) {
        node.setRunnable(true);
        node.setRunnableType(1);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        this.setInfluencingBounds((Bounds)bounds);
        this.update(node);
        return true;
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        DirectionalLightNode light = (DirectionalLightNode)node;
        this.setEnable(light.isOn());
        float[] color = new float[3];
        light.getColor(color);
        float intensity = light.getIntensity();
        color[0] = color[0] * intensity;
        color[1] = color[1] * intensity;
        color[2] = color[2] * intensity;
        Color3f color3f = new Color3f(color);
        this.setColor(color3f);
        float[] dir = new float[3];
        light.getDirection(dir);
        this.setDirection(dir[0], dir[1], dir[2]);
        return true;
    }

    public Group getParentGroup(Node node) {
        Node parentNode = node.getParentNode();
        Object parentGroupNode = null;
        if (parentNode != null) {
            NodeObject parentNodeObject = parentNode.getObject();
            if (parentNodeObject != null) {
                parentGroupNode = (Group)parentNodeObject;
            }
        } else {
            SceneGraphJ3dObject sgObject;
            SceneGraph sg = node.getSceneGraph();
            if (sg != null && (sgObject = (SceneGraphJ3dObject)sg.getObject()) != null) {
                parentGroupNode = sgObject.getRootNode();
            }
        }
        return parentGroupNode;
    }

    public boolean add(Node node) {
        Group parentGroupNode;
        if (this.getParent() == null && (parentGroupNode = this.getParentGroup(node)) != null) {
            parentGroupNode.addChild((javax.media.j3d.Node)this);
        }
        return true;
    }

    public boolean remove(Node node) {
        Group parentGroupNode = this.getParentGroup(node);
        if (parentGroupNode != null) {
            for (int n = 0; n < parentGroupNode.numChildren(); ++n) {
                if (parentGroupNode.getChild(n) != this) continue;
                parentGroupNode.removeChild(n);
                return true;
            }
        }
        return false;
    }
}

