/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.sftp;

import ciss.phase_viewer.common.MyJMenu;
import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.ssh.hosts.HostConfigurator;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostSelectorMenu;
import ciss.phase_viewer.ssh.sftp.SftpClientPanel;
import ciss.phase_viewer.ssh.terminal.Terminal;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.apache.log4j.Logger;

public class SftpClient
extends InternalFrameChase {
    private static Logger logger = Logger.getLogger(SftpClient.class.getName());
    private SftpClientPanel sftpPanel;

    public SftpClient() {
        super("sftp client", true, true, true, true, new Dimension(700, 500));
        this.sftpPanel = new SftpClientPanel(true);
        this.init();
    }

    public SftpClient(HostInfo hostinfo) {
        super("sftp client", true, true, true, true, new Dimension(700, 500));
        this.sftpPanel = new SftpClientPanel(hostinfo);
        this.init();
    }

    public SftpClient(HostInfo hostinfo, boolean local_has_proj) {
        super("sftp client", true, true, true, true, new Dimension(700, 500));
        this.sftpPanel = new SftpClientPanel(hostinfo, local_has_proj);
        this.init();
    }

    private void init() {
        JPanel p = this.createBrowsersAndButtons();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(p);
        this.setJMenuBar(new SftpClientMenuBar());
        this.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameActivated(InternalFrameEvent e) {
            }

            public void internalFrameClosed(InternalFrameEvent e) {
                if (SftpClient.this.sftpPanel != null) {
                    SftpClient.this.sftpPanel.disconnect();
                }
            }

            public void internalFrameClosing(InternalFrameEvent e) {
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            public void internalFrameDeiconified(InternalFrameEvent e) {
            }

            public void internalFrameIconified(InternalFrameEvent e) {
            }

            public void internalFrameOpened(InternalFrameEvent e) {
            }
        });
        this.setVisible(true);
    }

    private JPanel createBrowsersAndButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel buttons = this.createButtons();
        p.add(this.sftpPanel);
        p.add(buttons);
        return p;
    }

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton upload = new JButton("upload");
        JButton download = new JButton("download");
        p.add(upload);
        p.add(download);
        upload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClient.this.sftpPanel.uploadFiles();
            }
        });
        download.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClient.this.sftpPanel.downloadFiles();
            }
        });
        JButton close = new JButton("close");
        p.add(close);
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClient.this.dispose();
            }
        });
        return p;
    }

    public void dispose() {
        this.sftpPanel.disconnect();
        super.dispose();
    }

    class SftpClientMenuBar
    extends JMenuBar {
        SftpClientMenuBar() {
            this.createMenu();
        }

        private void createMenu() {
            this.add(this.fileMenu());
            this.add(new HostSelectorMenu(SftpClient.this.sftpPanel, "hosts", 72));
            this.add(this.toolMenu());
        }

        private MyJMenu fileMenu() {
            MyJMenu file = new MyJMenu("File", 70, false);
            MyJMenu local = new MyJMenu("local", 76);
            MyJMenuItem[] localitems = this.getLocalItems();
            for (int i = 0; i < localitems.length; ++i) {
                local.add(localitems[i]);
            }
            MyJMenu remote = new MyJMenu("remote", 82, false);
            MyJMenuItem[] remoteitems = this.getRemoteItems();
            for (int i = 0; i < remoteitems.length; ++i) {
                remote.add(remoteitems[i]);
            }
            MyJMenuItem exit = new MyJMenuItem("exit", 88);
            file.add(local);
            file.add(remote);
            file.add(exit);
            exit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SftpClient.this.dispose();
                }
            });
            return file;
        }

        private MyJMenuItem[] getLocalItems() {
            MyJMenuItem locdel = new MyJMenuItem("delete", 68);
            MyJMenuItem locchfname = new MyJMenuItem("rename", 67);
            MyJMenuItem locmkdir = new MyJMenuItem("create new dir", 78);
            MyJMenuItem locprops = new MyJMenuItem("property", 80);
            MyJMenuItem[] ret = new MyJMenuItem[]{locchfname, locmkdir, locprops, locdel};
            locdel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SftpClient.this.sftpPanel.getBrowserTree(1).deleteSelectedFiles();
                }
            });
            locchfname.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SftpClient.this.sftpPanel.getBrowserTree(1).rename();
                }
            });
            locmkdir.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SftpClient.this.sftpPanel.getBrowserTree(1).mkdir();
                }
            });
            locprops.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SftpClient.this.sftpPanel.getBrowserTree(1).bootFilePropertyViewer();
                }
            });
            return ret;
        }

        private MyJMenuItem[] getRemoteItems() {
            MyJMenuItem remdel = new MyJMenuItem("delete", 68);
            MyJMenuItem remchfname = new MyJMenuItem("rename", 67);
            MyJMenuItem remmkdir = new MyJMenuItem("create new dir", 78);
            MyJMenuItem remprops = new MyJMenuItem("property", 80);
            MyJMenuItem[] ret = new MyJMenuItem[]{remchfname, remmkdir, remprops, remdel};
            remdel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SftpClient.this.sftpPanel.getBrowserTree(0).deleteSelectedFiles();
                }
            });
            remchfname.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SftpClient.this.sftpPanel.getBrowserTree(0).rename();
                }
            });
            remmkdir.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SftpClient.this.sftpPanel.getBrowserTree(0).mkdir();
                }
            });
            remprops.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SftpClient.this.sftpPanel.getBrowserTree(0).bootFilePropertyViewer();
                }
            });
            return ret;
        }

        private MyJMenu toolMenu() {
            MyJMenu tool = new MyJMenu("Tools", 67, false);
            MyJMenuItem host = new MyJMenuItem("host configurator", 72);
            MyJMenuItem term = new MyJMenuItem("terminal", 80);
            tool.add(host);
            tool.add(term);
            host.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HostConfigurator configurator = new HostConfigurator();
                }
            });
            term.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Terminal te = new Terminal(SftpClient.this.sftpPanel.getHostInfo());
                }
            });
            return tool;
        }
    }
}

