/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.primitiveguis.ToolTippedCombo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class ComboBoxPhase
extends ToolTippedCombo
implements Command,
InputInterfaceEntryChangeListener {
    private static Logger logger = Logger.getLogger(ComboBoxPhase.class.getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;
    private String[] choices;
    private Vector disabableGUIs = new Vector();
    private boolean isUnit = false;
    private ActionListener[] alists;
    private PopupMenuListener[] plists;

    public ComboBoxPhase(String[] choices, String[] inputSpecifications, InputInterface inputinterface) {
        super(choices);
        this.choices = choices;
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        inputinterface.addInputInterfaceEntryChangeListener(this);
    }

    public ComboBoxPhase(String[] choices, String[] inputSpecifications, InputInterface inputinterface, boolean isUnit) {
        super(choices);
        this.choices = choices;
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.isUnit = isUnit;
        inputinterface.addInputInterfaceEntryChangeListener(this);
    }

    public void silentUpdate() {
        String newText = (String)super.getSelectedItem();
        InputInterfacePrimitiveEntry entry = this.inputinterface.getInputInterfacePrimitiveEntry(this.inputSpecifications[0]);
        String[] fn = this.inputSpecifications[0].split("\\.");
        String name = fn[fn.length - 1];
        if (!this.isUnit) {
            entry.setUnit("");
            entry.setValue(newText.trim());
        } else {
            entry.setUnit(newText.trim());
        }
        if (newText != null && !newText.trim().equalsIgnoreCase(ConstParameters.NO_SELECTION)) {
            this.inputinterface.replaceEntry(entry, this, false);
            logger.debug("replaced: " + entry.getName() + "=" + entry.getValue());
        } else {
            this.inputinterface.removeEntry(entry, this, false);
            logger.debug("removed: " + entry.getName() + "=" + entry.getValue());
        }
    }

    public void execute(EventObject e) {
        if (e instanceof ItemEvent) {
            logger.debug("item event...");
        } else if (e instanceof ActionEvent) {
            logger.debug("actionevent...");
        } else if (e instanceof PopupMenuEvent) {
            logger.debug("pop-up menu event...");
        }
        String newText = (String)super.getSelectedItem();
        logger.debug("inputSpec: " + this.inputSpecifications[0]);
        InputInterfacePrimitiveEntry entry = this.inputinterface.getInputInterfacePrimitiveEntry(this.inputSpecifications[0]);
        String[] fn = this.inputSpecifications[0].split("\\.");
        String name = fn[fn.length - 1];
        entry.saveState();
        entry.setName(name);
        if (!this.isUnit) {
            entry.setUnit("");
            entry.setValue(newText.trim());
        } else {
            entry.setUnit(newText.trim());
        }
        if (newText != null && !newText.trim().equalsIgnoreCase(ConstParameters.NO_SELECTION)) {
            this.inputinterface.replaceEntry(entry, this);
            logger.debug("replaced: " + entry.getName() + "=" + entry.getValue());
            logger.debug("at : " + this.inputinterface.getCurrentBlock().getFullName());
        } else {
            this.inputinterface.removeEntry(entry, this);
            logger.debug("removed: " + entry.getName() + "=" + entry.getValue());
            logger.debug("from block: " + this.inputinterface.getCurrentBlock().getFullName());
        }
        this.disableRegisteredGUI();
    }

    public void disableRegisteredGUI() {
        for (int i = 0; i < this.disabableGUIs.size(); ++i) {
            Vector disset = (Vector)this.disabableGUIs.get(i);
            int[] index = (int[])disset.get(0);
            JComponent jcomponent = (JComponent)disset.get(1);
            int selectedIndex = super.getSelectedIndex();
            boolean enable = true;
            for (int j2 = 0; j2 < index.length; ++j2) {
                if (selectedIndex != index[j2]) continue;
                enable = false;
            }
            jcomponent.setEnabled(enable);
        }
    }

    public void inputInterfaceInitializing() {
        this.removeListeners();
        this.setSelectedIndex(0);
        this.restoreListeners();
    }

    public void inputInterfaceInitialized() {
    }

    public void removeListeners() {
        int i;
        this.alists = this.getActionListeners();
        this.plists = this.getPopupMenuListeners();
        if (this.alists != null) {
            for (i = 0; i < this.alists.length; ++i) {
                this.removeActionListener(this.alists[i]);
            }
        }
        if (this.plists != null) {
            for (i = 0; i < this.plists.length; ++i) {
                this.removePopupMenuListener(this.plists[i]);
            }
        }
    }

    public void restoreListeners() {
        int i;
        if (this.alists != null) {
            for (i = 0; i < this.alists.length; ++i) {
                this.addActionListener(this.alists[i]);
            }
        }
        if (this.plists != null) {
            for (i = 0; i < this.plists.length; ++i) {
                this.addPopupMenuListener(this.plists[i]);
            }
        }
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent evt) {
        if (evt.getSource() == this) {
            return;
        }
        logger.debug("at inputInterfaceEntryChanged");
        String tag = evt.getTag();
        InputInterfaceEntry entry = evt.getEntry();
        if (entry.getEntryType() != 0) {
            return;
        }
        InputInterfacePrimitiveEntry pentry = (InputInterfacePrimitiveEntry)entry;
        String fullName = tag + "." + pentry.getName();
        String rep = "";
        rep = this.isUnit ? pentry.getUnit() : pentry.getValue();
        if (rep == null || rep.trim().length() == 0) {
            return;
        }
        this.removeListeners();
        for (int ii = 0; ii < this.inputSpecifications.length; ++ii) {
            if (!fullName.trim().equalsIgnoreCase(this.inputSpecifications[ii].trim())) continue;
            logger.debug("replace string: " + rep + " (fullName: " + fullName + ")");
            int irep = -1;
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!((String)this.getItemAt(i)).equalsIgnoreCase(rep)) continue;
                irep = i;
                break;
            }
            if (irep == -1) {
                this.setSelectedIndex(0);
                return;
            }
            this.setSelectedIndex(irep);
        }
        this.restoreListeners();
    }

    public void setDisabableGUI(int[] index, JComponent jcomponent) {
        Vector<Object> disset = new Vector<Object>();
        disset.addElement(index);
        disset.addElement(jcomponent);
        this.disabableGUIs.addElement(disset);
    }
}

