/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.mainpanel;

import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.main.Main;
import ciss.phase_viewer.mainpanel.ChaseGUI;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

class ChaseLogoWindow
extends JFrame {
    private Logger logger = Logger.getLogger(ChaseLogoWindow.class.getName());
    private BufferedImage image;
    private int sleep;

    public ChaseLogoWindow(Frame frame) {
        super("chase");
        this.setUndecorated(true);
        Document doc = Main.getDefaultPropertiesDocument();
        Element element = doc.getRootElement().getChild("splash_screen");
        String imgpath = MyElement.decode(element.getChildTextTrim("imagefilepath"));
        String sx = MyElement.decode(element.getChildTextTrim("scale_x"));
        String sy = MyElement.decode(element.getChildTextTrim("scale_y"));
        String ssleep = MyElement.decode(element.getChildTextTrim("default_sleep"));
        double scalex = 0.7;
        double scaley = 0.7;
        this.sleep = 2000;
        if (sx != null && sy != null && ssleep != null) {
            try {
                scalex = Double.parseDouble(sx);
                scaley = Double.parseDouble(sy);
                this.sleep = Integer.parseInt(ssleep);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        URL url = ChaseLogoWindow.class.getClass().getResource(imgpath.trim());
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(url);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bi == null) {
            this.logger.error("unable to load splash screen.");
            return;
        }
        int sizex = (int)((double)bi.getWidth() * scalex);
        int sizey = (int)((double)bi.getHeight() * scaley);
        AffineTransform trans = new AffineTransform();
        trans.scale(scalex, scaley);
        AffineTransformOp transform = new AffineTransformOp(trans, 2);
        this.image = transform.filter(bi, null);
        this.setSize(sizex, sizey);
        int scrx = ChaseGUI.getScreenWidth();
        int scry = ChaseGUI.getScreenHeight();
        int centerx = scrx / 2 - sizex / 2;
        int centery = scry / 2 - sizey / 2;
        this.setLocation(centerx, centery);
    }

    protected int getDefaultSleepTime() {
        return this.sleep;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.image != null) {
            g2.drawImage(this.image, null, 0, 0);
        }
    }
}

