/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.input;

import ciss.phase_viewer.input.InputWizard;
import ciss.phase_viewer.input.InputWizardEvent;
import ciss.phase_viewer.input.InputWizardListener;
import ciss.phase_viewer.input.InputWizardRoot;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public abstract class InputWizardController {
    private Logger logger = Logger.getLogger(InputWizardController.class.getName());
    protected Vector inputWizards;
    protected Input input;
    private Document specDocument;
    private Element[] wizardSpecs;
    private InputWizardGUI gui;
    private int wizNow = 0;
    private Vector listeners;
    private HashMap properties = new HashMap();
    private InputWizardRoot root;
    private ProjectInfo projectInfo;
    private boolean can = true;
    private JButton next;
    private JButton previous;
    private JButton finished;
    private JButton canceled;
    private JTextField description;
    private JPanel panel;
    private TitledBorder border;

    public InputWizardController(Input input, InputWizardRoot root, ProjectInfo projectInfo) {
        this.input = input;
        this.root = root;
        this.projectInfo = projectInfo;
        this.specDocument = root.getSpecDocument();
        this.initialize();
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public void addInputWizardListener(InputWizardListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public void removeInputWizardListener(InputWizardListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void cleanUp() {
        this.listeners.removeAllElements();
        this.listeners = null;
    }

    public void resetWizards() {
        this.specDocument = this.root.getSpecDocument();
        Element rootElement = this.specDocument.getRootElement();
        List list = rootElement.getChildren("inputwizard");
        this.wizardSpecs = new Element[list.size()];
        for (int i = 0; i < this.wizardSpecs.length; ++i) {
            this.wizardSpecs[i] = (Element)list.get(i);
        }
        String aa = this.wizardSpecs[this.wizNow].getTextTrim();
        this.logger.debug("wiz. class : " + aa);
        InputWizard firstWiz = null;
        firstWiz = this.root == null ? (InputWizard)PluginLoader.instantiate(aa, null) : this.root;
        firstWiz.setInput(this.input);
        firstWiz.setProperties(this.properties);
        firstWiz.setParent(this);
        this.inputWizards = new Vector();
        this.inputWizards.add(firstWiz);
    }

    private void initialize() {
        this.gui = new InputWizardGUI();
        this.resetWizards();
        if (this.gui != null) {
            this.update(this.root);
        }
    }

    public void update(InputWizard wiz) {
        this.gui.setGUI(wiz.getGUI());
        this.description.setText(wiz.getDescription());
        this.border.setTitle(wiz.getName());
        this.next.setEnabled(wiz.hasNext());
        this.previous.setEnabled(wiz.hasPrevious());
        this.finished.setEnabled(wiz.hasFinished());
        this.gui.revalidate();
        this.gui.repaint();
    }

    public void updateButtons(InputWizard wiz) {
        this.next.setEnabled(wiz.hasNext());
        this.previous.setEnabled(wiz.hasPrevious());
        this.finished.setEnabled(wiz.hasFinished());
    }

    private void next() {
        if (this.wizNow >= this.wizardSpecs.length - 1) {
            return;
        }
        this.notifyListeners(InputWizardEvent.TO_NEXT);
        ++this.wizNow;
        if (this.inputWizards.size() <= this.wizNow) {
            try {
                InputWizard wiz = (InputWizard)PluginLoader.instantiate(this.wizardSpecs[this.wizNow].getTextTrim(), null);
                wiz.setInput(this.input);
                wiz.setProperties(this.properties);
                wiz.setParent(this);
                this.inputWizards.add(wiz);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        InputWizard wi = (InputWizard)this.inputWizards.get(this.wizNow);
        wi.setProperties(this.properties);
        this.update(wi);
    }

    private void previous() {
        if (this.wizNow == 0) {
            return;
        }
        this.notifyListeners(InputWizardEvent.TO_PREVIOUS);
        --this.wizNow;
        InputWizard wi = (InputWizard)this.inputWizards.get(this.wizNow);
        wi.setProperties(this.properties);
        this.update(wi);
    }

    private void finished() {
        int i;
        this.can = false;
        if (this.listeners != null) {
            InputWizardEvent ev = new InputWizardEvent(this, InputWizardEvent.FINISHING);
            for (i = 0; i < this.listeners.size(); ++i) {
                ((InputWizardListener)this.listeners.get(i)).stateChanged(ev);
            }
        }
        this.logger.info("creating input...");
        for (int i2 = 0; i2 < this.inputWizards.size(); ++i2) {
            String result = ((InputWizard)this.inputWizards.get(i2)).process();
            if (result == null) continue;
            this.logger.info(result);
        }
        int numwiz = this.root.getNumWizards();
        if (numwiz < 0) {
            numwiz = this.wizardSpecs.length;
        }
        for (i = this.inputWizards.size(); i < numwiz; ++i) {
            InputWizard wiz = (InputWizard)PluginLoader.instantiate(this.wizardSpecs[i].getTextTrim(), null);
            wiz.setInput(this.input);
            wiz.setProperties(this.properties);
            wiz.setParent(this);
            wiz.getGUI();
            wiz.process();
        }
        this.input.save();
        this.gui.dispose();
        this.notifyListeners(InputWizardEvent.FINISHED);
    }

    private void notifyListeners(int mode) {
        if (this.listeners != null) {
            this.listeners.trimToSize();
            InputWizardEvent ev = new InputWizardEvent(this, mode);
            int n = this.listeners.size();
            for (int i = 0; i < n && this.listeners != null; ++i) {
                Object o = this.listeners.get(i);
                ((InputWizardListener)o).stateChanged(ev);
            }
        }
    }

    private void canceled() {
        this.can = false;
        this.logger.info("canceled.");
        this.gui.dispose();
        this.notifyListeners(InputWizardEvent.CANCELED);
    }

    public abstract String getWizardType();

    class InputWizardGUI
    extends InternalFrameChase {
        private static final long serialVersionUID = 1L;

        InputWizardGUI() {
            super("create input for " + InputWizardController.this.getWizardType(), true, true, true, true, new Dimension(550, 400));
            this.init();
        }

        void setGUI(JComponent comp) {
            InputWizardController.this.panel.removeAll();
            InputWizardController.this.panel.add(comp);
        }

        private void init() {
            JPanel foo = new JPanel();
            foo.setLayout(new BorderLayout());
            InputWizardController.this.border = new TitledBorder("");
            foo.setBorder(InputWizardController.this.border);
            JPanel pd = this.createDescriptionPanel();
            JPanel pp = this.createBtnPanel();
            InputWizardController.this.panel = new JPanel();
            foo.add((Component)pd, "North");
            foo.add((Component)InputWizardController.this.panel, "Center");
            foo.add((Component)pp, "South");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(foo);
            this.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosed(InternalFrameEvent e) {
                    if (InputWizardController.this.can) {
                        InputWizardController.this.canceled();
                    }
                }
            });
        }

        private JPanel createDescriptionPanel() {
            JPanel ret = new JPanel();
            ret.setBorder(new TitledBorder("description"));
            ret.setLayout(new BorderLayout());
            InputWizardController.this.description = new JTextField();
            InputWizardController.this.description.setEditable(false);
            ret.add(InputWizardController.this.description);
            return ret;
        }

        private JPanel createBtnPanel() {
            JPanel pbtn = new JPanel();
            pbtn.setLayout(new BoxLayout(pbtn, 0));
            InputWizardController.this.next = new JButton("next");
            InputWizardController.this.previous = new JButton("previous");
            InputWizardController.this.finished = new JButton("OK");
            InputWizardController.this.canceled = new JButton("cancel");
            pbtn.add(InputWizardController.this.previous);
            pbtn.add(InputWizardController.this.next);
            pbtn.add(InputWizardController.this.finished);
            pbtn.add(InputWizardController.this.canceled);
            JPanel ret = new JPanel();
            ret.setLayout(new BorderLayout());
            ret.add((Component)pbtn, "East");
            InputWizardController.this.next.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InputWizardController.this.next();
                }
            });
            InputWizardController.this.previous.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InputWizardController.this.previous();
                }
            });
            InputWizardController.this.finished.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InputWizardController.this.finished();
                }
            });
            InputWizardController.this.canceled.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InputWizardController.this.canceled();
                }
            });
            return ret;
        }
    }
}

