/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.export;

import ciss.phase_viewer.common.Drawable;
import ciss.phase_viewer.common.PDFExporter;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.freehep.util.export.ExportFileType;

public class PDFExportFileType
extends ExportFileType {
    private Logger logger = Logger.getLogger(PDFExportFileType.class.getName());
    private Drawable drawable;

    public PDFExportFileType(Drawable drawable) {
        this.drawable = drawable;
    }

    public String[] getMIMETypes() {
        return new String[]{"pdf"};
    }

    public String[] getExtensions() {
        return new String[]{".pdf", ".PDF"};
    }

    public String getDescription() {
        return "portable document format ";
    }

    public void exportToFile(OutputStream outputStream, Component[] component, Component component0, Properties properties, String string) throws IOException {
        if (component == null || component.length == 0) {
            return;
        }
        this.exportToFile(outputStream, component[0], component0, properties, string);
    }

    public void exportToFile(OutputStream outputStream, Component component, Component component0, Properties properties, String string) throws IOException {
        if (component == null) {
            return;
        }
        int width = component.getWidth();
        int height = component.getHeight();
        PDFExporter.g2DtoPDF(this.drawable, outputStream, width, height);
    }

    public void exportToFile(File file, Component[] component, Component component0, Properties properties, String string) throws IOException {
        if (component == null || component.length == 0) {
            return;
        }
        this.exportToFile(file, component[0], component0, properties, string);
    }

    public void exportToFile(File file, Component component, Component component0, Properties properties, String string) throws IOException {
        if (component == null) {
            return;
        }
        int width = component.getWidth();
        int height = component.getHeight();
        PDFExporter.g2DtoPDF(this.drawable, file, width, height);
    }
}

