/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.Drawable;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class PDFExporter {
    private static Logger logger = Logger.getLogger(PDFExporter.class.getName());

    private PDFExporter() {
    }

    public static final void g2DtoPDF(Drawable draw, File file, int width, int height, FontMapper mapper) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        PDFExporter.g2DtoPDF(draw, out, width, height, mapper);
    }

    public static final void g2DtoPDF(Drawable draw, File file, int width, int height) throws IOException {
        PDFExporter.g2DtoPDF(draw, file, width, height, (FontMapper)new DefaultFontMapper());
    }

    public static final void g2DtoPDF(Drawable draw, OutputStream out, int width, int height) throws IOException {
        PDFExporter.g2DtoPDF(draw, out, width, height, (FontMapper)new DefaultFontMapper());
    }

    public static final void g2DtoPDF(Drawable draw, OutputStream out, int width, int height, FontMapper mapper) throws IOException {
        Rectangle pagesize = new Rectangle(width, height);
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter writer = PdfWriter.getInstance(document, out);
            document.addAuthor("phase-viewer");
            document.addSubject("chart");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate(width, height);
            Graphics2D g2 = tp.createGraphics(width, height, mapper);
            Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            draw.draw(g2, r2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
        catch (DocumentException de) {
            logger.error(de.getMessage());
        }
        document.close();
        out.close();
    }
}

