/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements.abinitmp;

import ciss.phase_viewer.acviewer.scenegraphelements.abinitmp.CrossPoint;
import ciss.phase_viewer.acviewer.scenegraphelements.abinitmp.CrossPointLinear;
import ciss.phase_viewer.atomcoord.VolumetricData;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class MarchingCube {
    public static final int LOG = 0;
    public static final int LINEAR = 1;
    private static final byte[][] PLYEDGES1 = new byte[][]{{1, 3, 6}};
    private static final byte[][] PLYEDGES2 = new byte[][]{{1, 2, 6}, {2, 6, 7}};
    private static final byte[][] PLYEDGES3 = new byte[][]{{1, 3, 6}, {0, 2, 5}};
    private static final byte[][] PLYEDGES4 = new byte[][]{{1, 3, 6}, {5, 8, 10}};
    private static final byte[][] PLYEDGES5 = new byte[][]{{2, 6, 9}, {2, 3, 6}, {2, 9, 10}};
    private static final byte[][] PLYEDGES6 = new byte[][]{{5, 8, 10}, {1, 2, 6}, {2, 6, 7}};
    private static final byte[][] PLYEDGES7 = new byte[][]{{0, 1, 4}, {5, 8, 10}, {2, 3, 7}};
    private static final byte[][] PLYEDGES8 = new byte[][]{{1, 9, 10}, {1, 2, 10}};
    private static final byte[][] PLYEDGES9 = new byte[][]{{1, 4, 8}, {1, 3, 8}, {3, 8, 10}, {3, 7, 10}};
    private static final byte[][] PLYEDGES10 = new byte[][]{{0, 4, 6}, {0, 3, 6}, {5, 8, 11}, {5, 7, 11}};
    private static final byte[][] PLYEDGES11 = new byte[][]{{1, 3, 9}, {5, 8, 9}, {3, 5, 9}, {3, 5, 7}};
    private static final byte[][] PLYEDGES12 = new byte[][]{{0, 1, 4}, {2, 6, 9}, {2, 9, 10}, {2, 3, 6}};
    private static final byte[][] PLYEDGES13 = new byte[][]{{4, 8, 9}, {1, 3, 6}, {0, 2, 5}, {7, 10, 11}};
    private static final byte[][] PLYEDGES14 = new byte[][]{{3, 4, 6}, {3, 4, 10}, {4, 8, 10}, {2, 3, 10}};
    private static final int PATNO = 256;
    private static final int PlyNo1 = PLYEDGES1.length;
    private static final int PlyNo2 = PLYEDGES2.length;
    private static final int PlyNo3 = PLYEDGES3.length;
    private static final int PlyNo4 = PLYEDGES4.length;
    private static final int PlyNo5 = PLYEDGES5.length;
    private static final int PlyNo6 = PLYEDGES6.length;
    private static final int PlyNo7 = PLYEDGES7.length;
    private static final int PlyNo8 = PLYEDGES8.length;
    private static final int PlyNo9 = PLYEDGES9.length;
    private static final int PlyNo10 = PLYEDGES10.length;
    private static final int PlyNo11 = PLYEDGES11.length;
    private static final int PlyNo12 = PLYEDGES12.length;
    private static final int PlyNo13 = PLYEDGES13.length;
    private static final int PlyNo14 = PLYEDGES14.length;
    private static final int[] CROSSEDGE = new int[]{0, 74, 198, 111, 1386, 1612, 1510, 1471, 1542, 1434, 2553, 938, 1631, 4095, 1372};
    private static final int[][] EDGETABLE = new int[][]{{-1, 0, 1, -1, 4, -1, -1, -1}, {0, -1, -1, 2, -1, 5, -1, -1}, {1, -1, -1, 3, -1, -1, 6, -1}, {-1, 2, 3, -1, -1, -1, -1, 7}, {4, -1, -1, -1, -1, 8, 9, -1}, {-1, 5, -1, -1, 8, -1, -1, 10}, {-1, -1, 6, -1, 9, -1, -1, 11}, {-1, -1, -1, 7, -1, 10, 11, -1}};
    private static final int[][] UEDGETABLE = new int[][]{{0, 1}, {0, 2}, {1, 3}, {2, 3}, {0, 4}, {1, 5}, {2, 6}, {3, 7}, {4, 5}, {4, 6}, {5, 7}, {6, 7}};
    private static int[][] PAT0 = new int[][]{{0, 16434824}};
    private static int[][] PAT1 = new int[][]{{4, 33212040}, {1, 30659609}, {2, 32451168}, {8, 29254338}, {16, 22671629}, {32, 23400308}, {128, 21765605}, {64, 24958340}};
    private static int[][] PAT2 = new int[][]{{12, 49989256}, {68, 41735556}, {192, 38542821}, {136, 46796521}, {5, 47436825}, {10, 46031554}, {160, 43527115}, {80, 49650960}, {3, 40624684}, {34, 49228384}, {48, 35760958}, {17, 39448845}};
    private static int[][] PAT3 = new int[][]{{6, 66766472}, {9, 64214041}, {40, 63573737}, {130, 54740605}, {65, 58512772}, {20, 53407910}, {96, 56954740}, {144, 55320037}, {18, 56226061}, {33, 57401900}, {132, 58891451}, {72, 61902746}};
    private static int[][] PAT4 = new int[][]{{36, 83543688}, {24, 80350953}, {129, 72097253}, {66, 75289988}};
    private static int[][] PAT5 = new int[][]{{200, 100320904}, {140, 92067204}, {76, 88874469}, {196, 97128169}, {11, 86962342}, {14, 90956332}, {13, 88295037}, {7, 84301047}, {138, 90509172}, {42, 87312342}, {162, 96363202}, {168, 99560032}, {21, 84457903}, {81, 92445883}, {84, 97768473}, {69, 89780493}, {19, 85025631}, {49, 93810771}, {50, 94877746}, {35, 86092606}, {208, 98384193}, {112, 93858763}, {176, 95457178}, {224, 99982608}};
    private static int[][] PAT6 = new int[][]{{44, 117098120}, {70, 108844420}, {193, 105651685}, {152, 113905385}, {161, 110635979}, {38, 101802847}, {74, 105072253}, {133, 114545689}, {67, 110587987}, {88, 116759824}, {56, 102869822}, {145, 111654962}, {28, 101078263}, {100, 109223099}, {194, 112234394}, {137, 104089558}, {164, 107286388}, {37, 103739558}, {131, 107733548}, {82, 101235119}, {52, 115161409}, {25, 106557709}, {98, 116337248}, {26, 113140418}};
    private static int[][] PAT7 = new int[][]{{41, 133875336}, {146, 130682601}, {134, 129011610}, {104, 126000315}, {148, 117855479}, {73, 120866774}, {97, 133114464}, {22, 125621636}};
    private static int[][] PAT8 = new int[][]{{204, 150652552}, {15, 141287980}, {51, 136424254}, {240, 145788826}, {170, 140840820}, {85, 140112141}};
    private static int[][] PAT9 = new int[][]{{212, 167429768}, {232, 159176068}, {142, 155983333}, {77, 164237033}, {113, 162566042}, {178, 154421206}, {43, 151409911}, {23, 159554747}};
    private static int[][] PAT10 = new int[][]{{165, 184206984}, {90, 175953284}, {102, 179343258}, {195, 171198422}, {153, 168187127}, {60, 176331963}};
    private static int[][] PAT11 = new int[][]{{228, 200984200}, {202, 192730500}, {141, 189537765}, {92, 197791465}, {114, 196120474}, {163, 187975638}, {27, 184964343}, {53, 193109179}, {46, 191172468}, {71, 185121199}, {209, 194522059}, {184, 197026498}};
    private static int[][] PAT12 = new int[][]{{201, 217761416}, {156, 209507716}, {108, 206314981}, {198, 214568681}, {86, 215208985}, {101, 207221005}, {149, 201898415}, {89, 209886395}, {30, 208396844}, {45, 205735549}, {135, 201741559}, {75, 204402854}, {169, 217000544}, {154, 207949684}, {106, 204752854}, {166, 213803714}, {210, 215824705}, {120, 211299275}, {180, 212897690}, {225, 217423120}, {57, 211251283}, {54, 212318258}, {99, 203533118}, {147, 202466143}};
    private static int[][] PAT13 = new int[][]{{150, 234538632}, {105, 226284932}};
    private static int[][] PAT14 = new int[][]{{216, 251315848}, {172, 243062148}, {78, 239869413}, {197, 248123113}, {58, 238307286}, {39, 235295991}, {83, 243440827}, {177, 246452122}, {139, 237957286}, {226, 250977552}, {29, 235452847}, {116, 244853707}};
    private static final int XTRACED = 594;
    private static final int YTRACED = 305;
    private static final int ZTRACED = 15;
    private int[] pattab = new int[256];
    private int dim0;
    private int dim1;
    private int dim2;
    private int dim01;
    private int dim012;
    private int dim_01;
    private float[] xp;
    private float[] yp;
    private float[] zp;
    private Point3f[] b0;
    private Point3f[] f0;
    private Point3f[] m0;
    private Point3f[] b;
    private Point3f[] f;
    private Point3f[] m;
    private Point3f[] tbf;
    private Vector3f[] b0n;
    private Vector3f[] f0n;
    private Vector3f[] m0n;
    private Vector3f[] bn;
    private Vector3f[] fn;
    private Vector3f[] mn;
    private Vector3f[] tbfn;
    private int[] pno = new int[15];
    private int xtraced;
    private int ytraced;
    private int ztraced;
    private int traced;
    private int logOrLinear;
    private boolean hanten;

    private int BOUND(float x, float t) {
        return x >= t ? 1 : 0;
    }

    private int EXTRACT(int x, int n) {
        return x >> n * 3 & 7;
    }

    private int EXTRACT1(int x, int n) {
        return x >> n & 1;
    }

    public void create_isosurf(float[] x, float[] y, float[] z, int nx, int ny, int nz, float[] data, float value, Vector tri_pos, Vector normal, int ll) {
        int i;
        int[] typeno = new int[15];
        this.logOrLinear = ll;
        this.init_pattab();
        this.dim0 = nx;
        this.dim1 = ny;
        this.dim2 = nz;
        this.dim01 = this.dim0 * this.dim1;
        this.dim012 = this.dim01 * this.dim2;
        try {
            this.b0 = new Point3f[2 * this.dim01 - this.dim0 - this.dim1];
            for (i = 0; i < this.b0.length; ++i) {
                this.b0[i] = new Point3f();
            }
            this.f0 = new Point3f[2 * this.dim01 - this.dim0 - this.dim1];
            for (i = 0; i < this.f0.length; ++i) {
                this.f0[i] = new Point3f();
            }
            this.m0 = new Point3f[this.dim01];
            for (i = 0; i < this.m0.length; ++i) {
                this.m0[i] = new Point3f();
            }
            this.b0n = new Vector3f[2 * this.dim01 - this.dim0 - this.dim1];
            for (i = 0; i < this.b0n.length; ++i) {
                this.b0n[i] = new Vector3f();
            }
            this.f0n = new Vector3f[2 * this.dim01 - this.dim0 - this.dim1];
            for (i = 0; i < this.f0n.length; ++i) {
                this.f0n[i] = new Vector3f();
            }
            this.m0n = new Vector3f[this.dim01];
            for (i = 0; i < this.m0n.length; ++i) {
                this.m0n[i] = new Vector3f();
            }
        }
        catch (Exception e) {
            System.err.println("MarchingCube/create_isosurf: " + e);
            return;
        }
        this.xp = x;
        this.yp = y;
        this.zp = z;
        for (i = 0; i < 15; ++i) {
            this.pno[i] = 0;
        }
        int zoffset1 = 0;
        this.b = this.b0;
        this.m = this.m0;
        this.f = this.f0;
        this.bn = this.b0n;
        this.mn = this.m0n;
        this.fn = this.f0n;
        int ztraced = 0;
        for (int k = 0; k < this.dim2 - 1; ++k) {
            int zoffset0 = zoffset1;
            zoffset1 = zoffset0 + this.dim01;
            this.read1plane(data, value, zoffset0, k, tri_pos, normal);
            this.tbf = this.f;
            this.f = this.b;
            this.b = this.tbf;
            this.tbfn = this.fn;
            this.fn = this.bn;
            this.bn = this.tbfn;
            ztraced = 15;
        }
    }

    private void read1plane(float[] data, float lev, int zoff, int z, Vector tri_pos, Vector normal) {
        int i;
        float vdata1 = 0.0f;
        float vdata2 = 0.0f;
        byte[][] plyedges = null;
        int[] edge_cnvt = new int[12];
        Point3f v0 = new Point3f();
        Point3f v1 = new Point3f();
        Vector3f n0 = new Vector3f();
        Vector3f n1 = new Vector3f();
        int zoffset0 = zoff;
        int zoffset1 = zoffset0 + this.dim01;
        int yoffset1 = 0;
        Point3f[] edge_array = new Point3f[12];
        Vector3f[] normal_array = new Vector3f[12];
        for (i = 0; i < edge_array.length; ++i) {
            edge_array[i] = new Point3f();
            normal_array[i] = new Vector3f();
        }
        i = 0;
        int ytraced = this.ztraced;
        while (i < this.dim1 - 1) {
            int yoffset0 = yoffset1;
            yoffset1 = yoffset0 + this.dim0;
            int j = 0;
            int xtraced = ytraced;
            while (j < this.dim0 - 1) {
                int pcode;
                int ptype = pcode = this.getpcode(data, zoffset0, yoffset0, j, lev);
                int n = ptype = ptype >> 24 & 0x3F;
                this.pno[n] = this.pno[n] + 1;
                if (ptype > 14) {
                    System.out.println("error ");
                } else {
                    int cedge = CROSSEDGE[ptype];
                    if (cedge != 0) {
                        int PlyNo;
                        for (int k = 0; k < 12; ++k) {
                            if ((cedge & 1) == 1) {
                                int uedge;
                                int c1 = this.EXTRACT(pcode, UEDGETABLE[k][0]);
                                int c2 = this.EXTRACT(pcode, UEDGETABLE[k][1]);
                                edge_cnvt[k] = uedge = EDGETABLE[c1][c2];
                                if (this.EXTRACT1(xtraced, uedge) != 0) {
                                    switch (uedge) {
                                        case 0: {
                                            this.copyPoint3f(edge_array[uedge], this.f[yoffset0 + yoffset0 - i + j]);
                                            this.copyVector3f(normal_array[uedge], this.fn[yoffset0 + yoffset0 - i + j]);
                                            break;
                                        }
                                        case 1: {
                                            this.copyPoint3f(edge_array[uedge], this.f[this.dim0 - 1 + yoffset0 + yoffset0 - i + j]);
                                            this.copyVector3f(normal_array[uedge], this.fn[this.dim0 - 1 + yoffset0 + yoffset0 - i + j]);
                                            break;
                                        }
                                        case 2: {
                                            this.copyPoint3f(edge_array[uedge], this.f[this.dim0 - 1 + yoffset0 + yoffset0 - i + j + 1]);
                                            this.copyVector3f(normal_array[uedge], this.fn[this.dim0 - 1 + yoffset0 + yoffset0 - i + j + 1]);
                                            break;
                                        }
                                        case 3: {
                                            this.copyPoint3f(edge_array[uedge], this.f[yoffset0 + this.dim0 + yoffset0 + this.dim0 - i - 1 + j]);
                                            this.copyVector3f(normal_array[uedge], this.fn[yoffset0 + this.dim0 + yoffset0 + this.dim0 - i - 1 + j]);
                                            break;
                                        }
                                        case 4: {
                                            this.copyPoint3f(edge_array[uedge], this.m[yoffset0 + j]);
                                            this.copyVector3f(normal_array[uedge], this.m0n[yoffset0 + j]);
                                            break;
                                        }
                                        case 5: {
                                            this.copyPoint3f(edge_array[uedge], this.m[yoffset0 + j + 1]);
                                            this.copyVector3f(normal_array[uedge], this.m0n[yoffset0 + j + 1]);
                                            break;
                                        }
                                        case 6: {
                                            this.copyPoint3f(edge_array[uedge], this.m[yoffset1 + j]);
                                            this.copyVector3f(normal_array[uedge], this.mn[yoffset1 + j]);
                                            break;
                                        }
                                        case 8: {
                                            this.copyPoint3f(edge_array[uedge], this.b[yoffset0 + yoffset0 - i + j]);
                                            this.copyVector3f(normal_array[uedge], this.bn[yoffset0 + yoffset0 - i + j]);
                                            break;
                                        }
                                        case 9: {
                                            this.copyPoint3f(edge_array[uedge], this.b[this.dim0 - 1 + yoffset0 + yoffset0 - i + j]);
                                            this.copyVector3f(normal_array[uedge], this.bn[this.dim0 - 1 + yoffset0 + yoffset0 - i + j]);
                                            break;
                                        }
                                    }
                                } else {
                                    vdata1 = this.find_offset(data, c1, zoffset0, yoffset0, j, i, z, v0, n0);
                                    vdata2 = this.find_offset(data, c2, zoffset0, yoffset0, j, i, z, v1, n1);
                                    this.interpolate(v0, v1, vdata1, vdata2, lev, edge_array[uedge]);
                                    this.interpolate(n0, n1, vdata1, vdata2, lev, normal_array[uedge]);
                                    switch (uedge) {
                                        case 0: {
                                            this.copyPoint3f(this.f[yoffset0 + yoffset0 - i + j], edge_array[uedge]);
                                            this.copyVector3f(this.fn[yoffset0 + yoffset0 - i + j], normal_array[uedge]);
                                            break;
                                        }
                                        case 1: {
                                            this.copyPoint3f(this.f[this.dim0 - 1 + yoffset0 + yoffset0 - i + j], edge_array[uedge]);
                                            this.copyVector3f(this.fn[this.dim0 - 1 + yoffset0 + yoffset0 - i + j], normal_array[uedge]);
                                            break;
                                        }
                                        case 2: {
                                            this.copyPoint3f(this.f[this.dim0 - 1 + yoffset0 + yoffset0 - i + j + 1], edge_array[uedge]);
                                            this.copyVector3f(this.fn[this.dim0 - 1 + yoffset0 + yoffset0 - i + j + 1], normal_array[uedge]);
                                            break;
                                        }
                                        case 3: {
                                            this.copyPoint3f(this.f[yoffset0 + this.dim0 + yoffset0 + this.dim0 - i - 1 + j], edge_array[uedge]);
                                            this.copyVector3f(this.fn[yoffset0 + this.dim0 + yoffset0 + this.dim0 - i - 1 + j], normal_array[uedge]);
                                            break;
                                        }
                                        case 4: {
                                            this.copyPoint3f(this.m[yoffset0 + j], edge_array[uedge]);
                                            this.copyVector3f(this.mn[yoffset0 + j], normal_array[uedge]);
                                            break;
                                        }
                                        case 5: {
                                            this.copyPoint3f(this.m[yoffset0 + j + 1], edge_array[uedge]);
                                            this.copyVector3f(this.mn[yoffset0 + j + 1], normal_array[uedge]);
                                            break;
                                        }
                                        case 6: {
                                            this.copyPoint3f(this.m[yoffset1 + j], edge_array[uedge]);
                                            this.copyVector3f(this.mn[yoffset1 + j], normal_array[uedge]);
                                            break;
                                        }
                                        case 8: {
                                            this.copyPoint3f(this.b[yoffset0 + yoffset0 - i + j], edge_array[uedge]);
                                            this.copyVector3f(this.bn[yoffset0 + yoffset0 - i + j], normal_array[uedge]);
                                            break;
                                        }
                                        case 9: {
                                            this.copyPoint3f(this.b[this.dim0 - 1 + yoffset0 + yoffset0 - i + j], edge_array[uedge]);
                                            this.copyVector3f(this.bn[this.dim0 - 1 + yoffset0 + yoffset0 - i + j], normal_array[uedge]);
                                            break;
                                        }
                                        case 7: {
                                            this.copyPoint3f(this.m[yoffset1 + j + 1], edge_array[uedge]);
                                            this.copyVector3f(this.mn[yoffset1 + j + 1], normal_array[uedge]);
                                            break;
                                        }
                                        case 10: {
                                            this.copyPoint3f(this.b[this.dim0 - 1 + yoffset0 + yoffset0 - i + j + 1], edge_array[uedge]);
                                            this.copyVector3f(this.bn[this.dim0 - 1 + yoffset0 + yoffset0 - i + j + 1], normal_array[uedge]);
                                            break;
                                        }
                                        case 11: {
                                            this.copyPoint3f(this.b[yoffset0 + this.dim0 + yoffset0 + this.dim0 - i - 1 + j], edge_array[uedge]);
                                            this.copyVector3f(this.bn[yoffset0 + this.dim0 + yoffset0 + this.dim0 - i - 1 + j], normal_array[uedge]);
                                            break;
                                        }
                                    }
                                }
                            }
                            cedge >>= 1;
                        }
                        switch (ptype) {
                            case 1: {
                                PlyNo = PlyNo1;
                                plyedges = PLYEDGES1;
                                break;
                            }
                            case 2: {
                                PlyNo = (byte)PlyNo2;
                                plyedges = PLYEDGES2;
                                break;
                            }
                            case 3: {
                                PlyNo = (byte)PlyNo3;
                                plyedges = PLYEDGES3;
                                break;
                            }
                            case 4: {
                                PlyNo = (byte)PlyNo4;
                                plyedges = PLYEDGES4;
                                break;
                            }
                            case 5: {
                                PlyNo = (byte)PlyNo5;
                                plyedges = PLYEDGES5;
                                break;
                            }
                            case 6: {
                                PlyNo = (byte)PlyNo6;
                                plyedges = PLYEDGES6;
                                break;
                            }
                            case 7: {
                                PlyNo = (byte)PlyNo7;
                                plyedges = PLYEDGES7;
                                break;
                            }
                            case 8: {
                                PlyNo = (byte)PlyNo8;
                                plyedges = PLYEDGES8;
                                break;
                            }
                            case 9: {
                                PlyNo = (byte)PlyNo9;
                                plyedges = PLYEDGES9;
                                break;
                            }
                            case 10: {
                                PlyNo = (byte)PlyNo10;
                                plyedges = PLYEDGES10;
                                break;
                            }
                            case 11: {
                                PlyNo = (byte)PlyNo11;
                                plyedges = PLYEDGES11;
                                break;
                            }
                            case 12: {
                                PlyNo = (byte)PlyNo12;
                                plyedges = PLYEDGES12;
                                break;
                            }
                            case 13: {
                                PlyNo = (byte)PlyNo13;
                                plyedges = PLYEDGES13;
                                break;
                            }
                            case 14: {
                                PlyNo = (byte)PlyNo14;
                                plyedges = PLYEDGES14;
                                break;
                            }
                            default: {
                                PlyNo = 0;
                            }
                        }
                        float ignore = VolumetricData.meaninglessValue;
                        int z1 = zoffset0 + this.dim01;
                        int y1 = yoffset0 + this.dim0;
                        int x = j;
                        int z0 = zoffset0;
                        int y0 = yoffset0;
                        if (data[z1 + y1 + x + 1] != ignore && data[z1 + y1 + x] != ignore && data[z1 + y0 + x + 1] != ignore && data[z1 + y0 + x] != ignore && data[z0 + y1 + x + 1] != ignore && data[z0 + y1 + x] != ignore && data[z0 + y0 + x + 1] != ignore && data[z0 + y0 + x] != ignore) {
                            for (int k = 0; k < PlyNo; ++k) {
                                this.addPolygon(plyedges[k][0], plyedges[k][1], plyedges[k][2], lev, edge_cnvt, edge_array, normal_array, tri_pos, normal);
                            }
                            boolean hanten1 = this.hanten;
                            if (this.hanten && ptype == 3 || ptype == 6 || ptype == 7) {
                                int e2;
                                int e1;
                                int e0;
                                int xn = j;
                                int yn = yoffset0;
                                int zn = zoffset0;
                                int voffset = xn + yn + zn;
                                if (ptype == 3) {
                                    e0 = edge_cnvt[0];
                                    e1 = edge_cnvt[1];
                                    e2 = edge_cnvt[2];
                                } else {
                                    e0 = edge_cnvt[2];
                                    e1 = edge_cnvt[5];
                                    e2 = edge_cnvt[7];
                                }
                                if (this.sameValue(edge_array[e0].x, edge_array[e1].x) && this.sameValue(edge_array[e1].x, edge_array[e2].x) && this.sameValue(edge_array[e0].x, edge_array[e2].x)) {
                                    xn = this.sameValue(edge_array[e1].x, this.xp[voffset]) ? --xn : ++xn;
                                } else if (this.sameValue(edge_array[e0].y, edge_array[e1].y) && this.sameValue(edge_array[e1].y, edge_array[e2].y) && this.sameValue(edge_array[e0].y, edge_array[e2].y)) {
                                    yn = this.sameValue(edge_array[e1].y, this.yp[voffset]) ? yoffset0 - this.dim0 : yoffset0 + this.dim0;
                                } else {
                                    zn = this.sameValue(edge_array[e1].z, this.zp[voffset]) ? zoffset0 - this.dim01 : zoffset0 + this.dim01;
                                }
                                int next_ptype = this.getpcode(data, zn, yn, xn, lev);
                                next_ptype = next_ptype >> 24 & 0x3F;
                                if (!(this.hanten || next_ptype != 3 && next_ptype != 6 && next_ptype != 7 && next_ptype != 10 && next_ptype != 12 && next_ptype != 13)) {
                                    if (ptype == 3) {
                                        this.addPolygon(0, 1, 3, lev, edge_cnvt, edge_array, normal_array, tri_pos, normal);
                                        this.addPolygon(0, 3, 2, lev, edge_cnvt, edge_array, normal_array, tri_pos, normal);
                                    } else {
                                        this.addPolygon(2, 5, 7, lev, edge_cnvt, edge_array, normal_array, tri_pos, normal);
                                        this.addPolygon(7, 5, 10, lev, edge_cnvt, edge_array, normal_array, tri_pos, normal);
                                    }
                                }
                            }
                        }
                    }
                }
                ++j;
                xtraced = ytraced;
                xtraced |= 0x252;
            }
            ++i;
            ytraced = this.ztraced;
            ytraced |= 0x131;
        }
    }

    private void addPolygon(int i1, int i2, int i3, float v, int[] edge_cnvt, Point3f[] edge_array, Vector3f[] normal_array, Vector tri_pos, Vector normal) {
        int e1 = edge_cnvt[i1];
        int e2 = edge_cnvt[i2];
        int e3 = edge_cnvt[i3];
        Vector3f n1 = new Vector3f(normal_array[e1]);
        Vector3f n2 = new Vector3f(normal_array[e2]);
        Vector3f n3 = new Vector3f(normal_array[e3]);
        if (v > 0.0f) {
            n1.negate();
            n2.negate();
            n3.negate();
        }
        Vector3f vv1 = new Vector3f((Tuple3f)edge_array[e1]);
        Vector3f vv2 = new Vector3f((Tuple3f)edge_array[e2]);
        Vector3f vv3 = new Vector3f((Tuple3f)edge_array[e3]);
        vv3.sub((Tuple3f)vv2);
        vv2.sub((Tuple3f)vv1);
        vv1.cross(vv3, vv2);
        int count = 0;
        if (vv1.angle(n1) < 1.2566371f) {
            ++count;
        }
        if (vv1.angle(n2) < 1.2566371f) {
            ++count;
        }
        if (vv1.angle(n3) < 1.2566371f) {
            ++count;
        }
        if (vv1.angle(n1) > 1.8849558f) {
            --count;
        }
        if (vv1.angle(n2) > 1.8849558f) {
            --count;
        }
        if (vv1.angle(n3) > 1.8849558f) {
            --count;
        }
        if (count >= 1) {
            tri_pos.addElement(new Point3f(edge_array[e1]));
            tri_pos.addElement(new Point3f(edge_array[e3]));
            tri_pos.addElement(new Point3f(edge_array[e2]));
            normal.addElement(n1);
            normal.addElement(n3);
            normal.addElement(n2);
        } else {
            tri_pos.addElement(new Point3f(edge_array[e1]));
            tri_pos.addElement(new Point3f(edge_array[e2]));
            tri_pos.addElement(new Point3f(edge_array[e3]));
            normal.addElement(n1);
            normal.addElement(n2);
            normal.addElement(n3);
        }
    }

    private boolean sameValue(float v1, float v2) {
        return Math.abs(v1 - v2) < 1.0E-5f;
    }

    private boolean isEdge(Point3f p) {
        if (this.sameValue(p.x, this.xp[0]) || this.sameValue(p.x, this.xp[this.xp.length - 1]) || this.sameValue(p.y, this.yp[0]) || this.sameValue(p.y, this.yp[this.yp.length - 1]) || this.sameValue(p.z, this.zp[0]) || this.sameValue(p.z, this.zp[this.zp.length - 1])) {
            System.out.println(p);
            return true;
        }
        return false;
    }

    private Vector3f calcFaceNormal(Point3f[] vertices, int n) {
        float ax = vertices[n + 2].x - vertices[n + 1].x;
        float ay = vertices[n + 2].y - vertices[n + 1].y;
        float az = vertices[n + 2].z - vertices[n + 1].z;
        float bx = vertices[n + 0].x - vertices[n + 1].x;
        float by = vertices[n + 0].y - vertices[n + 1].y;
        float bz = vertices[n + 0].z - vertices[n + 1].z;
        float nx = ay * bz - az * by;
        float ny = az * bx - ax * bz;
        float nz = ax * by - ay * bx;
        Vector3f normal = new Vector3f(nx, ny, nz);
        normal.normalize();
        return normal;
    }

    private float find_offset(float[] d, int c, int z0, int y0, int x, int y, int z, Point3f v, Vector3f n) {
        int offset = 0;
        int z1 = z0 + this.dim01;
        int y1 = y0 + this.dim0;
        int X = x;
        int Y = y;
        int Z = z;
        switch (c) {
            case 0: {
                offset = z0 + y0 + x;
                break;
            }
            case 1: {
                offset = z0 + y0 + x + 1;
                ++X;
                break;
            }
            case 2: {
                offset = z0 + y1 + x;
                ++Y;
                break;
            }
            case 3: {
                offset = z0 + y1 + x + 1;
                ++X;
                ++Y;
                break;
            }
            case 4: {
                offset = z1 + y0 + x;
                ++Z;
                break;
            }
            case 5: {
                offset = z1 + y0 + x + 1;
                ++Z;
                ++X;
                break;
            }
            case 6: {
                offset = z1 + y1 + x;
                ++Z;
                ++Y;
                break;
            }
            case 7: {
                offset = z1 + y1 + x + 1;
                ++Z;
                ++Y;
                ++X;
                break;
            }
        }
        v.x = this.xp[offset];
        v.y = this.yp[offset];
        v.z = this.zp[offset];
        n.x = X == 0 ? (d[offset + 1] - d[offset]) * 2.0f : (X == this.dim0 - 1 ? (d[offset] - d[offset - 1]) * 2.0f : d[offset + 1] - d[offset - 1]);
        n.y = Y == 0 ? (d[offset + this.dim0] - d[offset]) * 2.0f : (Y == this.dim1 - 1 ? (d[offset] - d[offset - this.dim0]) * 2.0f : d[offset + this.dim0] - d[offset - this.dim0]);
        n.z = Z == 0 ? (d[offset + this.dim01] - d[offset]) * 2.0f : (Z == this.dim2 - 1 ? (d[offset] - d[offset - this.dim01]) * 2.0f : d[offset + this.dim01] - d[offset - this.dim01]);
        float Gx = n.x;
        float Gy = n.y;
        float Gz = n.z;
        float G = Gx * Gx + Gy * Gy + Gz * Gz;
        if ((double)G > 0.0) {
            float H = (float)Math.sqrt(G);
            n.x = Gx / H;
            n.y = Gy / H;
            n.z = Gz / H;
        }
        return d[offset];
    }

    private void interpolate(Point3f v1, Point3f v2, float d1, float d2, float lev, Point3f vert) {
        float[] p1 = new float[3];
        float[] p2 = new float[3];
        float[] c = new float[3];
        p1[0] = v1.x;
        p1[1] = v1.y;
        p1[2] = v1.z;
        p2[0] = v2.x;
        p2[1] = v2.y;
        p2[2] = v2.z;
        if (this.logOrLinear == 0) {
            CrossPoint.get(d1, d2, lev, p1, p2, c);
        } else {
            CrossPointLinear.get(d1, d2, lev, p1, p2, c);
        }
        vert.x = c[0];
        vert.y = c[1];
        vert.z = c[2];
    }

    private void interpolate(Vector3f v1, Vector3f v2, float d1, float d2, float lev, Vector3f vert) {
        float[] p1 = new float[3];
        float[] p2 = new float[3];
        float[] c = new float[3];
        p1[0] = v1.x;
        p1[1] = v1.y;
        p1[2] = v1.z;
        p2[0] = v2.x;
        p2[1] = v2.y;
        p2[2] = v2.z;
        if (this.logOrLinear == 0) {
            CrossPoint.get(d1, d2, lev, p1, p2, c);
        } else {
            CrossPointLinear.get(d1, d2, lev, p1, p2, c);
        }
        vert.x = c[0];
        vert.y = c[1];
        vert.z = c[2];
    }

    private int getpcode(float[] d, int z0, int y0, int x, float lev) {
        try {
            int code = 0;
            int sum1 = 0;
            int z1 = z0 + this.dim01;
            int y1 = y0 + this.dim0;
            int tcode = this.BOUND(d[z1 + y1 + x + 1], lev);
            code |= tcode;
            code <<= 1;
            sum1 += tcode;
            tcode = this.BOUND(d[z1 + y1 + x], lev);
            code |= tcode;
            code <<= 1;
            sum1 += tcode;
            tcode = this.BOUND(d[z1 + y0 + x + 1], lev);
            code |= tcode;
            code <<= 1;
            sum1 += tcode;
            tcode = this.BOUND(d[z1 + y0 + x], lev);
            code |= tcode;
            code <<= 1;
            sum1 += tcode;
            tcode = this.BOUND(d[z0 + y1 + x + 1], lev);
            code |= tcode;
            code <<= 1;
            sum1 += tcode;
            tcode = this.BOUND(d[z0 + y1 + x], lev);
            code |= tcode;
            code <<= 1;
            sum1 += tcode;
            tcode = this.BOUND(d[z0 + y0 + x + 1], lev);
            code |= tcode;
            code <<= 1;
            sum1 += tcode;
            tcode = this.BOUND(d[z0 + y0 + x], lev);
            code |= tcode;
            this.hanten = false;
            if ((sum1 += tcode) > 4) {
                code = 255 - code;
                this.hanten = true;
            }
            return this.pattab[code];
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void init_pattab() {
        int i;
        for (i = 0; i <= 255; ++i) {
            this.pattab[i] = 0xF000000;
        }
        for (i = 0; i < PAT0.length; ++i) {
            this.pattab[MarchingCube.PAT0[i][0]] = PAT0[i][1];
        }
        for (i = 0; i < PAT1.length; ++i) {
            this.pattab[MarchingCube.PAT1[i][0]] = PAT1[i][1];
        }
        for (i = 0; i < PAT2.length; ++i) {
            this.pattab[MarchingCube.PAT2[i][0]] = PAT2[i][1];
        }
        for (i = 0; i < PAT3.length; ++i) {
            this.pattab[MarchingCube.PAT3[i][0]] = PAT3[i][1];
        }
        for (i = 0; i < PAT4.length; ++i) {
            this.pattab[MarchingCube.PAT4[i][0]] = PAT4[i][1];
        }
        for (i = 0; i < PAT5.length; ++i) {
            this.pattab[MarchingCube.PAT5[i][0]] = PAT5[i][1];
        }
        for (i = 0; i < PAT6.length; ++i) {
            this.pattab[MarchingCube.PAT6[i][0]] = PAT6[i][1];
        }
        for (i = 0; i < PAT7.length; ++i) {
            this.pattab[MarchingCube.PAT7[i][0]] = PAT7[i][1];
        }
        for (i = 0; i < PAT8.length; ++i) {
            this.pattab[MarchingCube.PAT8[i][0]] = PAT8[i][1];
        }
        for (i = 0; i < PAT9.length; ++i) {
            this.pattab[MarchingCube.PAT9[i][0]] = PAT9[i][1];
        }
        for (i = 0; i < PAT10.length; ++i) {
            this.pattab[MarchingCube.PAT10[i][0]] = PAT10[i][1];
        }
        for (i = 0; i < PAT11.length; ++i) {
            this.pattab[MarchingCube.PAT11[i][0]] = PAT11[i][1];
        }
        for (i = 0; i < PAT12.length; ++i) {
            this.pattab[MarchingCube.PAT12[i][0]] = PAT12[i][1];
        }
        for (i = 0; i < PAT13.length; ++i) {
            this.pattab[MarchingCube.PAT13[i][0]] = PAT13[i][1];
        }
        for (i = 0; i < PAT14.length; ++i) {
            this.pattab[MarchingCube.PAT14[i][0]] = PAT14[i][1];
        }
    }

    private void copyPoint3f(Point3f to, Point3f from) {
        to.x = from.x;
        to.y = from.y;
        to.z = from.z;
    }

    private void copyVector3f(Vector3f to, Vector3f from) {
        to.x = from.x;
        to.y = from.y;
        to.z = from.z;
    }
}

