/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.mouselistener;

import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.mouselistener.MouseMotionListenerAction;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomFilledCircle;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomSphere;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.apache.log4j.Logger;

public class LeftClickAction
extends MouseMotionListenerAction {
    private Logger logger = Logger.getLogger(LeftClickAction.class.getName());
    private boolean dragCalled = false;
    private PickCanvas pickTool;
    private float initx;
    private float inity;
    private Point3d initPoint;
    private Point3d initMousePos;

    public LeftClickAction(MainPanel parent) {
        super(parent);
        this.pickTool = new PickCanvas(parent.getCanvas(), parent.getRootBranch());
        this.pickTool.setMode(512);
    }

    void finalize(MouseEvent e) {
        if (!this.dragCalled) {
            return;
        }
        int resolution = this.parent.getScene().getCD().getNumAt();
        if (resolution < 100) {
            resolution = 100;
        }
        Point3d finalPoint = LeftClickAction.getCoordsFromMousePos(this.parent, e);
        this.initPoint.z = 10.0;
        finalPoint.z = -10.0;
        Point3d finalMousePos = new Point3d((double)e.getX(), (double)e.getY(), -10.0);
        boolean inismallx = true;
        int startx = (int)this.initMousePos.x;
        int endx = (int)finalMousePos.x;
        if (startx > endx) {
            startx = (int)finalMousePos.x;
            endx = (int)this.initMousePos.x;
            inismallx = false;
        }
        int increx = (int)Math.round((double)(endx - startx) / (double)resolution);
        boolean inismally = true;
        int starty = (int)this.initMousePos.y;
        int endy = (int)finalMousePos.y;
        if (starty > endy) {
            starty = (int)finalMousePos.y;
            endy = (int)this.initMousePos.y;
        }
        int increy = (int)Math.round((double)(endy - starty) / (double)resolution);
        if (increx <= 0) {
            increx = 1;
        }
        if (increy <= 0) {
            increy = 1;
        }
        Vector<AtomObject> vec = new Vector<AtomObject>();
        for (int ix = startx; ix < endx; ix += increx) {
            for (int jy = starty; jy < endy; jy += increy) {
                int x = ix;
                int y = jy;
                this.pickTool.setShapeLocation(x, y);
                PickResult[] result = this.pickTool.pickAll();
                if (result == null) continue;
                for (int i = 0; i < result.length; ++i) {
                    AtomObject obj;
                    Shape3D s3d;
                    AtomObject obj2;
                    Primitive pri = (Primitive)result[i].getNode(4);
                    if (pri != null && pri instanceof AtomSphere && vec.indexOf(obj2 = ((AtomSphere)pri).getAtomObject()) < 0) {
                        vec.add(obj2);
                    }
                    if ((s3d = (Shape3D)result[i].getNode(1)) == null || !(s3d instanceof AtomFilledCircle) || vec.indexOf(obj = ((AtomFilledCircle)s3d).getAtomObject()) >= 0) continue;
                    vec.add(obj);
                }
            }
        }
        ((TGAtom)this.parent.getScene().getTGAtom()).stopMeasure();
        int nselec = 0;
        int nnselec = 0;
        for (int i = 0; i < vec.size(); ++i) {
            boolean b = ((AtomObject)vec.get(i)).toggleSelected();
            if (b) {
                ++nselec;
                continue;
            }
            ++nnselec;
        }
        if (nselec > 0) {
            this.logger.info("selected " + nselec + " atoms ");
        }
        if (nnselec > 0) {
            this.logger.info("deselected " + nnselec + " atoms ");
        }
        ((TGAtom)this.parent.getScene().getTGAtom()).restartMeasure();
        this.parent.finalizeRectangle();
        this.initx = 0.0f;
        this.inity = 0.0f;
        ((TGAtom)this.parent.getScene().getTGAtom()).setRotationEnabled(true);
        this.dragCalled = false;
    }

    private boolean check(Point3d point1, Point3d point2, BoundingSphere sphere) {
        double tmp;
        double x1 = point1.x;
        double y1 = point1.y;
        double x2 = point2.x;
        double y2 = point2.y;
        if (x1 > x2) {
            tmp = 0.0;
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 > y2) {
            tmp = 0.0;
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        Point3d center = new Point3d();
        Point2d p2d = new Point2d();
        this.parent.getCanvas().getPixelLocationFromImagePlate(center, p2d);
        sphere.getCenter(center);
        double radius = sphere.getRadius();
        radius = 0.0;
        double x3 = center.x - radius;
        double y3 = -center.y - radius;
        double x4 = center.x + radius;
        double y4 = -center.y + radius;
        return x1 < x4 && x3 < x2 && y1 < y4 && y3 < y2;
    }

    void init(MouseEvent e) {
        this.initMousePos = new Point3d((double)e.getX(), (double)e.getY(), 10.0);
        this.initPoint = LeftClickAction.getCoordsFromMousePosPlat(this.parent, e);
        this.initx = (float)this.initPoint.x;
        this.inity = -((float)this.initPoint.y);
        this.parent.initializeRectangle(this.initx, this.inity);
    }

    void processMouseDrag(MouseEvent e) {
        ((TGAtom)this.parent.getScene().getTGAtom()).setRotationEnabled(false);
        Point3d point = LeftClickAction.getCoordsFromMousePosPlat(this.parent, e);
        float floatx = (float)point.x - this.initx;
        float floaty = -((float)point.y) - this.inity;
        this.parent.updateRectangle(floatx, floaty);
        this.logger.debug("coordinate: " + point.x + ", " + point.y);
        this.dragCalled = true;
    }

    void processMouseMove(MouseEvent e) {
    }
}

