/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.colormap;

import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.colormap.ColorBar;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.BranchGroup;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ColorBarAttributesEditor
extends InternalFrameChase {
    private Logger logger = Logger.getLogger(ColorBarAttributesEditor.class.getName());
    private MainPanel parent;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    private JTextField posx;
    private JTextField posy;
    private JTextField posz;
    private JTextField height;
    private JTextField width;
    private JTextField fontSize;
    private JButton fontColor;
    private JTextField division;
    private JTextField format;

    public ColorBarAttributesEditor(MainPanel parent) {
        super("edit colorbar attributes", true, true, true, true, new Dimension(350, 400));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        this.init();
        this.setVisible(true);
    }

    private void init() {
        JPanel pall = new JPanel();
        pall.setLayout(new BoxLayout(pall, 1));
        JPanel pgen = new JPanel();
        pgen.setBorder(new TitledBorder("general"));
        pgen.setLayout(new BoxLayout(pgen, 1));
        JPanel ppos = new JPanel();
        ppos.setBorder(new TitledBorder("position"));
        ppos.setLayout(new BoxLayout(ppos, 0));
        String x = "-0.85";
        String y = "-0.8";
        String z = "0.0";
        try {
            String[] strpos = this.gp.getProperty("colorbar_position").split(",");
            x = strpos[0];
            y = strpos[1];
            z = strpos[2];
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.posx = new JTextField(7);
        this.posy = new JTextField(7);
        this.posz = new JTextField(7);
        this.posx.setText(x);
        this.posy.setText(y);
        this.posz.setText(z);
        JPanel panelx = new JPanel();
        panelx.setBorder(new TitledBorder("x"));
        panelx.add(this.posx);
        JPanel panely = new JPanel();
        panely.setBorder(new TitledBorder("y"));
        panely.add(this.posy);
        JPanel panelz = new JPanel();
        panelz.setBorder(new TitledBorder("z"));
        panelz.add(this.posz);
        ppos.add((Component)panelx, "West");
        ppos.add((Component)panely, "Center");
        ppos.add((Component)panelz, "East");
        String strheight = "0.6";
        String strwidth = "0.1";
        strheight = this.gp.getProperty("colorbar_height");
        strwidth = this.gp.getProperty("colorbar_width");
        this.height = new JTextField(10);
        this.width = new JTextField(10);
        this.height.setText(strheight);
        this.width.setText(strwidth);
        JPanel pdim = new JPanel();
        pdim.setLayout(new BoxLayout(pdim, 0));
        JPanel pheight = new JPanel();
        pheight.setBorder(new TitledBorder("height"));
        JPanel pwidth = new JPanel();
        pwidth.setBorder(new TitledBorder("width"));
        pheight.add(this.height);
        pwidth.add(this.width);
        pdim.add(pheight);
        pdim.add(pwidth);
        pgen.add(ppos);
        pgen.add(pdim);
        JPanel pscale = new JPanel();
        pscale.setLayout(new BoxLayout(pscale, 1));
        pscale.setBorder(new TitledBorder("scale"));
        JPanel pfonts = new JPanel();
        pfonts.setLayout(new BoxLayout(pfonts, 0));
        String fontsize = this.gp.getProperty("colorbar_scale_fontsize");
        this.fontSize = new JTextField(7);
        this.fontSize.setText(fontsize);
        JPanel pfontsize = new JPanel();
        pfontsize.setBorder(new TitledBorder("font size"));
        pfontsize.add(this.fontSize);
        this.fontColor = new JButton("color");
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.6f;
        try {
            String[] strcolor = this.gp.getProperty("colorbar_scale_fontcolor").split(",");
            red = Float.parseFloat(strcolor[0]);
            green = Float.parseFloat(strcolor[1]);
            blue = Float.parseFloat(strcolor[2]);
            this.fontColor.setBackground(new Color(red, green, blue));
        }
        catch (Exception exc) {
            // empty catch block
        }
        JPanel pcolor = new JPanel();
        pcolor.setBorder(new TitledBorder("font color"));
        pcolor.add(this.fontColor);
        pfonts.add(pfontsize);
        pfonts.add(pcolor);
        pscale.add(pfonts);
        JPanel pscaleother = new JPanel();
        pscaleother.setLayout(new BoxLayout(pscaleother, 0));
        this.division = new JTextField(7);
        String strdiv = this.gp.getProperty("colorbar_scale_division");
        this.division.setText(strdiv);
        JPanel pdivision = new JPanel();
        pdivision.setBorder(new TitledBorder("division"));
        pdivision.add(this.division);
        this.format = new JTextField(10);
        String strformat = this.gp.getProperty("colorbar_scale_format");
        this.format.setText(strformat);
        JPanel pformat = new JPanel();
        pformat.setBorder(new TitledBorder("format"));
        pformat.add(this.format);
        pscaleother.add(pdivision);
        pscaleother.add(pformat);
        pscale.add(pscaleother);
        pall.add(pgen);
        pall.add(pscale);
        JPanel btns = new JPanel();
        JButton save = new JButton("apply");
        JButton close = new JButton("close");
        btns.add(save);
        btns.add(close);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)pall, "Center");
        container.add((Component)btns, "South");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (ColorBarAttributesEditor.this.doIt()) {
                    ColorBarAttributesEditor.this.gp.storeProperty();
                }
                BranchGroup bg = ColorBarAttributesEditor.this.parent.getRootBranch();
                for (int i = 0; i < bg.numChildren(); ++i) {
                    if (!(bg.getChild(i) instanceof ColorBar)) continue;
                    ColorBarAttributesEditor.this.logger.info("recreating colorbar...");
                    ((ColorBar)bg.getChild(i)).recreate();
                }
            }
        });
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ColorBarAttributesEditor.this.dispose();
            }
        });
        this.fontColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JColorChooser colorchooser = new JColorChooser();
                Color col = ColorBarAttributesEditor.this.fontColor.getBackground();
                Color color = JColorChooser.showDialog(ColorBarAttributesEditor.this.parent, "Choose", col);
                if (color != null) {
                    ColorBarAttributesEditor.this.fontColor.setBackground(color);
                }
            }
        });
    }

    private boolean doIt() {
        try {
            String strx = this.posx.getText().trim();
            String stry = this.posy.getText().trim();
            String strz = this.posz.getText().trim();
            Float.parseFloat(strx);
            Float.parseFloat(stry);
            Float.parseFloat(strz);
            String strheight = this.height.getText().trim();
            String strwidth = this.width.getText().trim();
            Float.parseFloat(strheight);
            Float.parseFloat(strwidth);
            String strsize = this.fontSize.getText().trim();
            Integer.parseInt(strsize);
            Color c = this.fontColor.getBackground();
            String strcolor = String.valueOf((float)c.getRed() / 255.0f) + "," + String.valueOf((float)c.getGreen() / 255.0f) + "," + String.valueOf((float)c.getBlue() / 255.0f);
            String strdiv = this.division.getText().trim();
            Integer.parseInt(strdiv);
            String form = this.format.getText().trim();
            this.gp.setProperty("colorbar_position", strx + "," + stry + "," + strz);
            this.gp.setProperty("colorbar_height", strheight);
            this.gp.setProperty("colorbar_width", strwidth);
            this.gp.setProperty("colorbar_scale_fontsize", strsize);
            this.gp.setProperty("colorbar_scale_fontcolor", strcolor);
            this.gp.setProperty("colorbar_scale_division", strdiv);
            this.gp.setProperty("colorbar_scale_format", form);
        }
        catch (Exception exc) {
            this.logger.error("failed to set properties.");
            exc.printStackTrace();
            return false;
        }
        return true;
    }
}

