/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;

public class TextField
extends BaseField {
    private String defaultText;
    private String[] choices;
    private String[] choiceExports;
    private int choiceSelection;
    private int topFirst;

    public TextField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        super(pdfWriter, rectangle, string);
    }

    public PdfAppearance getAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.text == null || this.text.length() == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        BaseFont baseFont = this.getRealFont();
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f = this.box.height() - this.borderWidth * 2.0f;
        float f2 = this.borderWidth;
        if (bl) {
            f -= this.borderWidth * 2.0f;
            f2 *= 2.0f;
        }
        float f3 = bl ? 2.0f * this.borderWidth : this.borderWidth;
        f3 = Math.max(f3, 1.0f);
        float f4 = Math.min(f2, f3);
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f4, f4, this.box.width() - 2.0f * f4, this.box.height() - 2.0f * f4);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        if (this.textColor == null) {
            pdfAppearance.setGrayFill(0.0f);
        } else {
            pdfAppearance.setColorFill(this.textColor);
        }
        pdfAppearance.beginText();
        if ((this.options & 4) != 0) {
            float f5;
            float f6;
            ArrayList arrayList;
            float f7 = this.fontSize;
            float f8 = this.box.width() - 3.0f * f3;
            ArrayList arrayList2 = arrayList = TextField.getHardBreaks(this.text);
            float f9 = baseFont.getFontDescriptor(8, 1.0f) - baseFont.getFontDescriptor(6, 1.0f);
            if (f7 == 0.0f) {
                f7 = f / (float)arrayList.size() / f9;
                if (f7 > 4.0f) {
                    if (f7 > 12.0f) {
                        f7 = 12.0f;
                    }
                    f6 = Math.max((f7 - 4.0f) / 10.0f, 0.2f);
                    while (f7 > 4.0f && !((float)(arrayList2 = TextField.breakLines(arrayList, baseFont, f7, f8)).size() * f7 * f9 <= f)) {
                        f7 -= f6;
                    }
                }
                if (f7 <= 4.0f) {
                    f7 = 4.0f;
                    arrayList2 = TextField.breakLines(arrayList, baseFont, f7, f8);
                }
            } else {
                arrayList2 = TextField.breakLines(arrayList, baseFont, f7, f8);
            }
            pdfAppearance.setFontAndSize(baseFont, f7);
            pdfAppearance.setLeading(f7 * f9);
            f6 = f3 + f - baseFont.getFontDescriptor(8, f7);
            String string = (String)arrayList2.get(0);
            if (this.alignment == 2) {
                f5 = baseFont.getWidthPoint(string, f7);
                pdfAppearance.moveText(this.box.width() - 2.0f * f3 - f5, f6);
            } else if (this.alignment == 1) {
                string = string.trim();
                f5 = baseFont.getWidthPoint(string, f7);
                pdfAppearance.moveText(this.box.width() / 2.0f - f5 / 2.0f, f6);
            } else {
                pdfAppearance.moveText(2.0f * f3, f6);
            }
            pdfAppearance.showText(string);
            int n = (int)(f / f7 / f9) + 1;
            n = Math.min(n, arrayList2.size());
            for (int i = 1; i < n; ++i) {
                float f10;
                string = (String)arrayList2.get(i);
                if (this.alignment == 2) {
                    f10 = baseFont.getWidthPoint(string, f7);
                    pdfAppearance.moveText(this.box.width() - 2.0f * f3 - f10 - pdfAppearance.getXTLM(), 0.0f);
                } else if (this.alignment == 1) {
                    string = string.trim();
                    f10 = baseFont.getWidthPoint(string, f7);
                    pdfAppearance.moveText(this.box.width() / 2.0f - f10 / 2.0f - pdfAppearance.getXTLM(), 0.0f);
                }
                pdfAppearance.newlineShowText(string);
            }
        } else {
            float f11;
            float f12;
            float f13 = this.fontSize;
            if (f13 == 0.0f) {
                f12 = f / (baseFont.getFontDescriptor(7, 1.0f) - baseFont.getFontDescriptor(6, 1.0f));
                f11 = baseFont.getWidthPoint(this.text, 1.0f);
                f13 = f11 == 0.0f ? f12 : (this.box.width() - 2.0f * f3) / f11;
                if (f13 > f12) {
                    f13 = f12;
                }
                if (f13 < 4.0f) {
                    f13 = 4.0f;
                }
            }
            pdfAppearance.setFontAndSize(baseFont, f13);
            f12 = f4 + (this.box.height() - 2.0f * f4 - baseFont.getFontDescriptor(1, f13)) / 2.0f;
            if (f12 < f4) {
                f12 = f4;
            }
            if (f12 - f4 < -baseFont.getFontDescriptor(3, f13)) {
                f11 = -baseFont.getFontDescriptor(3, f13) + f4;
                float f14 = this.box.height() - f4 - baseFont.getFontDescriptor(1, f13);
                f12 = Math.min(f11, Math.max(f12, f14));
            }
            if ((this.options & 0x100) != 0 && this.maxCharacterLength > 0) {
                int n = Math.min(this.maxCharacterLength, this.text.length());
                int n2 = 0;
                if (this.alignment == 2) {
                    n2 = this.maxCharacterLength - n;
                } else if (this.alignment == 1) {
                    n2 = (this.maxCharacterLength - n) / 2;
                }
                float f15 = this.box.width() / (float)this.maxCharacterLength;
                float f16 = f15 / 2.0f + (float)n2 * f15;
                for (int i = 0; i < n; ++i) {
                    String string = this.text.substring(i, i + 1);
                    float f17 = baseFont.getWidthPoint(string, f13);
                    pdfAppearance.setTextMatrix(f16 - f17 / 2.0f, f12);
                    pdfAppearance.showText(string);
                    f16 += f15;
                }
            } else {
                if (this.alignment == 2) {
                    f11 = baseFont.getWidthPoint(this.text, f13);
                    pdfAppearance.moveText(this.box.width() - 2.0f * f3 - f11, f12);
                } else if (this.alignment == 1) {
                    f11 = baseFont.getWidthPoint(this.text, f13);
                    pdfAppearance.moveText(this.box.width() / 2.0f - f11 / 2.0f, f12);
                } else {
                    pdfAppearance.moveText(2.0f * f3, f12);
                }
                pdfAppearance.showText(this.text);
            }
        }
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    PdfAppearance getListAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.choices == null || this.choices.length == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        int n = this.choiceSelection;
        if (n >= this.choices.length) {
            n = this.choices.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        BaseFont baseFont = this.getRealFont();
        float f = this.fontSize;
        if (f == 0.0f) {
            f = 12.0f;
        }
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f2 = this.box.height() - this.borderWidth * 2.0f;
        if (bl) {
            f2 -= this.borderWidth * 2.0f;
        }
        float f3 = bl ? 2.0f * this.borderWidth : this.borderWidth;
        float f4 = baseFont.getFontDescriptor(8, f) - baseFont.getFontDescriptor(6, f);
        int n2 = (int)(f2 / f4) + 1;
        int n3 = 0;
        int n4 = 0;
        n4 = n + n2 / 2 + 1;
        n3 = n4 - n2;
        if (n3 < 0) {
            n4 += n3;
            n3 = 0;
        }
        if ((n4 = n3 + n2) > this.choices.length) {
            n4 = this.choices.length;
        }
        this.topFirst = n3;
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f3, f3, this.box.width() - 2.0f * f3, this.box.height() - 2.0f * f3);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        Color color = this.textColor == null ? new GrayColor(0) : this.textColor;
        pdfAppearance.setColorFill(new Color(10, 36, 106));
        pdfAppearance.rectangle(f3, f3 + f2 - (float)(n - n3 + 1) * f4, this.box.width() - 2.0f * f3, f4);
        pdfAppearance.fill();
        pdfAppearance.beginText();
        pdfAppearance.setFontAndSize(baseFont, f);
        pdfAppearance.setLeading(f4);
        pdfAppearance.moveText(f3 * 2.0f, f3 + f2 - baseFont.getFontDescriptor(8, f) + f4);
        pdfAppearance.setColorFill(color);
        for (int i = n3; i < n4; ++i) {
            if (i == n) {
                pdfAppearance.setGrayFill(1.0f);
                pdfAppearance.newlineShowText(this.choices[i]);
                pdfAppearance.setColorFill(color);
                continue;
            }
            pdfAppearance.newlineShowText(this.choices[i]);
        }
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    public PdfFormField getTextField() throws IOException, DocumentException {
        if (this.maxCharacterLength <= 0) {
            this.options &= 0xFFFFFEFF;
        }
        if ((this.options & 0x100) != 0) {
            this.options &= 0xFFFFFFFB;
        }
        PdfFormField pdfFormField = PdfFormField.createTextField(this.writer, false, false, this.maxCharacterLength);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        switch (this.alignment) {
            case 1: {
                pdfFormField.setQuadding(1);
                break;
            }
            case 2: {
                pdfFormField.setQuadding(2);
            }
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            pdfFormField.setValueAsString(this.text);
            if (this.defaultText != null) {
                pdfFormField.setDefaultValueAsString(this.defaultText);
            }
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
            if ((this.options & 4) != 0) {
                pdfFormField.setFieldFlags(4096);
            }
            if ((this.options & 8) != 0) {
                pdfFormField.setFieldFlags(0x800000);
            }
            if ((this.options & 0x10) != 0) {
                pdfFormField.setFieldFlags(8192);
            }
            if ((this.options & 0x20) != 0) {
                pdfFormField.setFieldFlags(0x100000);
            }
            if ((this.options & 0x40) != 0) {
                pdfFormField.setFieldFlags(0x400000);
            }
            if ((this.options & 0x100) != 0) {
                pdfFormField.setFieldFlags(0x1000000);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance pdfAppearance = this.getAppearance();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        return pdfFormField;
    }

    public PdfFormField getComboField() throws IOException, DocumentException {
        return this.getChoiceField(false);
    }

    public PdfFormField getListField() throws IOException, DocumentException {
        return this.getChoiceField(true);
    }

    protected PdfFormField getChoiceField(boolean bl) throws IOException, DocumentException {
        PdfAppearance pdfAppearance;
        int n;
        this.options &= 0xFFFFFEFB;
        String[] stringArray = this.choices;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if ((n = this.choiceSelection) >= stringArray.length) {
            n = stringArray.length - 1;
        }
        this.text = "";
        if (n >= 0) {
            this.text = stringArray[n];
        }
        if (n < 0) {
            n = 0;
        }
        PdfFormField pdfFormField = null;
        String[][] stringArray2 = null;
        if (this.choiceExports == null) {
            pdfFormField = bl ? PdfFormField.createList(this.writer, stringArray, n) : PdfFormField.createCombo(this.writer, (this.options & 0x80) != 0, stringArray, n);
        } else {
            int n2;
            stringArray2 = new String[stringArray.length][2];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                String string = stringArray[n2];
                stringArray2[n2][1] = string;
                stringArray2[n2][0] = string;
            }
            n2 = Math.min(stringArray.length, this.choiceExports.length);
            for (int i = 0; i < n2; ++i) {
                if (this.choiceExports[i] == null) continue;
                stringArray2[i][0] = this.choiceExports[i];
            }
            pdfFormField = bl ? PdfFormField.createList(this.writer, stringArray2, n) : PdfFormField.createCombo(this.writer, (this.options & 0x80) != 0, stringArray2, n);
        }
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if (stringArray.length > 0) {
                if (stringArray2 != null) {
                    pdfFormField.setValueAsString(stringArray2[n][0]);
                    pdfFormField.setDefaultValueAsString(stringArray2[n][0]);
                } else {
                    pdfFormField.setValueAsString(this.text);
                    pdfFormField.setDefaultValueAsString(this.text);
                }
            }
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
            if ((this.options & 0x40) != 0) {
                pdfFormField.setFieldFlags(0x400000);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        if (bl) {
            pdfAppearance = this.getListAppearance();
            if (this.topFirst > 0) {
                pdfFormField.put(PdfName.TI, new PdfNumber(this.topFirst));
            }
        } else {
            pdfAppearance = this.getAppearance();
        }
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        return pdfFormField;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String string) {
        this.defaultText = string;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public void setChoices(String[] stringArray) {
        this.choices = stringArray;
    }

    public String[] getChoiceExports() {
        return this.choiceExports;
    }

    public void setChoiceExports(String[] stringArray) {
        this.choiceExports = stringArray;
    }

    public int getChoiceSelection() {
        return this.choiceSelection;
    }

    public void setChoiceSelection(int n) {
        this.choiceSelection = n;
    }

    int getTopFirst() {
        return this.topFirst;
    }
}

