/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunFileReader;
import com.sun.media.sound.WaveFileFormat;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaveFileReader
extends SunFileReader {
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};

    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFormat format = null;
        WaveFileFormat fileFormat = null;
        int maxReadLength = 12;
        int magic = 0;
        int length = 0;
        int totallength = 0;
        int waveMagic = 0;
        DataInputStream dis = new DataInputStream(stream);
        dis.mark(maxReadLength);
        magic = dis.readInt();
        length = this.rllong(dis);
        waveMagic = dis.readInt();
        if (length <= 0) {
            length = -1;
            totallength = -1;
        } else {
            totallength = length + 8;
        }
        if (magic != 1380533830 || waveMagic != 1463899717) {
            dis.reset();
            throw new UnsupportedAudioFileException("not a WAVE file");
        }
        format = new AudioFormat(-1.0f, -1, -1, true, false);
        fileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, totallength, format, -1);
        dis.reset();
        return fileFormat;
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream urlStream = null;
        BufferedInputStream bis = null;
        AudioFileFormat fileFormat = null;
        AudioFormat format = null;
        urlStream = url.openStream();
        bis = new BufferedInputStream(urlStream, 4096);
        fileFormat = this.getAudioFileFormat(bis);
        format = this.getFMT(bis, fileFormat.getFormat());
        fileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, fileFormat.getByteLength(), format, -1);
        bis.close();
        return fileFormat;
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        AudioFileFormat fileFormat = null;
        AudioFormat format = null;
        fis = new FileInputStream(file);
        bis = new BufferedInputStream(fis, 4096);
        fileFormat = this.getAudioFileFormat(bis);
        format = this.getFMT(bis, fileFormat.getFormat());
        fileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, fileFormat.getByteLength(), format, -1);
        bis.close();
        return fileFormat;
    }

    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        int length;
        DataInputStream dis = null;
        int nread = 0;
        AudioFileFormat fileFormat = null;
        AudioFormat format = null;
        fileFormat = this.getAudioFileFormat(stream);
        dis = new DataInputStream(stream);
        format = this.getFMT(dis, fileFormat.getFormat());
        while (true) {
            try {
                int datahdr = dis.readInt();
                nread += 4;
                if (datahdr == 1684108385) break;
                length = this.rllong(dis);
                nread += 4;
                if (length % 2 > 0) {
                    ++length;
                }
                nread += dis.skipBytes(length);
            }
            catch (EOFException eof) {
                throw new UnsupportedAudioFileException("Not a valid WAV file");
            }
        }
        length = this.rllong(dis);
        nread += 4;
        return new AudioInputStream(dis, format, length / format.getFrameSize());
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream urlStream = null;
        BufferedInputStream bis = null;
        Object fileFormat = null;
        urlStream = url.openStream();
        bis = new BufferedInputStream(urlStream, 4096);
        return this.getAudioInputStream(bis);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        Object fileFormat = null;
        fis = new FileInputStream(file);
        bis = new BufferedInputStream(fis, 4096);
        return this.getAudioInputStream(bis);
    }

    private AudioFormat getFMT(InputStream stream, AudioFormat audioFormat) throws UnsupportedAudioFileException, IOException {
        int nread = 0;
        int length = 0;
        short wav_type = 0;
        AudioFormat.Encoding encoding = null;
        DataInputStream dis = new DataInputStream(stream);
        dis.readInt();
        dis.readInt();
        dis.readInt();
        while (true) {
            try {
                int fmt = dis.readInt();
                nread += 4;
                if (fmt == 1718449184) break;
                length = this.rllong(dis);
                nread += 4;
                if (length % 2 > 0) {
                    ++length;
                }
                nread += dis.skipBytes(length);
            }
            catch (EOFException eof) {
                throw new UnsupportedAudioFileException("Not a valid WAV file");
            }
        }
        length = this.rllong(dis);
        int endLength = (nread += 4) + length;
        wav_type = this.rlshort(dis);
        nread += 2;
        if (wav_type == 1) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        } else if (wav_type == 6) {
            encoding = AudioFormat.Encoding.ALAW;
        } else if (wav_type == 7) {
            encoding = AudioFormat.Encoding.ULAW;
        } else {
            throw new UnsupportedAudioFileException("Not a supported WAV file");
        }
        short channels = this.rlshort(dis);
        nread += 2;
        long sampleRate = this.rllong(dis);
        nread += 4;
        long avgBytesPerSec = this.rllong(dis);
        nread += 4;
        short blockAlign = this.rlshort(dis);
        nread += 2;
        short sampleSizeInBits = this.rlshort(dis);
        nread += 2;
        if (sampleSizeInBits == 8 && encoding == AudioFormat.Encoding.PCM_SIGNED) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (length % 2 != 0) {
            ++length;
        }
        if (endLength > nread) {
            nread += dis.skipBytes(endLength - nread);
        }
        return new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, sampleSizeInBits * channels / 8, sampleRate, false);
    }
}

