/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.MidiInDeviceProvider;
import com.sun.media.sound.Printer;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;

class MidiInDevice
extends AbstractMidiDevice
implements Runnable {
    private static Thread midiInThread = null;
    private static Vector devices = new Vector();
    ShortMessage shortMessage = new ShortMessage();
    private Vector transmitters = new Vector();

    MidiInDevice(MidiInDeviceProvider.MidiInDeviceInfo info) {
        super(info);
        if (Printer.trace) {
            Printer.trace(">> MidiInDevice CONSTRUCTOR");
        }
        if (Printer.trace) {
            Printer.trace("<< MidiInDevice CONSTRUCTOR completed");
        }
    }

    synchronized void implOpen() throws MidiUnavailableException {
        this.id = this.nOpen(((MidiInDeviceProvider.MidiInDeviceInfo)this.getDeviceInfo()).getIndex());
        if (this.id == 0) {
            throw new MidiUnavailableException("Unable to open native device");
        }
        devices.addElement(this);
        if (midiInThread == null) {
            midiInThread = new Thread(this);
            midiInThread.start();
        }
        try {
            this.nStart(this.id);
        }
        catch (MidiUnavailableException e) {
            devices.removeElement(this);
            throw e;
        }
    }

    synchronized void implClose() {
        int i = 0;
        while (i < this.transmitters.size()) {
            ((Transmitter)this.transmitters.elementAt(i)).close();
            ++i;
        }
        this.transmitters.removeAllElements();
        devices.removeElement(this);
        int oldId = this.id;
        this.id = 0;
        this.nStop(oldId);
        this.nClose(oldId);
    }

    public int getMaxTransmitters() {
        return -1;
    }

    public synchronized Transmitter getTransmitter() throws MidiUnavailableException {
        MidiInTransmitter transmitter = new MidiInTransmitter();
        this.transmitters.addElement(transmitter);
        return transmitter;
    }

    public void run() {
        while (!devices.isEmpty()) {
            this.nGetMessages();
        }
        midiInThread = null;
    }

    void callbackShortMessage(int status, int data1, int data2, long timeStamp) {
        if (Printer.verbose) {
            Printer.verbose(">> MidiInDevice callbackShortMessage: status: " + status + " data1: " + data1 + " data2: " + data2 + " timeStamp: " + timeStamp);
        }
        try {
            this.shortMessage.setMessage(status, data1, data2);
        }
        catch (InvalidMidiDataException e) {
            return;
        }
        Vector vector = this.transmitters;
        synchronized (vector) {
            if (Printer.verbose) {
                Printer.verbose(">> MidiInDevice callbackShortMessage: sending message: " + this.shortMessage.toString() + " timeStamp: " + timeStamp);
            }
            int i = 0;
            while (i < this.transmitters.size()) {
                Receiver receiver = ((Transmitter)this.transmitters.elementAt(i)).getReceiver();
                if (receiver != null) {
                    receiver.send(this.shortMessage, timeStamp);
                }
                ++i;
            }
        }
    }

    private native int nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(int var1);

    private native void nStart(int var1) throws MidiUnavailableException;

    private native void nStop(int var1);

    private native void nGetMessages();

    class MidiInTransmitter
    implements Transmitter {
        private boolean open = true;
        private Receiver receiver = null;

        MidiInTransmitter() {
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void close() {
            MidiInDevice.this.transmitters.removeElement(this);
            this.open = false;
        }
    }
}

