/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.MixerClip;
import com.sun.media.sound.MixerSourceLine;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Printer;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.EnumControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.ReverbType;

class HeadspaceMixer
extends AbstractMixer {
    public static final int INTERPOLATION_DROP_SAMPLE = 0;
    public static final int INTERPOLATION_2_POINT = 1;
    public static final int INTERPOLATION_LINEAR = 2;
    private static int TOTAL_VOICES;
    private static int DEFAULT_BUFFER_SIZE;
    static final int MAX_SAMPLES = 0x100000;
    static final int MAX_FRAME_SIZE = 4;
    private static final AudioFormat.Encoding encoding8;
    private static final AudioFormat.Encoding encoding16;
    private static final AudioFormat[] mixFormats;
    private static final AudioFormat[] sourceLineFormats;
    private DataLine.Info sourceDataLineInfo = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = HeadspaceMixer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, sourceLineFormats, 0, -1);
    private final DataLine.Info clipInfo = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = HeadspaceMixer.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, sourceLineFormats, 0, 0x400000);
    private final DataLine.Info[] supportedInGroup = new DataLine.Info[]{this.sourceDataLineInfo, this.clipInfo};
    private final DataLine.Info targetDeviceLineInfo = new DataLine.Info(class$javax$sound$sampled$DataLine == null ? (class$javax$sound$sampled$DataLine = HeadspaceMixer.class$("javax.sound.sampled.DataLine")) : class$javax$sound$sampled$DataLine, mixFormats, 0, -1);
    private static final AudioFormat defaultFormat;
    private static final int defaultMixLevel = 6;
    private static final int defaultInterpolationMode = 2;
    private int sampledVoices;
    private int midiVoices;
    private int mixLevel;
    private int terpMode;
    Vector openMidiDevices = new Vector();
    private static final HeadspaceMixer mixerInstance;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;
    static /* synthetic */ Class class$javax$sound$sampled$DataLine;
    static /* synthetic */ Class class$com$sun$media$sound$MixerSourceLine;
    static /* synthetic */ Class class$com$sun$media$sound$MixerClip;

    private HeadspaceMixer() {
        super(null, new Control[1], defaultFormat, DEFAULT_BUFFER_SIZE, new MixerInfo(), null, null);
        this.info = new DataLine.Info(class$javax$sound$sampled$DataLine == null ? (class$javax$sound$sampled$DataLine = HeadspaceMixer.class$("javax.sound.sampled.DataLine")) : class$javax$sound$sampled$DataLine, mixFormats, DEFAULT_BUFFER_SIZE, DEFAULT_BUFFER_SIZE);
        if (Printer.trace) {
            Printer.trace("HeadspaceMixer: constructor");
        }
        Platform.initialize();
        TOTAL_VOICES = HeadspaceMixer.nGetTotalVoices();
        DEFAULT_BUFFER_SIZE = HeadspaceMixer.nGetDefaultBufferSize();
        if (DEFAULT_BUFFER_SIZE == 0) {
            DEFAULT_BUFFER_SIZE = -1;
        }
        this.controls[0] = new MixerReverbControl();
        this.sourceLineInfo = new Line.Info[2];
        this.sourceLineInfo[0] = this.sourceDataLineInfo;
        this.sourceLineInfo[1] = this.clipInfo;
        this.targetLineInfo = new DataLine.Info[1];
        this.targetLineInfo[0] = this.targetDeviceLineInfo;
        this.sampledVoices = TOTAL_VOICES / 2;
        this.midiVoices = TOTAL_VOICES / 2;
        this.mixLevel = 6;
        this.terpMode = 2;
        if (Printer.trace) {
            Printer.trace("HeadspaceMixer: constructor completed");
        }
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info fullInfo = this.getLineInfo(info);
        if (fullInfo == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (fullInfo instanceof DataLine.Info) {
            AudioFormat lineFormat;
            DataLine.Info dataLineInfo = (DataLine.Info)fullInfo;
            int lineBufferSize = -1;
            AudioFormat[] supportedFormats = null;
            if (info instanceof DataLine.Info) {
                supportedFormats = ((DataLine.Info)info).getFormats();
                lineBufferSize = ((DataLine.Info)info).getMaxBufferSize();
            }
            if (supportedFormats == null || supportedFormats.length == 0) {
                supportedFormats = dataLineInfo.getFormats();
            }
            if ((lineFormat = supportedFormats[supportedFormats.length - 1]).getSampleRate() == -1.0f) {
                lineFormat = new AudioFormat(lineFormat.getEncoding(), this.getFormat().getSampleRate(), lineFormat.getSampleSizeInBits(), lineFormat.getChannels(), lineFormat.getFrameSize(), lineFormat.getFrameRate(), lineFormat.isBigEndian());
            }
            if (lineBufferSize == -1) {
                lineBufferSize = dataLineInfo.getMaxBufferSize();
            }
            if (dataLineInfo.getLineClass().isAssignableFrom(class$com$sun$media$sound$MixerSourceLine == null ? (class$com$sun$media$sound$MixerSourceLine = HeadspaceMixer.class$("com.sun.media.sound.MixerSourceLine")) : class$com$sun$media$sound$MixerSourceLine)) {
                return new MixerSourceLine(this.sourceDataLineInfo, this, lineFormat, lineBufferSize);
            }
            if (dataLineInfo.getLineClass().isAssignableFrom(class$com$sun$media$sound$MixerClip == null ? (class$com$sun$media$sound$MixerClip = HeadspaceMixer.class$("com.sun.media.sound.MixerClip")) : class$com$sun$media$sound$MixerClip)) {
                return new MixerClip(this.clipInfo, this, lineFormat, lineBufferSize);
            }
        }
        throw new SecurityException("Access to line not granted: " + info);
    }

    public int getMaxLines(Line.Info info) {
        Line.Info fullInfo = this.getLineInfo(info);
        if (fullInfo == null) {
            return 0;
        }
        if (fullInfo instanceof DataLine.Info && this.isSourceLine(fullInfo)) {
            return this.sampledVoices;
        }
        if (fullInfo instanceof DataLine.Info && this.isTargetLine(fullInfo)) {
            return 1;
        }
        return 0;
    }

    public void implOpen(AudioFormat format, int bufferSize) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> HeadspaceMixer: implOpen");
        }
        this.nOpenMixer(format.getSampleSizeInBits(), format.getChannels(), (int)format.getSampleRate(), this.terpMode, this.midiVoices, this.sampledVoices, this.mixLevel);
        this.nResume();
        this.format = format;
        this.bufferSize = HeadspaceMixer.nGetDefaultBufferSize();
        if (this.bufferSize <= 0) {
            this.bufferSize = -1;
        }
        if (Printer.trace) {
            Printer.trace("<< HeadspaceMixer: implOpen succeeded");
        }
    }

    public void implClose() {
        if (Printer.trace) {
            Printer.trace(">> HeadspaceMixer: implClose");
        }
        this.nPause();
        this.nCloseMixer();
        if (Printer.trace) {
            Printer.trace("<< HeadspaceMixer: implClose succeeded");
        }
    }

    void implStart() {
        if (Printer.trace) {
            Printer.trace(">> HeadspaceMixer: implStart");
        }
        this.setActive(true);
        this.setStarted(true);
        if (Printer.trace) {
            Printer.trace("<< HeadspaceMixer: implStart succeeded");
        }
    }

    void implStop() {
        if (Printer.trace) {
            Printer.trace(">> HeadspaceMixer: implStop");
        }
        this.setActive(false);
        this.setStarted(false);
        if (Printer.trace) {
            Printer.trace("<< HeadspaceMixer: implStop succeeded");
        }
    }

    public int getSystemVoices() {
        return TOTAL_VOICES;
    }

    public int getMidiVoices() {
        return this.midiVoices;
    }

    public int getSampledVoices() {
        return this.sampledVoices;
    }

    public boolean allocateVoices(int midi, int sampled) {
        if (!this.nAllocateVoices(midi, sampled)) {
            return false;
        }
        this.midiVoices = midi;
        this.sampledVoices = sampled;
        return true;
    }

    public boolean setMixLevel(int mixLevel) {
        if (!this.nSetMixLevel(mixLevel)) {
            return false;
        }
        this.mixLevel = mixLevel;
        return true;
    }

    public int getMixLevel() {
        return this.mixLevel;
    }

    public boolean setInterpolationMode(int terpMode) {
        if (!this.nSetInterpolation(terpMode)) {
            return false;
        }
        this.terpMode = terpMode;
        return true;
    }

    public int getInterpolationMode() {
        return this.terpMode;
    }

    public float getCpuLoad() {
        return this.nGetCpuLoad();
    }

    void open(MidiDevice mididevice) throws MidiUnavailableException {
        if (!this.openMidiDevices.contains(mididevice)) {
            this.openMidiDevices.addElement(mididevice);
            try {
                this.open();
                this.start();
            }
            catch (LineUnavailableException e) {
                this.openMidiDevices.removeElement(mididevice);
                throw new MidiUnavailableException(e.getMessage());
            }
        }
    }

    void close(MidiDevice mididevice) {
        this.openMidiDevices.removeElement(mididevice);
        Line line = null;
        this.stop(line);
        this.close(line);
    }

    protected void close(Line line) {
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty() && this.openMidiDevices.isEmpty()) {
            this.close();
        }
    }

    protected void stop(Line line) {
        if (this.equals(line)) {
            return;
        }
        Vector vector = this.sourceLines;
        synchronized (vector) {
            int i = 0;
            while (i < this.sourceLines.size()) {
                AbstractDataLine sourceLine;
                if (this.sourceLines.elementAt(i) instanceof AbstractDataLine && (sourceLine = (AbstractDataLine)this.sourceLines.elementAt(i)).isStartedRunning() && !sourceLine.equals(line)) {
                    return;
                }
                ++i;
            }
        }
        Vector vector2 = this.targetLines;
        synchronized (vector2) {
            int i = 0;
            while (i < this.targetLines.size()) {
                AbstractDataLine targetLine = (AbstractDataLine)this.targetLines.elementAt(i);
                if (targetLine.isStartedRunning() && !targetLine.equals(line)) {
                    return;
                }
                ++i;
            }
        }
        if (!this.openMidiDevices.isEmpty()) {
            return;
        }
        this.stop();
    }

    static HeadspaceMixer getMixerInstance() {
        return mixerInstance;
    }

    private native void nOpenMixer(int var1, int var2, int var3, int var4, int var5, int var6, int var7) throws LineUnavailableException;

    private native void nCloseMixer();

    private native void nPause();

    private native void nResume() throws LineUnavailableException;

    private native void nDrain();

    private native void nFlush();

    private native long nGetPosition();

    private native float nGetLevel();

    private native boolean nSetMixerFormat(int var1, int var2, int var3);

    private native boolean nAllocateVoices(int var1, int var2);

    private native boolean nSetMixLevel(int var1);

    private native boolean nSetInterpolation(int var1);

    private native float nGetCpuLoad();

    private static native int nGetTotalVoices();

    private native int nCreateLinkedStreams(int[] var1);

    private native boolean nStartLinkedStreams(int var1);

    private native void nStopLinkedStreams(int var1);

    private static native int nGetDefaultBufferSize();

    private static native int nSetReverb(int var0);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_BUFFER_SIZE = -1;
        encoding8 = Platform.isSigned8() ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
        encoding16 = AudioFormat.Encoding.PCM_SIGNED;
        mixFormats = new AudioFormat[]{new AudioFormat(encoding8, 11025.0f, 8, 1, 1, 11025.0f, false), new AudioFormat(encoding8, 11025.0f, 8, 2, 2, 11025.0f, false), new AudioFormat(encoding16, 11025.0f, 16, 1, 2, 11025.0f, false), new AudioFormat(encoding16, 11025.0f, 16, 2, 4, 11025.0f, false), new AudioFormat(encoding8, 11025.0f, 8, 1, 1, 11025.0f, true), new AudioFormat(encoding8, 11025.0f, 8, 2, 2, 11025.0f, true), new AudioFormat(encoding16, 11025.0f, 16, 1, 2, 11025.0f, true), new AudioFormat(encoding16, 11025.0f, 16, 2, 4, 11025.0f, true), new AudioFormat(encoding8, 22050.0f, 8, 1, 1, 22050.0f, false), new AudioFormat(encoding8, 22050.0f, 8, 2, 2, 22050.0f, false), new AudioFormat(encoding16, 22050.0f, 16, 1, 2, 22050.0f, false), new AudioFormat(encoding16, 22050.0f, 16, 2, 4, 22050.0f, false), new AudioFormat(encoding8, 22050.0f, 8, 1, 1, 22050.0f, true), new AudioFormat(encoding8, 22050.0f, 8, 2, 2, 22050.0f, true), new AudioFormat(encoding16, 22050.0f, 16, 1, 2, 22050.0f, true), new AudioFormat(encoding16, 22050.0f, 16, 2, 4, 22050.0f, true), new AudioFormat(encoding8, 44100.0f, 8, 1, 1, 44100.0f, false), new AudioFormat(encoding8, 44100.0f, 8, 2, 2, 44100.0f, false), new AudioFormat(encoding16, 44100.0f, 16, 1, 2, 44100.0f, false), new AudioFormat(encoding16, 44100.0f, 16, 2, 4, 44100.0f, false), new AudioFormat(encoding8, 44100.0f, 8, 1, 1, 44100.0f, true), new AudioFormat(encoding8, 44100.0f, 8, 2, 2, 44100.0f, true), new AudioFormat(encoding16, 44100.0f, 16, 1, 2, 44100.0f, true), new AudioFormat(encoding16, 44100.0f, 16, 2, 4, 44100.0f, true)};
        sourceLineFormats = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 1, 1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 1, 1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 2, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 2, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, false)};
        defaultFormat = mixFormats.length > 0 ? mixFormats[mixFormats.length - 1] : null;
        mixerInstance = new HeadspaceMixer();
    }

    private static class MixerReverbControl
    extends EnumControl {
        private static final MixerReverbType NO_REVERB = new MixerReverbType("No Reverb", 0, 0.0f, 0, 0.0f, 0, 1);
        private static final MixerReverbType CLOSET = new MixerReverbType("Closet", 600, -7.0f, 2500, -10.0f, 150000, 2);
        private static final MixerReverbType GARAGE = new MixerReverbType("Garage", 3900, -4.0f, 14700, -6.0f, 900000, 3);
        private static final MixerReverbType ACOUSTIC_LAB = new MixerReverbType("Acoustic Lab", 2000, -2.0f, 8000, -3.0f, 280000, 4);
        private static final MixerReverbType CAVERN = new MixerReverbType("Cavern", 10300, -1.4f, 41300, -2.0f, 2250000, 5);
        private static final MixerReverbType DUNGEON = new MixerReverbType("Dungeon", 2600, -0.7f, 10300, -1.0f, 1600000, 6);
        private static final ReverbType[] types = new ReverbType[]{NO_REVERB, CLOSET, GARAGE, ACOUSTIC_LAB, CAVERN, DUNGEON};
        private static final ReverbType defaultReverb = ACOUSTIC_LAB;

        private MixerReverbControl() {
            super(EnumControl.Type.REVERB, types, defaultReverb);
        }

        public void setValue(Object value) {
            int reverbMode;
            if (Printer.trace) {
                Printer.trace("HeadspaceMixer: MixerReverbControl: setValue: " + value.toString());
            }
            if (!(value instanceof ReverbType)) {
                throw new IllegalArgumentException("Value must be of type ReverbType");
            }
            ReverbType reverbType = (ReverbType)value;
            if (reverbType instanceof MixerReverbType) {
                reverbMode = ((MixerReverbType)reverbType).getReverbMode();
            } else if (value == NO_REVERB) {
                reverbMode = 1;
            } else {
                throw new IllegalArgumentException("Unknown reverb value: " + value);
            }
            int reverbSet = HeadspaceMixer.nSetReverb(reverbMode);
            if (reverbSet == reverbMode) {
                if (Printer.trace) {
                    Printer.trace("HeadspaceMixer: setReverb succeeded: " + value.toString());
                }
                super.setValue(value);
            } else {
                if (Printer.err) {
                    Printer.err("HeadspaceMixer: MixerReverbControl: setValue failed: value: " + value.toString() + " set mode: " + reverbMode + " returned mode: " + reverbSet);
                }
                if (reverbSet != 1) {
                    int i = 0;
                    while (i < types.length) {
                        if (types[i] instanceof MixerReverbType && ((MixerReverbType)MixerReverbControl.types[i]).getReverbMode() == reverbSet) {
                            super.setValue(types[i]);
                        }
                        ++i;
                    }
                }
            }
        }

        private void initializeReverb() {
            block3: {
                try {
                    this.setValue(defaultReverb);
                    if (Printer.trace) {
                        Printer.trace("Initialized reverb to: " + this.getValue());
                    }
                }
                catch (IllegalArgumentException e) {
                    this.setValue(NO_REVERB);
                    if (!Printer.err) break block3;
                    Printer.err("Failed to initialize reverb to: " + defaultReverb + "; set reverb to: " + this.getValue());
                }
            }
        }

        private static class MixerReverbType
        extends ReverbType {
            private final int reverbMode;

            private MixerReverbType(String name, int earlyReflectionDelay, float earlyReflectionIntensity, int lateReflectionDelay, float lateReflectionIntensity, int decayTime, int reverbMode) {
                super(name, earlyReflectionDelay, earlyReflectionIntensity, lateReflectionDelay, lateReflectionIntensity, decayTime);
                this.reverbMode = reverbMode;
            }

            private int getReverbMode() {
                return this.reverbMode;
            }
        }
    }

    private static class MixerInfo
    extends Mixer.Info {
        private static final String name = "Java Sound Audio Engine";
        private static final String vendor = "Sun Microsystems";
        private static final String description = "Software mixer and synthesizer";
        private static final String version = "1.0";

        private MixerInfo() {
            super(name, vendor, description, version);
        }
    }
}

