/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AiffFileFormat;
import com.sun.media.sound.SunFileReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AiffFileReader
extends SunFileReader {
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.AIFF};

    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFormat format = null;
        AiffFileFormat fileFormat = null;
        int maxReadLength = 8;
        int magic = 0;
        int length = 0;
        int totallength = 0;
        DataInputStream dis = new DataInputStream(stream);
        dis.mark(maxReadLength);
        magic = dis.readInt();
        length = dis.readInt();
        if (magic != 1179603533) {
            dis.reset();
            throw new UnsupportedAudioFileException("not an AIFF file");
        }
        if (length <= 0) {
            length = -1;
            totallength = -1;
        } else {
            totallength = length + 8;
        }
        format = new AudioFormat(-1.0f, -1, -1, true, true);
        fileFormat = new AiffFileFormat(AudioFileFormat.Type.AIFF, totallength, format, -1);
        dis.reset();
        return fileFormat;
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream urlStream = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        AudioFileFormat fileFormat = null;
        Object format = null;
        urlStream = url.openStream();
        bis = new BufferedInputStream(urlStream, 4096);
        fileFormat = this.getAudioFileFormat(bis);
        dis = new DataInputStream(bis);
        fileFormat = this.getCOMM(dis, fileFormat);
        bis.close();
        return fileFormat;
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        AudioFileFormat fileFormat = null;
        Object format = null;
        fis = new FileInputStream(file);
        bis = new BufferedInputStream(fis, 4096);
        fileFormat = this.getAudioFileFormat(bis);
        dis = new DataInputStream(bis);
        fileFormat = this.getCOMM(dis, fileFormat);
        bis.close();
        return fileFormat;
    }

    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        DataInputStream dis = null;
        boolean nread = false;
        AudioFileFormat fileFormat = null;
        fileFormat = this.getAudioFileFormat(stream);
        dis = new DataInputStream(stream);
        fileFormat = this.getCOMM(dis, fileFormat);
        return new AudioInputStream(dis, fileFormat.getFormat(), fileFormat.getFrameLength());
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream urlStream = null;
        BufferedInputStream bis = null;
        Object fileFormat = null;
        urlStream = url.openStream();
        bis = new BufferedInputStream(urlStream, 4096);
        return this.getAudioInputStream(bis);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        Object fileFormat = null;
        fis = new FileInputStream(file);
        bis = new BufferedInputStream(fis, 4096);
        return this.getAudioInputStream(bis);
    }

    private AudioFileFormat getCOMM(DataInputStream dis, AudioFileFormat fileFormat) throws UnsupportedAudioFileException, IOException {
        AudioFormat.Encoding encoding = null;
        float sampleRate = -1.0f;
        int sampleSizeInBits = -1;
        int channels = -1;
        int frameSize = -1;
        float frameRate = -1.0f;
        boolean bigendian = true;
        int nread = 0;
        boolean aifc = false;
        byte[] bytes = new byte[4];
        int magic = dis.readInt();
        nread += 4;
        int length = dis.readInt();
        nread += 4;
        int res = dis.read(bytes, 0, 4);
        if (res != 4) {
            throw new IOException("Stream read error");
        }
        nread += 4;
        String s = new String(bytes);
        if (s.startsWith("AIFC")) {
            aifc = true;
        }
        while (true) {
            int chunksize;
            int temp = dis.readInt();
            bytes[0] = (byte)(temp >> 24 & 0xFF);
            bytes[1] = (byte)(temp >> 16 & 0xFF);
            bytes[2] = (byte)(temp >> 8 & 0xFF);
            bytes[3] = (byte)(temp & 0xFF);
            s = new String(bytes);
            if (s.startsWith("FVER")) {
                dis.readLong();
                nread += 8;
                continue;
            }
            if (s.startsWith("COMM")) {
                chunksize = dis.readInt();
                nread += 4;
                if (chunksize != 18 && chunksize != 34) {
                    throw new UnsupportedAudioFileException("Invalid AIFF chunksize");
                }
                channels = dis.readShort();
                nread += 2;
                dis.readInt();
                nread += 4;
                sampleSizeInBits = dis.readShort();
                nread += 2;
                sampleRate = (float)this.read_ieee_extended(dis);
                nread += 10;
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                if (!aifc) continue;
                dis.read(bytes, 0, 4);
                nread += 4;
                s = new String(bytes);
                if (s.startsWith("NONE")) {
                    encoding = AudioFormat.Encoding.PCM_SIGNED;
                    continue;
                }
                if (s.startsWith("ULAW")) {
                    encoding = AudioFormat.Encoding.ULAW;
                    continue;
                }
                if (s.startsWith("ALAW")) {
                    encoding = AudioFormat.Encoding.ALAW;
                    continue;
                }
                throw new UnsupportedAudioFileException("Invalid AIFF encoding");
            }
            if (s.startsWith("SSND")) {
                chunksize = dis.readInt();
                nread += 4;
                int i = dis.readInt();
                nread += 4;
                int blocksize = dis.readInt();
                nread += 4;
                if (chunksize < length) {
                    length = chunksize - 8;
                    break;
                }
                length -= nread;
                break;
            }
            chunksize = dis.readInt();
            nread += 4;
            nread += dis.skipBytes(chunksize);
        }
        switch (sampleSizeInBits) {
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        int offset = nread;
        frameSize = sampleSizeInBits / 8 * channels;
        frameRate = sampleRate;
        if (sampleSizeInBits == 8) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        }
        AudioFormat format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, true);
        return new AiffFileFormat(AudioFileFormat.Type.AIFF, fileFormat.getByteLength(), format, length / frameSize);
    }

    private void write_ieee_extended(DataOutputStream dos, double f) throws IOException {
        int exponent = 16398;
        double highMantissa = f;
        while (highMantissa < 44000.0) {
            highMantissa *= 2.0;
            --exponent;
        }
        dos.writeShort(exponent);
        dos.writeInt((int)highMantissa << 16);
        dos.writeInt(0);
    }

    private double read_ieee_extended(DataInputStream dis) throws IOException {
        double f = 0.0;
        int expon = 0;
        long hiMant = 0L;
        long loMant = 0L;
        double HUGE = 3.4028234663852886E38;
        expon = dis.readUnsignedShort();
        long t1 = dis.readUnsignedShort();
        long t2 = dis.readUnsignedShort();
        hiMant = t1 << 16 | t2;
        t1 = dis.readUnsignedShort();
        t2 = dis.readUnsignedShort();
        loMant = t1 << 16 | t2;
        if (expon == 0 && hiMant == 0L && loMant == 0L) {
            f = 0.0;
        } else if (expon == Short.MAX_VALUE) {
            f = HUGE;
        } else {
            expon -= 16383;
            f = (double)hiMant * Math.pow(2.0, expon -= 31);
            f += (double)loMant * Math.pow(2.0, expon -= 32);
        }
        return f;
    }
}

