/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.BaseWindow;
import AbinitMp.Tool.ExampleFileFilter;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.vecmath.Matrix4f;

public class TranslateWindow
extends BaseWindow {
    private JTextField angleText = new JTextField("0", 5);
    private JTextField xText = new JTextField("0", 5);
    private JTextField yText = new JTextField("0", 5);
    private JTextField zText = new JTextField("0", 5);
    private JTextField scaleText = new JTextField("1", 5);
    private MyComboBox axisComboBox;
    private JFileChooser openFileChooser;
    private JFileChooser saveFileChooser;
    private AbinitMpViewer viewer;

    public TranslateWindow(AbinitMpViewer abinitMpViewer) {
        super(MyResourceBundle.getResourceString("TranslateWindow.Title"));
        this.viewer = abinitMpViewer;
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("pos", "View Position file");
        this.openFileChooser = new JFileChooser(".");
        this.openFileChooser.setPreferredSize(new Dimension(500, 500));
        FileFilter fileFilter = this.openFileChooser.getFileFilter();
        this.openFileChooser.addChoosableFileFilter(exampleFileFilter);
        this.openFileChooser.setFileFilter(fileFilter);
        this.saveFileChooser = new JFileChooser(".");
        this.saveFileChooser.setPreferredSize(new Dimension(500, 500));
        FileFilter fileFilter2 = this.saveFileChooser.getFileFilter();
        this.saveFileChooser.addChoosableFileFilter(exampleFileFilter);
        this.saveFileChooser.setFileFilter(fileFilter2);
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        this.getJMenuBar().add(this.addMenuItem("TranslateWindow.fileMenuTitle", "TranslateWindow.fileMenu", (Action)new fileListener()));
        GridBagLayoutPanel gridBagLayoutPanel = new GridBagLayoutPanel();
        MyPanel myPanel = new MyPanel(new FlowLayout(0));
        MyPanel myPanel2 = new MyPanel(new FlowLayout(0));
        MyPanel myPanel3 = new MyPanel(new FlowLayout(0));
        myPanel.setBorder(new TitledBorder(MyResourceBundle.getResourceString("TranslateWindow.rotation")));
        myPanel.add(new JLabel(MyResourceBundle.getResourceString("TranslateWindow.axis")));
        this.axisComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("TranslateWindow.axis.options"));
        myPanel.add(this.axisComboBox);
        myPanel.add(new JLabel(MyResourceBundle.getResourceString("TranslateWindow.angle")));
        myPanel.add(this.angleText);
        myPanel2.setBorder(new TitledBorder(MyResourceBundle.getResourceString("TranslateWindow.translation")));
        myPanel2.add(new JLabel("X"));
        myPanel2.add(this.xText);
        myPanel2.add(new JLabel("Y"));
        myPanel2.add(this.yText);
        myPanel2.add(new JLabel("Z"));
        myPanel2.add(this.zText);
        myPanel3.setBorder(new TitledBorder(MyResourceBundle.getResourceString("TranslateWindow.magnify")));
        myPanel3.add(new JLabel(MyResourceBundle.getResourceString("TranslateWindow.scale")));
        myPanel3.add(this.scaleText);
        gridBagLayoutPanel.layoutObject(myPanel, 0, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(myPanel2, 0, 1, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(myPanel3, 0, 2, 5, 1, 1.0, 0.0);
        MyPanel myPanel4 = new MyPanel(new FlowLayout(1));
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("apply"));
        myPanel4.add(myButton);
        myButton.addActionListener(new applyListener());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)gridBagLayoutPanel, "Center");
        this.mainPanel.add((Component)myPanel4, "South");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > 2000) {
            dimension.width /= 2;
        }
        this.setLocation(dimension.width - 240, 0);
    }

    private Matrix4f openFile(String string) {
        Matrix4f matrix4f = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            matrix4f = (Matrix4f)objectInputStream.readObject();
            fileInputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new Frame(), "Viewpoint File read error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
        return matrix4f;
    }

    private void saveFile(Matrix4f matrix4f, String string) {
        try {
            if (string.lastIndexOf(".") == -1) {
                string = string.concat(".pos");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(matrix4f);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new Frame(), "Viewpoint File save error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
    }

    class applyListener
    extends AbstractAction {
        applyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = TranslateWindow.this.axisComboBox.getSelectedIndex();
            float f = Float.parseFloat(TranslateWindow.this.angleText.getText());
            float f2 = Float.parseFloat(TranslateWindow.this.xText.getText());
            float f3 = Float.parseFloat(TranslateWindow.this.yText.getText());
            float f4 = Float.parseFloat(TranslateWindow.this.zText.getText());
            float f5 = Float.parseFloat(TranslateWindow.this.scaleText.getText());
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            switch (n) {
                case 0: {
                    f6 = 1.0f;
                    f7 = 0.0f;
                    f8 = 0.0f;
                    break;
                }
                case 1: {
                    f6 = 0.0f;
                    f7 = 1.0f;
                    f8 = 0.0f;
                    break;
                }
                case 2: {
                    f6 = 0.0f;
                    f7 = 0.0f;
                    f8 = 1.0f;
                    break;
                }
                case 3: {
                    f6 = 1.0f;
                    f7 = 1.0f;
                    f8 = 1.0f;
                }
            }
            TranslateWindow.this.viewer.setRotationTranslation(f6, f7, f8, f, f2, f3, f4, f5);
        }
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("TranslateWindow.fileMenu");
            char c = string.charAt(0);
            if (TranslateWindow.this.getNemonic(stringArray[0]) == c) {
                String string2;
                Matrix4f matrix4f;
                if (TranslateWindow.this.openFileChooser.showOpenDialog(null) == 0 && (matrix4f = TranslateWindow.this.openFile(string2 = TranslateWindow.this.openFileChooser.getSelectedFile().getPath())) != null) {
                    TranslateWindow.this.viewer.setViewPosition(matrix4f);
                }
            } else if (TranslateWindow.this.getNemonic(stringArray[1]) == c) {
                if (TranslateWindow.this.saveFileChooser.showSaveDialog(null) == 0) {
                    String string3 = TranslateWindow.this.saveFileChooser.getSelectedFile().getPath();
                    Matrix4f matrix4f = TranslateWindow.this.viewer.getViewPosition();
                    TranslateWindow.this.saveFile(matrix4f, string3);
                }
            } else if (TranslateWindow.this.getNemonic(stringArray[2]) == c) {
                TranslateWindow.this.setVisible(false);
            }
        }
    }
}

