/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.MoFile;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.MoGraphWindow;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.JComponent;

public class MoGraphPanel
extends JComponent {
    private MoFile moFile;
    private float min;
    private float max;
    private int xPitch = 70;
    private int width = 60;
    private int height = 3;
    private int maxLank = 1;
    private final int paneWidth = 160;
    private final int xMargine = 70;
    private final int yMargine = 20;
    private int paneHeight = 330;
    private float yPitch;
    private FileItem fileItem;
    private MoGraphWindow moGraphWindow;
    private final double epsiron = 1.0E-6;
    private energyItem[] energyList;
    private int magStep = 1;
    int[] posx;
    int[] posy;
    int[] lank;
    int[] colums;

    public MoGraphPanel(MoGraphWindow moGraphWindow, FileItem fileItem) {
        int n;
        this.moGraphWindow = moGraphWindow;
        this.fileItem = fileItem;
        this.moFile = (MoFile)fileItem.file;
        this.setBackground(Color.black);
        this.enableEvents(48L);
        this.min = (float)Math.floor(this.moFile.minEnergy);
        if (this.moFile.minEnergy - (double)this.min > 0.5) {
            this.min += 0.5f;
        }
        this.max = (float)Math.floor(this.moFile.maxEnergy);
        this.max = this.moFile.maxEnergy - (double)this.max > 0.5 ? (this.max += 1.0f) : (this.max += 0.5f);
        this.yPitch = (float)this.paneHeight / (this.max - this.min);
        this.posx = new int[this.moFile.energy.length];
        this.posy = new int[this.moFile.energy.length];
        this.lank = new int[this.moFile.energy.length];
        this.colums = new int[this.moFile.energy.length];
        this.energyList = new energyItem[this.moFile.energy.length];
        for (n = 0; n < this.moFile.energy.length; ++n) {
            this.energyList[n] = new energyItem(this.moFile.moNumber[n], this.moFile.energy[n]);
        }
        Arrays.sort(this.energyList);
        for (n = 1; n < this.energyList.length; ++n) {
            if (!(Math.abs(this.energyList[n - 1].energy - this.energyList[n].energy) < 1.0E-6)) continue;
            this.lank[n] = this.lank[n - 1] + 1;
            this.colums[n] = this.lank[n];
            for (int i = this.lank[n]; i > 0; --i) {
                this.colums[n - i] = this.colums[n];
            }
            if (this.maxLank >= this.lank[n]) continue;
            this.maxLank = this.lank[n];
        }
        Dimension dimension = new Dimension((int)(105.0 + (double)(this.xPitch * (this.maxLank + 1))), this.paneHeight + 40);
        this.setPreferredSize(dimension);
    }

    public void paint(Graphics graphics) {
        int n;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        int n2 = (this.maxLank + 1) * this.xPitch;
        for (n = 0; n < this.energyList.length; ++n) {
            int n3 = (int)((this.energyList[n].energy - (double)this.min) * (double)this.yPitch);
            if (this.moFile.homo != -1 && Math.abs(this.energyList[n].energy - this.moFile.homoEnergy) < 1.0E-6) {
                graphics.setColor(Color.red);
            } else if (this.moFile.lumo != -1 && Math.abs(this.energyList[n].energy - this.moFile.lumoEnergy) < 1.0E-6) {
                graphics.setColor(Color.blue);
            } else {
                graphics.setColor(Color.gray);
            }
            this.paneHeight = (int)(this.yPitch * (this.max - this.min));
            int n4 = n2 / (this.colums[n] + 1);
            this.posx[n] = 70 + n4 / 2 - this.xPitch / 2 + this.lank[n] * n4 + (this.xPitch - this.width);
            this.posy[n] = this.paneHeight + 20 - (n3 + this.height / 2);
            graphics.fillRect(this.posx[n], this.posy[n], this.width, this.height);
        }
        n = this.moFile.energy.length * this.xPitch + 140;
        graphics.setColor(Color.black);
        graphics.drawLine(70, 20, 70, 20 + this.paneHeight);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        float f = this.yPitch < 15.0f ? 10.0f : (this.yPitch < 25.0f ? 5.0f : (this.yPitch < 50.0f ? 1.0f : (this.yPitch < 250.0f ? 0.5f : 0.1f)));
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        for (int i = 0; i < (int)((this.max - this.min) / f + 1.0f); ++i) {
            int n5 = 20 + this.paneHeight - (int)((float)i * this.yPitch * f);
            String string = decimalFormat.format(this.min + (float)i * f);
            graphics.drawString(string, 63 - fontMetrics.stringWidth(string), n5 + 5);
            graphics.drawLine(70, n5, 65, n5);
        }
        if (this.moFile.minEnergy != 0.5001) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.rotate(-1.5707963267948966, 0.0, 0.0);
            graphics.drawString("MO Energy / Hartree", -(20 + this.paneHeight / 2 + 60), 20);
            graphics2D.rotate(1.5707963267948966, 0.0, 0.0);
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            int n = ((MouseEvent)aWTEvent).getX();
            int n2 = ((MouseEvent)aWTEvent).getY();
            int n3 = this.getIndex(n, n2);
            switch (aWTEvent.getID()) {
                case 502: {
                    if (n3 == -1) break;
                    this.moGraphWindow.setMoNo(n3);
                    break;
                }
                case 503: {
                    if (n3 != -1) {
                        int n4;
                        for (n4 = 0; n4 < this.moFile.moNumber.length && n3 != this.moFile.moNumber[n4]; ++n4) {
                        }
                        this.moGraphWindow.displayEnergy("No:" + n3 + " " + this.moFile.energy[n4]);
                        break;
                    }
                    this.moGraphWindow.displayEnergy("");
                }
            }
        }
    }

    private int getIndex(int n, int n2) {
        int n3 = -1;
        for (int i = 0; i < this.posx.length; ++i) {
            if (this.posx[i] > n || n > this.posx[i] + this.width || this.posy[i] > n2 || n2 > this.posy[i] + this.height) continue;
            n3 = this.energyList[i].moNumber;
            break;
        }
        return n3;
    }

    public void scaleUp() {
        this.yPitch *= 2.0f;
        ++this.magStep;
        this.paneHeight = (int)(this.yPitch * (this.max - this.min));
        Dimension dimension = new Dimension((int)(105.0 + (double)(this.xPitch * (this.maxLank + 1))), this.paneHeight + 40);
        this.repaint();
        this.setPreferredSize(dimension);
        this.moGraphWindow.setViewportSize(dimension);
    }

    public void scaleDown() {
        if (this.magStep > 1) {
            --this.magStep;
            this.yPitch /= 2.0f;
            this.paneHeight = (int)(this.yPitch * (this.max - this.min));
            Dimension dimension = new Dimension((int)(105.0 + (double)(this.xPitch * (this.maxLank + 1))), this.paneHeight + 40);
            this.repaint();
            this.setPreferredSize(dimension);
            this.moGraphWindow.setViewportSize(dimension);
        }
    }

    public void setHeight(int n) {
        this.height = n;
        this.repaint();
    }

    class energyItem
    implements Comparable {
        int moNumber;
        double energy;

        public energyItem(int n, double d) {
            this.moNumber = n;
            this.energy = d;
        }

        public int compareTo(Object object) {
            return Double.compare(this.energy, ((energyItem)object).energy);
        }
    }
}

