/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.AjfFile;
import AbinitMp.Common.AtomData;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.PdbFile;
import AbinitMp.Tool.FillSpace;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.FileItem;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class FragmentAssignPanel
extends GridBagLayoutPanel {
    private AbinitMpViewer viewer;
    private FileItem fileItem;
    private Vector chains;
    private JTextField atom1Text;
    private JTextField atom2Text;
    private MyComboBox chainComboBox;
    private JList list;
    private DefaultListModel listModel;
    private Vector noLableVector = new Vector();
    private Vector formalChargeTextVector = new Vector();
    private Vector interfragmentTextVector = new Vector();
    private Vector dataPanelVector = new Vector();
    private int boundaryNumber = 0;
    private AtomData atom1;
    private AtomData atom2;
    private boolean setAtomFlag = true;
    private Vector atom1Vector = new Vector();
    private Vector atom2Vector = new Vector();
    public int[] numberOfAtomsComposingFragment;
    public int[] formalCharge;
    public int[] numberOfInterfragmentBonds;
    public Vector atomicNumberComposingFragment = new Vector();
    public int[] atomicNumberOfFragmentBonds;

    public FragmentAssignPanel(AbinitMpViewer abinitMpViewer) {
        this.viewer = abinitMpViewer;
        GridBagLayoutPanel gridBagLayoutPanel = new GridBagLayoutPanel();
        GridBagLayoutPanel gridBagLayoutPanel2 = new GridBagLayoutPanel();
        gridBagLayoutPanel.setBorder(new TitledBorder(MyResourceBundle.getResourceString("FragmentAssignPanel.atoms")));
        gridBagLayoutPanel2.setBorder(new TitledBorder(MyResourceBundle.getResourceString("FragmentAssignPanel.data")));
        this.atom1Text = new JTextField();
        this.atom1Text.setPreferredSize(new Dimension(70, 28));
        this.atom1Text.setEditable(false);
        this.atom2Text = new JTextField();
        this.atom2Text.setPreferredSize(new Dimension(70, 28));
        this.atom2Text.setEditable(false);
        gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("FragmentAssignPanel.atom1")), 0, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.atom1Text, 5, 0, 10, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("FragmentAssignPanel.atom2")), 0, 1, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.atom2Text, 5, 1, 10, 1, 1.0, 0.0);
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("FragmentAssignPanel.add"));
        gridBagLayoutPanel.layoutObject(myButton, 0, 2, 0, 1, 1.0, 0.0);
        myButton.addActionListener(new addListener());
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.addListSelectionListener(new listListener());
        this.list.setVisibleRowCount(5);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        gridBagLayoutPanel.layoutObject(jScrollPane, 0, 3, 0, 5, 1.0, 0.0);
        MyButton myButton2 = new MyButton(MyResourceBundle.getResourceString("FragmentAssignPanel.delete"));
        gridBagLayoutPanel.layoutObject(myButton2, 0, 8, 0, 1, 1.0, 0.0);
        myButton2.addActionListener(new deleteListener());
        MyPanel myPanel = new MyPanel(new FlowLayout(0));
        MyLabel myLabel = new MyLabel(MyResourceBundle.getResourceString("FragmentAssignPanel.no"));
        myLabel.setPreferredSize(new Dimension(20, 20));
        myPanel.add(myLabel);
        MyLabel myLabel2 = new MyLabel(MyResourceBundle.getResourceString("FragmentAssignPanel.formalCharge"));
        myLabel2.setPreferredSize(new Dimension(100, 20));
        myPanel.add(myLabel2);
        MyLabel myLabel3 = new MyLabel(MyResourceBundle.getResourceString("FragmentAssignPanel.interfragment"));
        myLabel3.setPreferredSize(new Dimension(100, 20));
        myPanel.add(myLabel3);
        gridBagLayoutPanel2.layoutObject(myPanel, 0, 0, 0, 1, 1.0, 0.0);
        MyPanel myPanel2 = new MyPanel(new GridLayout(0, 1));
        for (int i = 0; i < 10; ++i) {
            JTextField jTextField = new JTextField();
            JTextField jTextField2 = new JTextField();
            jTextField.setPreferredSize(new Dimension(100, 28));
            jTextField2.setPreferredSize(new Dimension(100, 28));
            MyPanel myPanel3 = new MyPanel();
            MyLabel myLabel4 = new MyLabel(i + 1 + "");
            myPanel3.add(myLabel4);
            myPanel3.add(jTextField);
            myPanel3.add(jTextField2);
            myPanel2.add(myPanel3);
            myLabel4.setVisible(false);
            jTextField.setVisible(false);
            jTextField2.setVisible(false);
            this.noLableVector.add(myLabel4);
            this.formalChargeTextVector.add(jTextField);
            this.interfragmentTextVector.add(jTextField2);
            this.dataPanelVector.add(myPanel3);
        }
        JScrollPane jScrollPane2 = new JScrollPane(myPanel2, 22, 31);
        gridBagLayoutPanel2.layoutObject(jScrollPane2, 0, 1, 0, 5, 1.0, 0.0);
        jScrollPane2.setPreferredSize(new Dimension(200, 220));
        this.layoutObject(gridBagLayoutPanel, 0, 0, 0, 1, 1.0, 0.0);
        this.layoutObject(gridBagLayoutPanel2, 0, 1, 0, 1, 1.0, 0.0);
    }

    private boolean checkNext(ChainData chainData, AtomData atomData, AtomData atomData2) {
        if (chainData != null && chainData.hemTable.indexOf(atomData) != -1) {
            Vector vector = chainData.hemConnect[chainData.hemTable.indexOf(atomData)];
            for (int i = 0; i < vector.size(); ++i) {
                AtomData atomData3 = (AtomData)vector.get(i);
                if (atomData3 != atomData2) continue;
                return true;
            }
        }
        return false;
    }

    private ChainData getChainData(AtomData atomData) {
        ChainData chainData = null;
        for (int i = 0; i < this.chains.size(); ++i) {
            chainData = (ChainData)this.chains.get(i);
            if (chainData.hemTable != null && chainData.hemTable.contains(atomData)) break;
        }
        return chainData;
    }

    private boolean calcFragmentData() {
        int n;
        int n2;
        Object object;
        int n3;
        boolean bl = true;
        Vector vector = new Vector();
        for (int i = 0; i < this.atom1Vector.size(); ++i) {
            vector.add(this.atom1Vector.get(i));
            vector.add(this.atom2Vector.get(i));
        }
        this.atomicNumberComposingFragment = new Vector();
        for (n3 = 0; n3 < vector.size(); ++n3) {
            Vector vector2 = new Vector();
            AtomData atomData = (AtomData)vector.get(n3);
            bl = this.addFragmentElement(n3, vector, atomData, (AtomData)(object = n3 % 2 == 0 ? (Object)((AtomData)vector.get(n3 + 1)) : (Object)((AtomData)vector.get(n3 - 1))), vector2, this.getChainData(atomData));
            if (!bl) continue;
            int[] nArray = new int[vector2.size()];
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                AtomData atomData2 = (AtomData)vector2.get(n2);
                nArray[n2] = atomData2.no;
                atomData2.fragmentNo = this.atomicNumberComposingFragment.size() + 1;
            }
            Arrays.sort(nArray);
            this.atomicNumberComposingFragment.add(nArray);
        }
        n3 = this.atomicNumberComposingFragment.size();
        this.numberOfAtomsComposingFragment = new int[n3];
        for (n = 0; n < n3; ++n) {
            object = (int[])this.atomicNumberComposingFragment.get(n);
            this.numberOfAtomsComposingFragment[n] = ((int[])object).length;
        }
        this.formalCharge = new int[n3];
        this.numberOfInterfragmentBonds = new int[n3];
        for (n = 0; n < n3; ++n) {
            object = (int[])this.atomicNumberComposingFragment.get(n);
            int n4 = 0;
            n2 = 0;
            for (int i = 0; i < ((int[])object).length; ++i) {
                int n5;
                int n6;
                for (n6 = 1; n6 < vector.size(); n6 += 2) {
                    n5 = ((AtomData)vector.get((int)n6)).no;
                    if (n5 != object[i]) continue;
                    --n4;
                    ++n2;
                }
                for (n6 = 0; n6 < vector.size(); n6 += 2) {
                    n5 = ((AtomData)vector.get((int)n6)).no;
                    if (n5 != object[i]) continue;
                    ++n4;
                }
            }
            this.numberOfInterfragmentBonds[n] = n2;
            this.formalCharge[n] = n4;
        }
        this.atomicNumberOfFragmentBonds = new int[vector.size()];
        for (n = 0; n < vector.size(); n += 2) {
            this.atomicNumberOfFragmentBonds[n] = ((AtomData)vector.get((int)n)).no;
            this.atomicNumberOfFragmentBonds[n + 1] = ((AtomData)vector.get((int)(n + 1))).no;
        }
        for (n = 0; n < n3; ++n) {
            object = (JTextField)this.formalChargeTextVector.get(n);
            JTextField jTextField = (JTextField)this.interfragmentTextVector.get(n);
            ((JTextComponent)object).setText(this.formalCharge[n] + "");
            jTextField.setText(this.numberOfInterfragmentBonds[n] + "");
        }
        return bl;
    }

    private boolean addFragmentElement(int n, Vector vector, AtomData atomData, AtomData atomData2, Vector vector2, ChainData chainData) {
        int n2;
        if (atomData == atomData2) {
            return true;
        }
        for (n2 = 0; n2 < n; n2 += 1) {
            if (atomData != (AtomData)vector.get(n2)) continue;
            return false;
        }
        for (n2 = 0; n2 < vector2.size(); n2 += 1) {
            if (atomData != (AtomData)vector2.get(n2)) continue;
            return true;
        }
        vector2.add(atomData);
        n2 = 1;
        Vector vector3 = chainData.hemConnect[chainData.hemTable.indexOf(atomData)];
        for (int i = 0; i < vector3.size() && vector.size() != 0; ++i) {
            if ((AtomData)vector3.get(i) == atomData2 && atomData != (AtomData)vector.get(n)) {
                this.atom1Vector.remove(this.atom1Vector.size() - 1);
                this.atom2Vector.remove(this.atom2Vector.size() - 1);
                vector.remove(vector.size() - 1);
                vector.remove(vector.size() - 1);
                System.out.println("loop");
                JOptionPane.showMessageDialog(this.list, "Can not assign loop atoms.", "Error message", 0);
                return false;
            }
            AtomData atomData3 = (AtomData)vector3.get(i);
            boolean bl = true;
            for (int j = 0; j < vector.size(); j += 2) {
                AtomData atomData4 = (AtomData)vector.get(j);
                AtomData atomData5 = (AtomData)vector.get(j + 1);
                if ((atomData != atomData4 || atomData3 != atomData5) && (atomData != atomData5 || atomData3 != atomData4)) continue;
                bl = false;
            }
            if (!bl || this.addFragmentElement(n, vector, atomData3, atomData2, vector2, chainData)) continue;
            n2 = 0;
        }
        return n2 != 0;
    }

    private void printData() {
        int[] nArray;
        int n;
        int n2 = this.atomicNumberComposingFragment.size();
        this.viewer.addMessageln("Number of atoms composing:");
        for (n = 0; n < n2; ++n) {
            nArray = (int[])this.atomicNumberComposingFragment.get(n);
            this.viewer.addMessage(FillSpace.front(nArray.length + "", 5));
            if ((n + 1) % 16 != 0) continue;
            this.viewer.addMessageln("");
        }
        if (n2 % 16 != 0) {
            this.viewer.addMessageln("");
        }
        this.viewer.addMessageln("Atomic number composing fragment:");
        for (n = 0; n < this.atomicNumberComposingFragment.size(); ++n) {
            nArray = (int[])this.atomicNumberComposingFragment.get(n);
            for (int i = 0; i < nArray.length; ++i) {
                this.viewer.addMessage(FillSpace.front(nArray[i] + "", 5));
                if ((i + 1) % 16 != 0) continue;
                this.viewer.addMessageln("");
            }
            if (nArray.length % 16 == 0) continue;
            this.viewer.addMessageln("");
        }
    }

    public void setAtom(AtomData atomData) {
        String string = atomData.allAtomName + "(" + atomData.no + ") " + atomData.residueData.name + atomData.residueData.no;
        if (this.setAtomFlag) {
            this.atom1 = atomData;
            this.atom1Text.setText(string);
        } else {
            this.atom2 = atomData;
            this.atom2Text.setText(string);
        }
        this.setAtomFlag = !this.setAtomFlag;
    }

    public void highlightBounbary(AtomData atomData) {
        int n;
        for (n = 0; n < this.atom1Vector.size() && (AtomData)this.atom1Vector.get(n) != atomData; ++n) {
        }
        this.list.setSelectedIndex(n);
    }

    public boolean setParameter(AjfFile ajfFile) {
        int n;
        JTextField jTextField;
        Serializable serializable;
        Object object;
        int n2;
        this.numberOfAtomsComposingFragment = ajfFile.numberOfAtomsComposingFragment;
        this.formalCharge = ajfFile.formalCharge;
        this.numberOfInterfragmentBonds = ajfFile.numberOfInterfragmentBonds;
        this.atomicNumberComposingFragment = ajfFile.atomicNumberComposingFragment;
        this.atomicNumberOfFragmentBonds = ajfFile.atomicNumberOfFragmentBonds;
        int n3 = this.atomicNumberComposingFragment != null ? this.atomicNumberComposingFragment.size() : 0;
        for (n2 = n3; n2 <= this.listModel.getSize(); ++n2) {
            object = (JLabel)this.noLableVector.get(n2);
            serializable = (JTextField)this.formalChargeTextVector.get(n2);
            jTextField = (JTextField)this.interfragmentTextVector.get(n2);
            ((JComponent)object).setVisible(false);
            ((JComponent)serializable).setVisible(false);
            jTextField.setVisible(false);
        }
        for (n2 = this.listModel.getSize(); n2 < n3; ++n2) {
            object = (JLabel)this.noLableVector.get(n2);
            serializable = (JTextField)this.formalChargeTextVector.get(n2);
            jTextField = (JTextField)this.interfragmentTextVector.get(n2);
            ((JComponent)object).setVisible(true);
            ((JComponent)serializable).setVisible(true);
            jTextField.setVisible(true);
        }
        this.atom1Vector.removeAllElements();
        this.atom2Vector.removeAllElements();
        this.listModel.removeAllElements();
        if (n3 == 0) {
            return true;
        }
        this.boundaryNumber = n3 - 1;
        File file = new File(ajfFile.readGeom);
        object = file.getName();
        serializable = this.viewer.getFileList();
        boolean bl = false;
        for (n = 0; n < ((Vector)serializable).size(); ++n) {
            FileItem fileItem = (FileItem)((Vector)serializable).get(n);
            if (!fileItem.filename.equals(object)) continue;
            bl = true;
        }
        if (!bl) {
            bl = this.viewer.openFile(ajfFile.readGeom);
        }
        if (bl) {
            this.setFileItem();
            block3: for (n = 0; n < this.atomicNumberOfFragmentBonds.length; n += 2) {
                int n4 = this.atomicNumberOfFragmentBonds[n];
                int n5 = this.atomicNumberOfFragmentBonds[n + 1];
                int n6 = 0;
                for (int i = 0; i < this.chains.size(); ++i) {
                    ChainData chainData = (ChainData)this.chains.get(i);
                    for (int j = 0; j < chainData.hemTable.size(); ++j) {
                        AtomData atomData = (AtomData)chainData.hemTable.get(j);
                        if (atomData.no == n4) {
                            this.atom1Vector.add(atomData);
                            ++n6;
                        }
                        if (atomData.no == n5) {
                            this.atom2Vector.add(atomData);
                            ++n6;
                        }
                        if (n6 == 2) break;
                    }
                    if (n6 == 2) continue block3;
                }
            }
            for (n = 0; n < this.atom1Vector.size(); ++n) {
                AtomData atomData = (AtomData)this.atom1Vector.get(n);
                AtomData atomData2 = (AtomData)this.atom2Vector.get(n);
                String string = atomData.allAtomName + "(" + atomData.no + ") " + atomData.residueData.name + atomData.residueData.no;
                String string2 = atomData2.allAtomName + "(" + atomData2.no + ") " + atomData2.residueData.name + atomData2.residueData.no;
                this.listModel.addElement(string + "-" + string2);
            }
        } else {
            return false;
        }
        this.calcFragmentData();
        return true;
    }

    public void getParameter(AjfFile ajfFile) {
        ajfFile.numberOfAtomsComposingFragment = this.numberOfAtomsComposingFragment;
        ajfFile.formalCharge = this.formalCharge;
        ajfFile.numberOfInterfragmentBonds = this.numberOfInterfragmentBonds;
        ajfFile.atomicNumberComposingFragment = this.atomicNumberComposingFragment;
        ajfFile.atomicNumberOfFragmentBonds = this.atomicNumberOfFragmentBonds;
        ajfFile.numberOfFragment = this.atomicNumberComposingFragment.size();
    }

    public void setFileItem() {
        PdbFile pdbFile;
        this.fileItem = this.viewer.getCurrentFileItem();
        if (this.fileItem != null && (pdbFile = this.fileItem.getPdbFile()) != null) {
            this.chains = pdbFile.chains;
        }
    }

    public void createBoundaryNode() {
        for (int i = 0; i < this.atom1Vector.size(); ++i) {
            AtomData atomData = (AtomData)this.atom1Vector.get(i);
            AtomData atomData2 = (AtomData)this.atom2Vector.get(i);
            this.viewer.createFragmentBoundaryNode(atomData, atomData2);
        }
    }

    public void deleteBoundaryNode() {
        for (int i = 0; i < this.atom1Vector.size(); ++i) {
            AtomData atomData = (AtomData)this.atom1Vector.get(i);
            this.viewer.removeFragmentBoundaryNode(atomData);
        }
    }

    class listListener
    implements ListSelectionListener {
        listListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = FragmentAssignPanel.this.list.getSelectedIndex();
            if (n != -1) {
                AtomData atomData = (AtomData)FragmentAssignPanel.this.atom1Vector.get(n);
                FragmentAssignPanel.this.viewer.getSceneViewer().highlightBounbaryNode(atomData);
            }
        }
    }

    class deleteListener
    extends AbstractAction {
        deleteListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            if (FragmentAssignPanel.this.boundaryNumber > 0 && (nArray = FragmentAssignPanel.this.list.getSelectedIndices()).length != 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    JLabel jLabel = (JLabel)FragmentAssignPanel.this.noLableVector.get(FragmentAssignPanel.this.boundaryNumber);
                    JTextField jTextField = (JTextField)FragmentAssignPanel.this.formalChargeTextVector.get(FragmentAssignPanel.this.boundaryNumber);
                    JTextField jTextField2 = (JTextField)FragmentAssignPanel.this.interfragmentTextVector.get(FragmentAssignPanel.this.boundaryNumber);
                    jLabel.setVisible(false);
                    jTextField.setVisible(false);
                    jTextField2.setVisible(false);
                    FragmentAssignPanel.this.boundaryNumber--;
                    FragmentAssignPanel.this.listModel.removeElementAt(nArray[nArray.length - i - 1]);
                    AtomData atomData = (AtomData)FragmentAssignPanel.this.atom1Vector.get(nArray[nArray.length - i - 1]);
                    AtomData atomData2 = (AtomData)FragmentAssignPanel.this.atom2Vector.get(nArray[nArray.length - i - 1]);
                    FragmentAssignPanel.this.viewer.removeFragmentBoundaryNode(atomData);
                    FragmentAssignPanel.this.atom1Vector.removeElementAt(nArray[nArray.length - i - 1]);
                    FragmentAssignPanel.this.atom2Vector.removeElementAt(nArray[nArray.length - i - 1]);
                    if (FragmentAssignPanel.this.boundaryNumber != 0) continue;
                    jLabel = (JLabel)FragmentAssignPanel.this.noLableVector.get(FragmentAssignPanel.this.boundaryNumber);
                    jTextField = (JTextField)FragmentAssignPanel.this.formalChargeTextVector.get(FragmentAssignPanel.this.boundaryNumber);
                    jTextField2 = (JTextField)FragmentAssignPanel.this.interfragmentTextVector.get(FragmentAssignPanel.this.boundaryNumber);
                    jLabel.setVisible(false);
                    jTextField.setVisible(false);
                    jTextField2.setVisible(false);
                    ChainData chainData = FragmentAssignPanel.this.getChainData(atomData);
                    Vector vector = chainData.hemTable;
                    for (int j = 0; j < vector.size(); ++j) {
                        AtomData atomData3 = (AtomData)vector.get(j);
                        atomData3.fragmentNo = 0;
                    }
                }
                if (FragmentAssignPanel.this.boundaryNumber > 0) {
                    FragmentAssignPanel.this.calcFragmentData();
                    FragmentAssignPanel.this.printData();
                }
                FragmentAssignPanel.this.viewer.displayMoNode();
            }
        }
    }

    class addListener
    extends AbstractAction {
        addListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FragmentAssignPanel.this.boundaryNumber < 10 && FragmentAssignPanel.this.atom1 != null && FragmentAssignPanel.this.atom2 != null) {
                ChainData chainData = FragmentAssignPanel.this.getChainData(FragmentAssignPanel.this.atom1);
                if (!FragmentAssignPanel.this.checkNext(chainData, FragmentAssignPanel.this.atom1, FragmentAssignPanel.this.atom2)) {
                    JOptionPane.showMessageDialog(FragmentAssignPanel.this.list, "Please select next atom.", "Error message", 0);
                    return;
                }
                FragmentAssignPanel.this.atom1Vector.add(FragmentAssignPanel.this.atom1);
                FragmentAssignPanel.this.atom2Vector.add(FragmentAssignPanel.this.atom2);
                if (FragmentAssignPanel.this.calcFragmentData()) {
                    JTextField jTextField;
                    JTextField jTextField2;
                    JLabel jLabel;
                    if (FragmentAssignPanel.this.boundaryNumber == 0) {
                        jLabel = (JLabel)FragmentAssignPanel.this.noLableVector.get(FragmentAssignPanel.this.boundaryNumber);
                        jTextField2 = (JTextField)FragmentAssignPanel.this.formalChargeTextVector.get(FragmentAssignPanel.this.boundaryNumber);
                        jTextField = (JTextField)FragmentAssignPanel.this.interfragmentTextVector.get(FragmentAssignPanel.this.boundaryNumber);
                        jLabel.setVisible(true);
                        jTextField2.setVisible(true);
                        jTextField.setVisible(true);
                    }
                    FragmentAssignPanel.this.boundaryNumber++;
                    jLabel = (JLabel)FragmentAssignPanel.this.noLableVector.get(FragmentAssignPanel.this.boundaryNumber);
                    jTextField2 = (JTextField)FragmentAssignPanel.this.formalChargeTextVector.get(FragmentAssignPanel.this.boundaryNumber);
                    jTextField = (JTextField)FragmentAssignPanel.this.interfragmentTextVector.get(FragmentAssignPanel.this.boundaryNumber);
                    jLabel.setVisible(true);
                    jTextField2.setVisible(true);
                    jTextField.setVisible(true);
                    String string = ((FragmentAssignPanel)FragmentAssignPanel.this).atom1.allAtomName + "(" + ((FragmentAssignPanel)FragmentAssignPanel.this).atom1.no + ") " + ((FragmentAssignPanel)FragmentAssignPanel.this).atom1.residueData.name + ((FragmentAssignPanel)FragmentAssignPanel.this).atom1.residueData.no;
                    String string2 = ((FragmentAssignPanel)FragmentAssignPanel.this).atom2.allAtomName + "(" + ((FragmentAssignPanel)FragmentAssignPanel.this).atom2.no + ") " + ((FragmentAssignPanel)FragmentAssignPanel.this).atom2.residueData.name + ((FragmentAssignPanel)FragmentAssignPanel.this).atom2.residueData.no;
                    FragmentAssignPanel.this.listModel.addElement(string + "-" + string2);
                    FragmentAssignPanel.this.viewer.createFragmentBoundaryNode(FragmentAssignPanel.this.atom1, FragmentAssignPanel.this.atom2);
                    FragmentAssignPanel.this.viewer.displayMoNode();
                    FragmentAssignPanel.this.printData();
                }
            }
        }
    }
}

