/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Structure;

import AbinitMp.Common.AtomData;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.ResidueData;
import AbinitMp.Structure.MolecularStructure;
import AbinitMp.Viewer.FileItem;
import java.io.PrintStream;
import javax.vecmath.Color3f;

public class NodeData {
    public MolecularStructure molecularData;
    public AtomData atomData;
    public ResidueData residueData;
    public FileItem fileItem;
    public ChainData chainData;
    public int type;
    public int model;
    public int color;
    public Color3f colorValue;
    public int label;
    public boolean visible;

    public NodeData() {
        this.molecularData = null;
        this.atomData = null;
        this.residueData = null;
        this.chainData = null;
        this.fileItem = null;
        this.type = 3;
        this.model = 0;
        this.color = 0;
        this.colorValue = null;
        this.label = 0;
        this.visible = true;
    }

    public NodeData(MolecularStructure molecularStructure, AtomData atomData, ResidueData residueData, ChainData chainData, FileItem fileItem, int n) {
        this.molecularData = molecularStructure;
        this.atomData = atomData;
        this.residueData = residueData;
        this.chainData = chainData;
        this.fileItem = fileItem;
        this.type = n;
        this.model = 0;
        this.color = 0;
        this.colorValue = null;
        this.label = 0;
        this.visible = true;
    }

    public NodeData(NodeData nodeData) {
        this.molecularData = nodeData.molecularData;
        this.atomData = nodeData.atomData;
        this.residueData = nodeData.residueData;
        this.chainData = nodeData.chainData;
        this.fileItem = nodeData.fileItem;
        this.type = nodeData.type;
        this.model = nodeData.model;
        this.color = nodeData.color;
        this.colorValue = nodeData.colorValue;
        this.label = nodeData.label;
        this.visible = nodeData.visible;
    }

    public void debugPrint(PrintStream printStream) {
        printStream.println("*** NodeData ***");
        printStream.println("type " + this.type + " model " + this.model + " color " + this.color + " visible " + this.visible);
    }
}

