/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.AbinitMpFile;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class GridFile {
    public String filename = null;
    public int type;
    public float isosurfaceValue;
    public int nx;
    public int ny;
    public int nz;
    public int nxyz;
    public float[] x;
    public float[] y;
    public float[] z;
    public float[] xx;
    public float[] yy;
    public float[] zz;
    public float[] densityValue;
    public float densityValueMin = 1.0E10f;
    public float densityValueMax = -1.0E10f;
    public float[] potentialValue;
    public float potentialValueMin = 1.0E10f;
    public float potentialValueMax = -1.0E10f;

    public GridFile() {
    }

    public GridFile(String string) {
        this.readFile(string);
    }

    public void readFile(String string) {
        try {
            int n;
            int n2;
            int n3;
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = bufferedReader.readLine();
            int n4 = Integer.parseInt(string2.trim());
            this.type = n4 == 0 ? 0 : (n4 == 1 ? 1 : (n4 == 2 ? 2 : 3));
            string2 = bufferedReader.readLine();
            this.isosurfaceValue = Float.parseFloat(string2.trim().replace('D', 'E'));
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.nx = Integer.parseInt(stringTokenizer.nextToken()) + 1;
            this.ny = Integer.parseInt(stringTokenizer.nextToken()) + 1;
            this.nz = Integer.parseInt(stringTokenizer.nextToken()) + 1;
            this.xx = new float[this.nx];
            for (n3 = 0; n3 < this.nx; ++n3) {
                string2 = bufferedReader.readLine();
                this.xx[n3] = Float.parseFloat(string2.trim().replace('D', 'E'));
            }
            this.yy = new float[this.ny];
            for (n3 = 0; n3 < this.ny; ++n3) {
                string2 = bufferedReader.readLine();
                this.yy[n3] = Float.parseFloat(string2.trim().replace('D', 'E'));
            }
            this.zz = new float[this.nz];
            for (n3 = 0; n3 < this.nz; ++n3) {
                string2 = bufferedReader.readLine();
                this.zz[n3] = Float.parseFloat(string2.trim().replace('D', 'E'));
            }
            this.nxyz = this.nx * this.ny * this.nz;
            this.x = new float[this.nxyz];
            this.y = new float[this.nxyz];
            this.z = new float[this.nxyz];
            for (n3 = 0; n3 < this.nz; ++n3) {
                for (n2 = 0; n2 < this.ny; ++n2) {
                    for (n = 0; n < this.nx; ++n) {
                        this.x[n + n2 * this.nx + n3 * this.nx * this.ny] = this.xx[n];
                        this.y[n + n2 * this.nx + n3 * this.nx * this.ny] = this.yy[n2];
                        this.z[n + n2 * this.nx + n3 * this.nx * this.ny] = this.zz[n3];
                    }
                }
            }
            if (this.type == 0 || this.type == 2 || this.type == 1 || this.type == 3) {
                this.densityValue = new float[this.nxyz];
            }
            if (this.type == 1 || this.type == 2) {
                this.potentialValue = new float[this.nxyz];
            }
            if (this.type == 0 || this.type == 1) {
                while ((string2 = bufferedReader.readLine()) != null && !string2.trim().equals("END")) {
                    float f;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                    n2 = Integer.parseInt(stringTokenizer2.nextToken());
                    n = Integer.parseInt(stringTokenizer2.nextToken());
                    int n5 = Integer.parseInt(stringTokenizer2.nextToken());
                    this.densityValue[n2 + n * this.nx + n5 * this.nx * this.ny] = f = Float.parseFloat(stringTokenizer2.nextToken().replace('D', 'E'));
                    if (f > this.densityValueMax) {
                        this.densityValueMax = f;
                        continue;
                    }
                    if (!(f < this.densityValueMin)) continue;
                    this.densityValueMin = f;
                }
            } else if (this.type == 2) {
                while ((string2 = bufferedReader.readLine()) != null && !string2.trim().equals("END")) {
                    float f;
                    StringTokenizer stringTokenizer3 = new StringTokenizer(string2);
                    n2 = Integer.parseInt(stringTokenizer3.nextToken());
                    n = Integer.parseInt(stringTokenizer3.nextToken());
                    int n6 = Integer.parseInt(stringTokenizer3.nextToken());
                    this.densityValue[n2 + n * this.nx + n6 * this.nx * this.ny] = f = Float.parseFloat(stringTokenizer3.nextToken().replace('D', 'E'));
                    if (f > this.densityValueMax) {
                        this.densityValueMax = f;
                    } else if (f < this.densityValueMin) {
                        this.densityValueMin = f;
                    }
                    this.potentialValue[n2 + n * this.nx + n6 * this.nx * this.ny] = f = Float.parseFloat(stringTokenizer3.nextToken().replace('D', 'E'));
                    if (f > this.potentialValueMax) {
                        this.potentialValueMax = f;
                        continue;
                    }
                    if (!(f < this.potentialValueMin)) continue;
                    this.potentialValueMin = f;
                }
            }
            this.filename = string;
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            JOptionPane.showMessageDialog(new Frame(), "Grid File read error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
    }

    public void debugPrint(PrintStream printStream) {
        printStream.println("Grid File (" + this.filename + ")");
        printStream.println("type : " + this.type);
        printStream.println("isosurface value : " + this.isosurfaceValue);
        printStream.println("nx : " + this.nx + " ny : " + this.ny + " nz : " + this.nz);
        printStream.println("dmin : " + this.densityValueMin + " dmax : " + this.densityValueMax);
        printStream.println("pmin : " + this.potentialValueMin + " pmax : " + this.potentialValueMax);
        for (int i = 0; i < this.nz; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                for (int k = 0; k < this.nx; ++k) {
                    printStream.print(this.x[k + j * this.nx + i * this.nx * this.ny] + " " + this.y[k + j * this.nx + i * this.nx * this.ny] + " " + this.z[k + j * this.nx + i * this.nx * this.ny] + " ");
                    if (this.type == 0 || this.type == 2 || this.type == 3 || this.type == 8 || this.type == 9 || this.type == 10) {
                        printStream.print(this.densityValue[k + j * this.nx + i * this.nx * this.ny] + " ");
                    }
                    if (this.type == 1 || this.type == 2) {
                        printStream.print(this.potentialValue[k + j * this.nx + i * this.nx * this.ny]);
                    }
                    if (this.densityValue[k + j * this.nx + i * this.nx * this.ny] < 0.0f) {
                        printStream.print("*****");
                    }
                    printStream.println("");
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        GridFile gridFile = new GridFile(stringArray[0]);
        gridFile.debugPrint(System.out);
    }
}

