/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.util;

import org.cybergarage.x3d.field.SFRotation;

public class Geometry3D {
    public static void initialize(float[] vector) {
        vector[0] = 0.0f;
        vector[1] = 0.0f;
        vector[2] = 0.0f;
    }

    public static void normalize(float[] vector) {
        float mag = (float)Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        if (mag != 0.0f) {
            vector[0] = vector[0] / mag;
            vector[1] = vector[1] / mag;
            vector[2] = vector[2] / mag;
        } else {
            vector[0] = 0.0f;
            vector[1] = 0.0f;
            vector[2] = 1.0f;
        }
    }

    public static void scale(float[] vector, float factor) {
        vector[0] = vector[0] * factor;
        vector[1] = vector[1] * factor;
        vector[2] = vector[2] * factor;
    }

    public static void scale(float[] vector, float[] factor) {
        vector[0] = vector[0] * factor[0];
        vector[1] = vector[1] * factor[1];
        vector[2] = vector[2] * factor[2];
    }

    public static void scale(float[] vector, float factorx, float factory, float factorz) {
        vector[0] = vector[0] * factorx;
        vector[1] = vector[1] * factory;
        vector[2] = vector[2] * factorz;
    }

    public static float length(float[] vector) {
        return (float)Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
    }

    public static float distance(float[] vector1, float[] vector2) {
        float x = vector1[0] - vector2[0];
        float y = vector1[1] - vector2[1];
        float z = vector1[2] - vector2[2];
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public static void inverse(float[] vector) {
        vector[0] = -vector[0];
        vector[1] = -vector[1];
        vector[2] = -vector[2];
    }

    public static void add(float[] vector1, float[] vector2) {
        vector1[0] = vector1[0] + vector2[0];
        vector1[1] = vector1[1] + vector2[1];
        vector1[2] = vector1[2] + vector2[2];
    }

    public static void add(float[] vector1, float[] vector2, float[] resultVector) {
        resultVector[0] = vector1[0] + vector2[0];
        resultVector[1] = vector1[1] + vector2[1];
        resultVector[2] = vector1[2] + vector2[2];
    }

    public static void sub(float[] vector1, float[] vector2, float[] resultVector) {
        resultVector[0] = vector1[0] - vector2[0];
        resultVector[1] = vector1[1] - vector2[1];
        resultVector[2] = vector1[2] - vector2[2];
    }

    public static void sub(float[] vector1, float[] vector2) {
        vector1[0] = vector1[0] - vector2[0];
        vector1[1] = vector1[1] - vector2[1];
        vector1[2] = vector1[2] - vector2[2];
    }

    public static void rotate(float[] point, float[][] frame) {
        float x = point[0] * frame[0][0] + point[1] * frame[1][0] + point[2] * frame[2][0];
        float y = point[0] * frame[0][1] + point[1] * frame[1][1] + point[2] * frame[2][1];
        float z = point[0] * frame[0][2] + point[1] * frame[1][2] + point[2] * frame[2][2];
        point[0] = x;
        point[1] = y;
        point[2] = z;
    }

    public static void rotate(float[] point, float x, float y, float z, float angle) {
        SFRotation rotation = new SFRotation(x, y, z, angle);
        rotation.multi(point);
    }

    public static void rotate(float[] point, float[] orientation) {
        SFRotation rotation = new SFRotation(orientation);
        rotation.multi(point);
    }

    public static void getVector(float[] point1, float[] point2, float[] resultVector) {
        Geometry3D.sub(point1, point2, resultVector);
        Geometry3D.normalize(resultVector);
    }

    public static float[] getVector(float[] point1, float[] point2) {
        float[] resultVector = new float[3];
        Geometry3D.getVector(point1, point2, resultVector);
        return resultVector;
    }

    public static void getCross(float[] vector1, float[] vector2, float[] resultVector) {
        resultVector[0] = vector1[1] * vector2[2] - vector1[2] * vector2[1];
        resultVector[1] = vector1[2] * vector2[0] - vector1[0] * vector2[2];
        resultVector[2] = vector1[0] * vector2[1] - vector1[1] * vector2[0];
        Geometry3D.normalize(resultVector);
    }

    public static float[] getCross(float[] vector1, float[] vector2) {
        float[] resultVector = new float[3];
        Geometry3D.getCross(vector1, vector2, resultVector);
        return resultVector;
    }

    public static void getNormalVector(float[][] point, float[] resultVector) {
        float[] vector1 = new float[3];
        float[] vector2 = new float[3];
        for (int n = 0; n < 3; ++n) {
            vector1[n] = point[2][n] - point[1][n];
            vector2[n] = point[0][n] - point[1][n];
        }
        Geometry3D.getCross(vector1, vector2, resultVector);
    }

    public static float[] getNormalVector(float[][] point) {
        float[] resultVector = new float[3];
        Geometry3D.getNormalVector(point, resultVector);
        return resultVector;
    }

    public static float getDot(float[] vector1, float[] vector2) {
        return vector1[0] * vector2[0] + vector1[1] * vector2[1] + vector1[2] * vector2[2];
    }

    public static float getAngle(float[] vector1, float[] vector2) {
        float angle = Geometry3D.getDot(vector1, vector2) / (Geometry3D.length(vector1) * Geometry3D.length(vector2));
        angle = (float)Math.acos(angle);
        return angle;
    }

    public static boolean equals(float[] vector1, float[] vector2) {
        return vector1[0] == vector2[0] && vector1[1] == vector2[1] && vector1[2] == vector2[2];
    }
}

