/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.share;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.cybergarage.x3d.share.ShareObject;
import org.cybergarage.x3d.share.ShareWorld;
import org.cybergarage.x3d.share.ShareWorldClientSocket;
import org.cybergarage.x3d.share.ShareWorldClientSocketList;
import org.cybergarage.x3d.util.Debug;

public class ShareWorldServer
extends ShareWorld {
    private ServerSocket serverSocket;
    ShareWorldClientSocketList clientSocketList = new ShareWorldClientSocketList();

    public ShareWorldServer(int port) {
        ServerSocket serverSocket = this.createServerSocket(port);
        this.setServerSocket(serverSocket);
    }

    public ShareWorldServer() {
        this(ShareWorldServer.getDefaultSeverSocketPort());
    }

    private ServerSocket createServerSocket(int port) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return serverSocket;
    }

    private void setServerSocket(ServerSocket socket) {
        this.serverSocket = socket;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public int getNClientSockets() {
        return this.clientSocketList.size();
    }

    public void addClientSocket(ShareWorldClientSocket clientSocket) {
        this.clientSocketList.add(clientSocket);
    }

    public void removeClientSocket(ShareWorldClientSocket clientSocket) {
        this.clientSocketList.remove(clientSocket);
    }

    public ShareWorldClientSocket getClientSocket(int n) {
        return this.clientSocketList.getClientSocket(n);
    }

    public ShareWorldClientSocket[] getClientSockets() {
        return this.clientSocketList.getClientSockets();
    }

    public void distributeShareObject(ShareWorldClientSocket srcClient, ShareObject shareObject) {
        for (ShareWorldClientSocket client : this.getClientSockets()) {
            if (client == srcClient || client.postShreObject(shareObject)) continue;
            this.removeClientSocket(client);
        }
    }

    public void execute() {
        ServerSocket serverSocket = this.getServerSocket();
        try {
            Debug.message("accepting .... ");
            Socket socket = serverSocket.accept();
            Debug.message("  InetAddress = " + socket.getInetAddress());
            Debug.message("  port = " + socket.getPort());
            ShareWorldClientSocket clientSocket = new ShareWorldClientSocket(this, socket);
            this.addClientSocket(clientSocket);
            clientSocket.executeThread();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

