/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.parser;

import java.io.Reader;
import org.cybergarage.x3d.Scene;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.parser.ParserResult;
import org.cybergarage.x3d.parser.ParserStackNode;
import org.cybergarage.x3d.util.LinkedList;

public abstract class Parser
extends Scene {
    private ParserResult parserResult = new ParserResult();
    public LinkedList mNodeStackList = new LinkedList();
    public String mDefName = null;

    public void setResult(ParserResult result) {
        this.parserResult = result;
    }

    public ParserResult getResult() {
        return this.parserResult;
    }

    public void initResult() {
        this.setParseResult(false);
        this.setErrorMessage("");
    }

    public void setParseResult(boolean flag) {
        this.parserResult.setResult(flag);
    }

    public boolean getParseResult() {
        return this.parserResult.getResult();
    }

    public void setErrorMessage(String msg) {
        this.parserResult.setErrorMessage(msg);
    }

    public String getErrorMessage() {
        return this.parserResult.getErrorMessage();
    }

    public abstract boolean parse(Reader var1);

    public void pushNode(Node node) {
        ParserStackNode parserNode = new ParserStackNode(node);
        this.mNodeStackList.addNode(parserNode);
    }

    public void pushNode(Node node, int type) {
        ParserStackNode parserNode = new ParserStackNode(node, type);
        this.mNodeStackList.addNode(parserNode);
    }

    public Node popNode() {
        ParserStackNode lastNode = (ParserStackNode)this.mNodeStackList.getLastNode();
        lastNode.remove();
        return lastNode.getObject();
    }

    public Node getCurrentNode() {
        ParserStackNode lastNode = (ParserStackNode)this.mNodeStackList.getLastNode();
        if (lastNode == null) {
            return null;
        }
        return lastNode.getObject();
    }

    public int getCurrentType() {
        ParserStackNode lastNode = (ParserStackNode)this.mNodeStackList.getLastNode();
        if (lastNode == null) {
            return 0;
        }
        return lastNode.getType();
    }

    public void addNode(Node node) {
        Node parentNode = this.getCurrentNode();
        if (parentNode == null) {
            super.addNode(node);
        } else {
            parentNode.addChildNode(node);
        }
        node.setParentNode(parentNode);
    }

    public void setCurrentNodeAsInstance(String nodeName) {
        Node currNode = this.getCurrentNode();
        if (currNode != null) {
            currNode.remove();
        }
        this.popNode();
        Node defNode = this.findNode(nodeName);
        Node instanceNode = null;
        if (defNode != null) {
            instanceNode = defNode.createInstanceNode();
            this.addNode(instanceNode);
        }
        this.pushNode(instanceNode);
    }

    public void setDefName(String name) {
        this.mDefName = name;
    }

    public String getDefName() {
        String defName = this.mDefName;
        this.mDefName = null;
        return defName;
    }
}

