/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFColor;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.node.Node;

public abstract class LightNode
extends Node {
    private static final String ambientIntensityFieldName = "ambientIntensity";
    private static final String onFieldString = "on";
    private static final String intensityFieldString = "intensity";
    private static final String colorFieldString = "color";
    private SFFloat ambientIntensityField;
    private SFBool onField;
    private SFFloat intensityField;
    private SFColor colorField;

    public LightNode() {
        this.setHeaderFlag(false);
        this.ambientIntensityField = new SFFloat(0.0f);
        this.ambientIntensityField.setName(ambientIntensityFieldName);
        this.addExposedField(this.ambientIntensityField);
        this.onField = new SFBool(true);
        this.onField.setName(onFieldString);
        this.addExposedField(this.onField);
        this.intensityField = new SFFloat(1.0f);
        this.intensityField.setName(intensityFieldString);
        this.addExposedField(this.intensityField);
        this.colorField = new SFColor(1.0f, 1.0f, 1.0f);
        this.colorField.setName(colorFieldString);
        this.addExposedField(this.colorField);
    }

    public SFFloat getAmbientIntensityField() {
        if (!this.isInstanceNode()) {
            return this.ambientIntensityField;
        }
        return (SFFloat)this.getExposedField(ambientIntensityFieldName);
    }

    public void setAmbientIntensity(float value) {
        this.getAmbientIntensityField().setValue(value);
    }

    public void setAmbientIntensity(String value) {
        this.getAmbientIntensityField().setValue(value);
    }

    public float getAmbientIntensity() {
        return this.getAmbientIntensityField().getValue();
    }

    public SFBool getOnField() {
        if (!this.isInstanceNode()) {
            return this.onField;
        }
        return (SFBool)this.getExposedField(onFieldString);
    }

    public void setOn(boolean on) {
        this.getOnField().setValue(on);
    }

    public void setOn(String on) {
        this.getOnField().setValue(on);
    }

    public boolean getOn() {
        return this.getOnField().getValue();
    }

    public boolean isOn() {
        return this.getOnField().getValue();
    }

    public SFFloat getIntensityField() {
        if (!this.isInstanceNode()) {
            return this.intensityField;
        }
        return (SFFloat)this.getExposedField(intensityFieldString);
    }

    public void setIntensity(float value) {
        this.getIntensityField().setValue(value);
    }

    public void setIntensity(String value) {
        this.getIntensityField().setValue(value);
    }

    public float getIntensity() {
        return this.getIntensityField().getValue();
    }

    public void getDiffuseColor(float[] value) {
        this.getColor(value);
        float intensity = this.getIntensity();
        value[0] = value[0] * intensity;
        value[1] = value[1] * intensity;
        value[2] = value[2] * intensity;
    }

    public void getAmbientColor(float[] value) {
        this.getColor(value);
        float intensity = this.getIntensity();
        float ambientIntensity = this.getAmbientIntensity();
        value[0] = value[0] * (intensity * ambientIntensity);
        value[1] = value[1] * (intensity * ambientIntensity);
        value[2] = value[2] * (intensity * ambientIntensity);
    }

    public SFColor getColorField() {
        if (!this.isInstanceNode()) {
            return this.colorField;
        }
        return (SFColor)this.getExposedField(colorFieldString);
    }

    public void setColor(float[] value) {
        this.getColorField().setValue(value);
    }

    public void setColor(float r, float g, float b2) {
        this.getColorField().setValue(r, g, b2);
    }

    public void setColor(String value) {
        this.getColorField().setValue(value);
    }

    public void getColor(float[] value) {
        this.getColorField().getValue(value);
    }
}

