/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFFloat;
import org.cybergarage.x3d.field.MFNode;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.BoundedGroupingNode;
import org.cybergarage.x3d.node.Node;

public class LODNode
extends BoundedGroupingNode {
    private static final String centerFieldName = "center";
    private static final String rangeFieldName = "range";
    private static final String levelExposedField = "level";
    private SFVec3f centerField;
    private MFFloat rangeField;
    private MFNode levelField;

    public LODNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.LOD);
        this.centerField = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.addField(centerFieldName, this.centerField);
        this.rangeField = new MFFloat();
        this.addField(rangeFieldName, this.rangeField);
        this.levelField = new MFNode();
        this.addExposedField(levelExposedField, this.levelField);
    }

    public LODNode(LODNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFVec3f getCenterField() {
        if (!this.isInstanceNode()) {
            return this.centerField;
        }
        return (SFVec3f)this.getField(centerFieldName);
    }

    public void setCenter(float[] value) {
        this.getCenterField().setValue(value);
    }

    public void setCenter(float x, float y, float z) {
        this.getCenterField().setValue(x, y, z);
    }

    public void setCenter(String value) {
        this.getCenterField().setValue(value);
    }

    public void getCenter(float[] value) {
        this.getCenterField().getValue(value);
    }

    public MFFloat getRangeField() {
        if (!this.isInstanceNode()) {
            return this.rangeField;
        }
        return (MFFloat)this.getField(rangeFieldName);
    }

    public void addRange(float value) {
        this.getRangeField().addValue(value);
    }

    public int getNRanges() {
        return this.getRangeField().getSize();
    }

    public void setRange(int index, float value) {
        this.getRangeField().set1Value(index, value);
    }

    public void setRanges(String value) {
        this.getRangeField().setValues(value);
    }

    public void setRanges(String[] value) {
        this.getRangeField().setValues(value);
    }

    public float getRange(int index) {
        return this.getRangeField().get1Value(index);
    }

    public void removeRange(int index) {
        this.getRangeField().removeValue(index);
    }

    public MFNode getLevelField() {
        if (!this.isInstanceNode()) {
            return this.levelField;
        }
        return (MFNode)this.getExposedField(levelExposedField);
    }

    public void updateLevelField() {
        MFNode levelField = this.getLevelField();
        levelField.removeAllValues();
        for (Node node = this.getChildNodes(); node != null; node = node.next()) {
            levelField.addValue(node);
        }
    }

    public boolean isChildNodeType(Node node) {
        return node.isCommonNode() || node.isBindableNode() || node.isInterpolatorNode() || node.isSensorNode() || node.isGroupingNode() || node.isSpecialGroupNode();
    }

    public void initialize() {
        super.initialize();
        this.updateLevelField();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        SFVec3f center = this.getCenterField();
        printStream.println(indentString + "\t" + "center " + center);
        MFFloat range = this.getRangeField();
        printStream.println(indentString + "\t" + "range [");
        range.outputContext(printStream, indentString + "\t\t");
        printStream.println(indentString + "\t" + "]");
    }
}

