/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.PixelTextureNode;
import org.cybergarage.x3d.util.Debug;

public class PixelTextureNodeObject
extends Texture2D
implements NodeObject {
    public PixelTextureNodeObject(PixelTextureNode node) {
        super(1, PixelTextureNodeObject.getComponentType(node), PixelTextureNodeObject.getClosestPowerOf2(PixelTextureNodeObject.getWidth(node)), PixelTextureNodeObject.getClosestPowerOf2(PixelTextureNodeObject.getHeight(node)));
        this.setCapability(4);
        this.setCapability(0);
        this.setCapability(1);
        this.setMinFilter(3);
        this.setMagFilter(3);
        this.initialize(node);
    }

    private static int getWidth(PixelTextureNode node) {
        if (node.getNImages() < 3) {
            return 0;
        }
        return node.getImage(0);
    }

    private static int getHeight(PixelTextureNode node) {
        if (node.getNImages() < 3) {
            return 0;
        }
        return node.getImage(1);
    }

    private static int getComponentType(PixelTextureNode node) {
        if (node.getNImages() < 3) {
            return 5;
        }
        int numComponents = node.getImage(2);
        if (numComponents == 4) {
            return 6;
        }
        return 5;
    }

    private static int getClosestPowerOf2(int value) {
        if (value < 1) {
            return value;
        }
        int powerValue = 1;
        while (value >= (powerValue *= 2)) {
        }
        int minBound = powerValue / 2;
        if (powerValue - value > value - minBound) {
            return minBound;
        }
        return powerValue;
    }

    public boolean initialize(Node node) {
        Debug.message("PixelTextureNodeObject.initialize");
        PixelTextureNode texNode = (PixelTextureNode)node;
        BufferedImage bufImage = this.createBufferedImage(texNode);
        if (bufImage == null) {
            this.setEnable(false);
            return false;
        }
        int width = PixelTextureNodeObject.getWidth(texNode);
        int height = PixelTextureNodeObject.getHeight(texNode);
        Debug.message("\tj3d width  = " + PixelTextureNodeObject.getClosestPowerOf2(width));
        Debug.message("\tj3d height = " + PixelTextureNodeObject.getClosestPowerOf2(height));
        float xScale = (float)PixelTextureNodeObject.getClosestPowerOf2(width) / (float)width;
        float yScale = (float)PixelTextureNodeObject.getClosestPowerOf2(height) / (float)height;
        bufImage = this.getScaledImage(bufImage, xScale, yScale);
        ImageComponent2D imgComp = null;
        int compType = PixelTextureNodeObject.getComponentType(texNode);
        switch (compType) {
            case 5: {
                imgComp = new ImageComponent2D(1, bufImage);
                break;
            }
            case 6: {
                imgComp = new ImageComponent2D(2, bufImage);
            }
        }
        if (imgComp == null) {
            this.setEnable(false);
            return false;
        }
        imgComp.setCapability(1);
        imgComp.setCapability(2);
        imgComp.setCapability(0);
        this.setImage(0, (ImageComponent)imgComp);
        this.setEnable(true);
        return true;
    }

    public int RGBA2ARGB(int rgba) {
        int argb = 0;
        argb |= (rgba & 0xFFFFFF00) >> 8 & 0xFFFFFF;
        return argb |= (rgba & 0xFF) << 24 & 0xFF000000;
    }

    public BufferedImage createBufferedImage(PixelTextureNode node) {
        BufferedImage bufImage = null;
        int width = PixelTextureNodeObject.getWidth(node);
        int height = PixelTextureNodeObject.getHeight(node);
        Debug.message("\twidth  = " + width);
        Debug.message("\theight = " + height);
        int compType = PixelTextureNodeObject.getComponentType(node);
        switch (compType) {
            case 5: {
                bufImage = new BufferedImage(width, height, 1);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        bufImage.setRGB(x, height - 1 - y, node.getImage(x + y * width + 3));
                    }
                }
                break;
            }
            case 6: {
                bufImage = new BufferedImage(width, height, 2);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        bufImage.setRGB(x, height - 1 - y, this.RGBA2ARGB(node.getImage(x + y * width + 3)));
                    }
                }
                break;
            }
        }
        return bufImage;
    }

    private BufferedImage getScaledImage(BufferedImage origImage, float xScale, float yScale) {
        if (xScale == 1.0f && yScale == 1.0f) {
            return origImage;
        }
        AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
        AffineTransformOp atop = new AffineTransformOp(at, 2);
        BufferedImage scaledImage = atop.filter(origImage, null);
        return scaledImage;
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        return true;
    }

    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isAppearanceNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Appearance parentAppearanceNode = (Appearance)parentNodeObject;
            parentAppearanceNode.setTexture((Texture)this);
        }
        return true;
    }

    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isAppearanceNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Appearance parentAppearanceNode = (Appearance)parentNodeObject;
            parentAppearanceNode.setTexture(null);
        }
        return true;
    }
}

