/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.vecmath.Color3f;
import org.cybergarage.x3d.j3d.NullMaterialObject;
import org.cybergarage.x3d.node.MaterialNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;

public class MaterialNodeObject
extends Material
implements NodeObject {
    public MaterialNodeObject(MaterialNode node) {
        this.setCapability(0);
        this.setCapability(1);
        this.initialize(node);
    }

    public boolean initialize(Node node) {
        node.setRunnable(true);
        node.setRunnableType(1);
        this.update(node);
        return true;
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        MaterialNode matNode = (MaterialNode)node;
        float[] color = new float[3];
        matNode.getAmbientColor(color);
        Color3f ambColor3f = new Color3f(color);
        this.setAmbientColor(ambColor3f);
        matNode.getDiffuseColor(color);
        Color3f diffColor3f = new Color3f(color);
        this.setDiffuseColor(diffColor3f);
        matNode.getEmissiveColor(color);
        Color3f emiColor3f = new Color3f(color);
        this.setEmissiveColor(emiColor3f);
        matNode.getSpecularColor(color);
        Color3f speColor3f = new Color3f(color);
        this.setSpecularColor(speColor3f);
        this.setShininess(matNode.getShininess());
        return true;
    }

    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isAppearanceNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Appearance parentAppearanceNode = (Appearance)parentNodeObject;
            parentAppearanceNode.setMaterial((Material)this);
        }
        return true;
    }

    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isAppearanceNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Appearance parentAppearanceNode = (Appearance)parentNodeObject;
            parentAppearanceNode.setMaterial((Material)new NullMaterialObject());
        }
        return true;
    }
}

