/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.j3d.SwitchNodeObject;
import org.cybergarage.x3d.node.LODNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.ViewpointNode;
import org.cybergarage.x3d.util.Geometry3D;

public class LODNodeObject
extends SwitchNodeObject
implements NodeObject {
    private SFMatrix viewMatrix = new SFMatrix();
    private float[] viewPosition = new float[3];
    private SFMatrix lodMatrix = new SFMatrix();
    private float[] lodCenter = new float[3];

    public LODNodeObject(LODNode node) {
    }

    public boolean update(Node node) {
        int nRange;
        SceneGraph sg = node.getSceneGraph();
        if (sg == null) {
            return false;
        }
        ViewpointNode view = sg.getViewpointNode();
        if (view == null) {
            view = sg.getDefaultViewpointNode();
        }
        LODNode LODNode2 = (LODNode)node;
        view.getTransformMatrix(this.viewMatrix);
        view.getPosition(this.viewPosition);
        this.viewMatrix.multi(this.viewPosition);
        LODNode2.getTransformMatrix(this.lodMatrix);
        LODNode2.getCenter(this.lodCenter);
        this.lodMatrix.multi(this.lodCenter);
        float distance = Geometry3D.distance(this.viewPosition, this.lodCenter);
        int numRanges = LODNode2.getNRanges();
        for (nRange = 0; nRange < numRanges && !(distance < LODNode2.getRange(nRange)); ++nRange) {
        }
        if (nRange == this.getWhichChild()) {
            return true;
        }
        int numChildren = this.numChildren();
        if (nRange < numChildren) {
            this.setWhichChild(nRange);
        } else {
            this.setWhichChild(numChildren - 1);
        }
        return true;
    }
}

