/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import org.cybergarage.x3d.field.MFInt32;
import org.cybergarage.x3d.j3d.NullGeometryObject;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.IndexedLineSetNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.util.Debug;

public class IndexedLineSetNodeObject
extends IndexedLineArray
implements NodeObject {
    public IndexedLineSetNodeObject(IndexedLineSetNode node) {
        super(IndexedLineSetNodeObject.getVertexCount(node), IndexedLineSetNodeObject.getVertexFormat(node), node.getNLines() * 2);
        this.setCapability(0);
        this.setCapability(1);
        this.setCapability(2);
        this.setCapability(3);
        this.setCapability(4);
        this.setCapability(5);
        this.setCapability(6);
        this.setCapability(7);
        this.setCapability(8);
        this.setCapability(20);
        this.setCapability(17);
        this.setCapability(11);
        this.setCapability(12);
        this.setCapability(9);
        this.setCapability(10);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        this.setCapability(16);
        this.initialize(node);
    }

    public static int getVertexCount(IndexedLineSetNode node) {
        return node.getCoordinateNodes() != null ? node.getCoordinateNodes().getNPoints() : 0;
    }

    public static int getVertexFormat(IndexedLineSetNode node) {
        int vertexFormat = 1;
        if (node.getColorNodes() != null) {
            vertexFormat |= 4;
        }
        return vertexFormat;
    }

    private void disableLightInMaterialNode(Node node) {
        Material material;
        Shape3D parentShape3DNode;
        Appearance app;
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null && (app = (parentShape3DNode = (Shape3D)parentNodeObject).getAppearance()) != null && (material = app.getMaterial()) != null) {
            material.setLightingEnable(false);
        }
    }

    public boolean initialize(Node node) {
        ColorNode colorNode;
        IndexedLineSetNode idxLineSetNode = (IndexedLineSetNode)node;
        MFInt32 index = new MFInt32();
        int nLines = 0;
        int nCoordinatePoints = 0;
        int nCoordIndices = idxLineSetNode.getNCoordIndices();
        CoordinateNode coordNode = idxLineSetNode.getCoordinateNodes();
        if (coordNode != null) {
            int n;
            float[] point = new float[3];
            nCoordinatePoints = coordNode.getNPoints();
            for (n = 0; n < nCoordinatePoints; ++n) {
                coordNode.getPoint(n, point);
                this.setCoordinate(n, point);
            }
            index.clear();
            nLines = 0;
            for (n = 0; n < nCoordIndices; ++n) {
                int id = idxLineSetNode.getCoordIndex(n);
                Debug.message("IndexedLineSetNodeObject::initialize = " + nCoordIndices + ", " + n + ", " + id);
                if (id != -1) {
                    index.addValue(id);
                }
                if (id != -1 && n != nCoordIndices - 1) continue;
                int indexSize = index.getSize();
                for (int i = 0; i < indexSize - 1; ++i) {
                    this.setCoordinateIndex(nLines, index.get1Value(i));
                    this.setCoordinateIndex(++nLines, index.get1Value(i + 1));
                    ++nLines;
                }
                index.clear();
            }
        }
        if ((colorNode = idxLineSetNode.getColorNodes()) != null) {
            boolean hasColorIndices;
            int nColorIndices;
            float[] color = new float[3];
            int nColors = colorNode.getNColors();
            for (int n = 0; n < nColors && n < nCoordinatePoints; ++n) {
                colorNode.getColor(n, color);
                this.setColor(n, color);
            }
            index.clear();
            nLines = 0;
            if (idxLineSetNode.isColorPerVertex()) {
                nColorIndices = idxLineSetNode.getNColorIndices();
                boolean bl = hasColorIndices = nCoordIndices <= nColorIndices;
                if (!hasColorIndices) {
                    nColorIndices = nCoordIndices;
                }
                for (int n = 0; n < nColorIndices; ++n) {
                    int id = 0;
                    id = hasColorIndices ? idxLineSetNode.getColorIndex(n) : idxLineSetNode.getCoordIndex(n);
                    if (id != -1) {
                        index.addValue(id);
                    }
                    if (id != -1 && n != nColorIndices - 1) continue;
                    int indexSize = index.getSize();
                    for (int i = 0; i < indexSize - 1; ++i) {
                        this.setColorIndex(nLines++, index.get1Value(i));
                        this.setColorIndex(nLines++, index.get1Value(i + 1));
                    }
                    index.clear();
                }
            } else {
                nColorIndices = idxLineSetNode.getNColorIndices();
                hasColorIndices = idxLineSetNode.getNLines() <= nColorIndices;
                int lineNum = 0;
                for (int n = 0; n < nCoordIndices; ++n) {
                    int id = idxLineSetNode.getCoordIndex(n);
                    if (id != -1) {
                        index.addValue(id);
                    }
                    if (id != -1 && n != nCoordIndices - 1) continue;
                    int indexSize = index.getSize();
                    for (int i = 0; i < indexSize - 1; ++i) {
                        int normalIndex = 0;
                        normalIndex = hasColorIndices ? idxLineSetNode.getColorIndex(lineNum) : lineNum;
                        this.setColorIndex(nLines++, normalIndex);
                        this.setColorIndex(nLines++, normalIndex);
                    }
                    index.clear();
                    ++lineNum;
                }
            }
        }
        this.disableLightInMaterialNode(node);
        return true;
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        return true;
    }

    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)this);
            this.disableLightInMaterialNode(node);
        }
        return true;
    }

    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)new NullGeometryObject());
        }
        return true;
    }
}

