/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Geometry;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import org.cybergarage.x3d.j3d.NullGeometryObject;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.ElevationGridNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.TextureCoordinateNode;
import org.cybergarage.x3d.util.Debug;
import org.cybergarage.x3d.util.Geometry3D;

public class ElevationGridNodeObject
extends IndexedTriangleArray
implements NodeObject {
    public ElevationGridNodeObject(ElevationGridNode elevGridNode) {
        super(elevGridNode.getVertexCount(), ElevationGridNodeObject.getVertexFormat(elevGridNode), elevGridNode.getNTriangleCoordIndices());
        this.setCapability(0);
        this.setCapability(1);
        this.setCapability(2);
        this.setCapability(3);
        this.setCapability(4);
        this.setCapability(5);
        this.setCapability(6);
        this.setCapability(7);
        this.setCapability(8);
        this.setCapability(20);
        this.setCapability(17);
        this.setCapability(11);
        this.setCapability(12);
        this.setCapability(9);
        this.setCapability(10);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        this.setCapability(16);
        this.setCapability(18);
        this.initialize(elevGridNode);
    }

    public static int getVertexFormat(ElevationGridNode elevGridNode) {
        return 39;
    }

    public void getNormalVector(int coordIndex1, int coordIndex2, int coordIndex3, float[] normal) {
        float[][] vertex = new float[3][3];
        this.getCoordinate(coordIndex1, vertex[0]);
        this.getCoordinate(coordIndex2, vertex[1]);
        this.getCoordinate(coordIndex3, vertex[2]);
        Geometry3D.getNormalVector(vertex, normal);
    }

    public void getNormalVector(float[][] normal, int nNormal, float[] resultVector) {
        Geometry3D.initialize(resultVector);
        for (int n = 0; n < nNormal; ++n) {
            Geometry3D.add(resultVector, normal[n]);
            Geometry3D.normalize(resultVector);
        }
    }

    public void setCoordinateIndexforDebug(int n, int nCoord) {
        Debug.message("\t\t[" + n + "] = " + nCoord);
        this.setCoordinateIndex(n, nCoord);
    }

    public boolean initialize(Node node) {
        Object normal;
        Object color;
        int x;
        int z;
        Debug.message("ElevationGridNodeObject::initialize");
        ElevationGridNode elevGridNode = (ElevationGridNode)node;
        int xDimension = elevGridNode.getXDimension();
        int zDimension = elevGridNode.getZDimension();
        int nDimensionPoints = xDimension * zDimension;
        float xSpacing = elevGridNode.getXSpacing();
        float zSpacing = elevGridNode.getZSpacing();
        Debug.message("\tinitialize coordinate points ..... ");
        float[] point = new float[3];
        int nPoint = 0;
        for (z = 0; z < zDimension; ++z) {
            for (x = 0; x < xDimension; ++x) {
                point[0] = xSpacing * (float)x;
                point[1] = elevGridNode.getHeight(x + z * xDimension);
                point[2] = zSpacing * (float)z;
                this.setCoordinate(nPoint, point);
                Debug.message("\t\tpoint[" + nPoint + "] = " + point[0] + ", " + point[1] + ", " + point[2]);
                ++nPoint;
            }
        }
        Debug.message("\tinitialize coordinate index ..... ");
        int nTriangle = 0;
        for (z = 0; z < zDimension - 1; ++z) {
            for (x = 0; x < xDimension - 1; ++x) {
                this.setCoordinateIndexforDebug(nTriangle * 3 + 0, x + 0 + (z + 0) * xDimension);
                this.setCoordinateIndexforDebug(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                this.setCoordinateIndexforDebug(nTriangle * 3 + 2, x + 1 + (z + 0) * xDimension);
                this.setCoordinateIndexforDebug(++nTriangle * 3 + 0, x + 1 + (z + 0) * xDimension);
                this.setCoordinateIndexforDebug(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                this.setCoordinateIndexforDebug(nTriangle * 3 + 2, x + 1 + (z + 1) * xDimension);
                ++nTriangle;
            }
        }
        Debug.message("\tinitialize Color ..... ");
        ColorNode colorNode = elevGridNode.getColorNodes();
        if (colorNode != null) {
            color = new float[3];
            int nColors = colorNode.getNColors();
            for (int n = 0; n < nColors; ++n) {
                colorNode.getColor(n, (float[])color);
                this.setColor(n, (float[])color);
            }
            boolean bNormalPerVertex = elevGridNode.isColorPerVertex();
            nTriangle = 0;
            for (z = 0; z < zDimension; ++z) {
                for (x = 0; x < xDimension; ++x) {
                    if (bNormalPerVertex) {
                        this.setColorIndex(nTriangle * 3 + 0, x + 0 + (z + 0) * xDimension);
                        this.setColorIndex(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                        this.setColorIndex(nTriangle * 3 + 2, x + 1 + (z + 0) * xDimension);
                        this.setColorIndex(++nTriangle * 3 + 0, x + 1 + (z + 0) * xDimension);
                        this.setColorIndex(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                        this.setColorIndex(nTriangle * 3 + 2, x + 1 + (z + 1) * xDimension);
                        ++nTriangle;
                        continue;
                    }
                    this.setColorIndex(nTriangle * 3 + 0, x + z * xDimension);
                    this.setColorIndex(nTriangle * 3 + 1, x + z * xDimension);
                    this.setColorIndex(nTriangle * 3 + 2, x + z * xDimension);
                    this.setColorIndex(++nTriangle * 3 + 0, x + z * xDimension);
                    this.setColorIndex(nTriangle * 3 + 1, x + z * xDimension);
                    this.setColorIndex(nTriangle * 3 + 2, x + z * xDimension);
                    ++nTriangle;
                }
            }
        } else {
            color = new Color3f(1.0f, 1.0f, 1.0f);
            nPoint = 0;
            for (z = 0; z < zDimension; ++z) {
                for (x = 0; x < xDimension; ++x) {
                    this.setColor(nPoint, (Color3f)color);
                    ++nPoint;
                }
            }
            nTriangle = 0;
            for (z = 0; z < zDimension - 1; ++z) {
                for (x = 0; x < xDimension - 1; ++x) {
                    this.setColorIndex(nTriangle * 3 + 0, x + 0 + (z + 0) * xDimension);
                    this.setColorIndex(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                    this.setColorIndex(nTriangle * 3 + 2, x + 1 + (z + 0) * xDimension);
                    this.setColorIndex(++nTriangle * 3 + 0, x + 1 + (z + 0) * xDimension);
                    this.setColorIndex(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                    this.setColorIndex(nTriangle * 3 + 2, x + 1 + (z + 1) * xDimension);
                    ++nTriangle;
                }
            }
        }
        Debug.message("\tinitialize Normal ..... ");
        NormalNode normalNode = elevGridNode.getNormalNodes();
        if (normalNode != null) {
            normal = new float[3];
            int nNormals = normalNode.getNVectors();
            for (int n = 0; n < nNormals; ++n) {
                normalNode.getVector(n, (float[])normal);
                this.setNormal(n, (float[])normal);
            }
            boolean bNormalPerVertex = elevGridNode.isNormalPerVertex();
            nTriangle = 0;
            for (z = 0; z < zDimension; ++z) {
                for (x = 0; x < xDimension; ++x) {
                    if (bNormalPerVertex) {
                        this.setNormalIndex(nTriangle * 3 + 0, x + 0 + (z + 0) * xDimension);
                        this.setNormalIndex(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                        this.setNormalIndex(nTriangle * 3 + 2, x + 1 + (z + 0) * xDimension);
                        this.setNormalIndex(++nTriangle * 3 + 0, x + 1 + (z + 0) * xDimension);
                        this.setNormalIndex(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                        this.setNormalIndex(nTriangle * 3 + 2, x + 1 + (z + 1) * xDimension);
                        ++nTriangle;
                        continue;
                    }
                    this.setNormalIndex(nTriangle * 3 + 0, x + z * xDimension);
                    this.setNormalIndex(nTriangle * 3 + 1, x + z * xDimension);
                    this.setNormalIndex(nTriangle * 3 + 2, x + z * xDimension);
                    this.setNormalIndex(++nTriangle * 3 + 0, x + z * xDimension);
                    this.setNormalIndex(nTriangle * 3 + 1, x + z * xDimension);
                    this.setNormalIndex(nTriangle * 3 + 2, x + z * xDimension);
                    ++nTriangle;
                }
            }
        } else {
            normal = new float[4][3];
            float[] coordNormal = new float[3];
            nPoint = 0;
            for (z = 0; z < zDimension; ++z) {
                for (x = 0; x < xDimension; ++x) {
                    if (x == 0) {
                        if (z == 0) {
                            this.getNormalVector(nPoint, nPoint + 1, nPoint + xDimension, coordNormal);
                        } else if (z == zDimension - 1) {
                            this.getNormalVector(nPoint - xDimension, nPoint + 1, nPoint, coordNormal);
                        } else {
                            this.getNormalVector(nPoint - xDimension, nPoint + 1, nPoint, (float[])normal[0]);
                            this.getNormalVector(nPoint, nPoint + 1, nPoint + xDimension, (float[])normal[1]);
                            this.getNormalVector((float[][])normal, 2, coordNormal);
                        }
                    } else if (x == xDimension - 1) {
                        if (z == 0) {
                            this.getNormalVector(nPoint - 1, nPoint, nPoint + xDimension, coordNormal);
                        } else if (z == zDimension - 1) {
                            this.getNormalVector(nPoint - xDimension, nPoint, nPoint - 1, coordNormal);
                        } else {
                            this.getNormalVector(nPoint - xDimension, nPoint, nPoint - 1, (float[])normal[0]);
                            this.getNormalVector(nPoint - 1, nPoint, nPoint + xDimension, (float[])normal[1]);
                            this.getNormalVector((float[][])normal, 2, coordNormal);
                        }
                    } else if (z == 0) {
                        this.getNormalVector(nPoint - 1, nPoint, nPoint + xDimension, (float[])normal[0]);
                        this.getNormalVector(nPoint, nPoint + 1, nPoint + xDimension, (float[])normal[1]);
                        this.getNormalVector((float[][])normal, 2, coordNormal);
                    } else if (z == zDimension - 1) {
                        this.getNormalVector(nPoint - xDimension, nPoint, nPoint - 1, (float[])normal[0]);
                        this.getNormalVector(nPoint - xDimension, nPoint + 1, nPoint, (float[])normal[1]);
                        this.getNormalVector((float[][])normal, 2, coordNormal);
                    } else {
                        this.getNormalVector(nPoint - xDimension, nPoint, nPoint - 1, (float[])normal[0]);
                        this.getNormalVector(nPoint - xDimension, nPoint + 1, nPoint, (float[])normal[1]);
                        this.getNormalVector(nPoint - 1, nPoint, nPoint + xDimension, (float[])normal[2]);
                        this.getNormalVector(nPoint, nPoint + 1, nPoint + xDimension, (float[])normal[3]);
                        this.getNormalVector((float[][])normal, 4, coordNormal);
                    }
                    this.setNormal(nPoint, coordNormal);
                    Debug.message("\t\tnormal[" + x + "][" + z + "] = " + coordNormal[0] + ", " + coordNormal[1] + ", " + coordNormal[2]);
                    ++nPoint;
                }
            }
            nTriangle = 0;
            for (z = 0; z < zDimension - 1; ++z) {
                for (x = 0; x < xDimension - 1; ++x) {
                    this.setNormalIndex(nTriangle * 3 + 0, x + 0 + (z + 0) * xDimension);
                    this.setNormalIndex(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                    this.setNormalIndex(nTriangle * 3 + 2, x + 1 + (z + 0) * xDimension);
                    this.setNormalIndex(++nTriangle * 3 + 0, x + 1 + (z + 0) * xDimension);
                    this.setNormalIndex(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                    this.setNormalIndex(nTriangle * 3 + 2, x + 1 + (z + 1) * xDimension);
                    ++nTriangle;
                }
            }
        }
        Debug.message("\tinitialize TextureCoordinate ..... ");
        TextureCoordinateNode texCoordNode = elevGridNode.getTextureCoordinateNodes();
        float[] texCoord = new float[2];
        if (texCoordNode != null) {
            int nTexCoordPoints = texCoordNode.getNPoints();
            for (int n = 0; n < nTexCoordPoints; ++n) {
                texCoordNode.getPoint(n, texCoord);
                this.setTextureCoordinate(n, texCoord);
            }
        } else {
            int nTexCoord = 0;
            for (z = 0; z < zDimension; ++z) {
                for (x = 0; x < xDimension; ++x) {
                    texCoord[0] = (float)x / (float)(xDimension - 1);
                    texCoord[1] = (float)z / (float)(zDimension - 1);
                    this.setTextureCoordinate(nTexCoord, texCoord);
                    ++nTexCoord;
                }
            }
        }
        nTriangle = 0;
        for (z = 0; z < zDimension - 1; ++z) {
            for (x = 0; x < xDimension - 1; ++x) {
                this.setTextureCoordinateIndex(nTriangle * 3 + 0, x + 0 + (z + 0) * xDimension);
                this.setTextureCoordinateIndex(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                this.setTextureCoordinateIndex(nTriangle * 3 + 2, x + 1 + (z + 0) * xDimension);
                this.setTextureCoordinateIndex(++nTriangle * 3 + 0, x + 1 + (z + 0) * xDimension);
                this.setTextureCoordinateIndex(nTriangle * 3 + 1, x + 0 + (z + 1) * xDimension);
                this.setTextureCoordinateIndex(nTriangle * 3 + 2, x + 1 + (z + 1) * xDimension);
                ++nTriangle;
            }
        }
        return true;
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        return true;
    }

    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)this);
        }
        return true;
    }

    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)new NullGeometryObject());
        }
        return true;
    }
}

