/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.FieldType;
import org.cybergarage.x3d.field.Vec2dValue;

public class SFVec2d
extends Field {
    private Vec2dValue mVector = new Vec2dValue();

    public SFVec2d() {
        this.setType(FieldType.SFVEC2D);
        this.setValue(0.0, 0.0);
    }

    public SFVec2d(SFVec2d vector) {
        this();
        this.setValue(vector);
    }

    public SFVec2d(double x, double y) {
        this();
        this.setValue(x, y);
    }

    public SFVec2d(double[] value) {
        this();
        this.setValue(value);
    }

    public SFVec2d(String value) {
        this();
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(Object object) {
        Vec2dValue vec2dValue = this.mVector;
        synchronized (vec2dValue) {
            this.mVector = (Vec2dValue)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        Vec2dValue object;
        Vec2dValue vec2dValue = this.mVector;
        synchronized (vec2dValue) {
            object = this.mVector;
        }
        return object;
    }

    public void getValue(double[] value) {
        this.mVector.getValue(value);
    }

    public double[] getValue() {
        return this.mVector.getValue();
    }

    public double getX() {
        return this.mVector.getX();
    }

    public double getY() {
        return this.mVector.getY();
    }

    public int getValueCount() {
        return 2;
    }

    public void setValue(double x, double y, boolean doShare) {
        this.mVector.setValue(x, y);
        if (doShare) {
            this.postShareField(this);
        }
    }

    public void setValue(double x, double y) {
        this.setValue(x, y, true);
    }

    public void setValue(double[] value) {
        if (value.length < 2) {
            return;
        }
        this.setValue(value[0], value[1]);
    }

    public void setValue(SFVec2d vector, boolean doShare) {
        this.setValue(vector.getX(), vector.getY(), doShare);
    }

    public void setValue(SFVec2d vector) {
        this.setValue(vector, true);
    }

    public void setValue(String string) {
        this.mVector.setValue(string);
    }

    public void setValue(Field field, boolean doShare) {
        if (field instanceof SFVec2d) {
            this.setValue((SFVec2d)field, doShare);
        }
    }

    public void setValue(Field field) {
        this.setValue(field, true);
    }

    public void setX(double x) {
        this.setValue(x, this.getY());
    }

    public void setY(double y) {
        this.setValue(this.getX(), y);
    }

    public void add(double x, double y) {
        this.mVector.add(x, y);
    }

    public void add(double[] value) {
        this.mVector.add(value);
    }

    public void add(SFVec2d value) {
        this.add(value.getValue());
    }

    public void sub(double x, double y) {
        this.mVector.sub(x, y);
    }

    public void sub(double[] value) {
        this.mVector.sub(value);
    }

    public void sub(SFVec2d value) {
        this.sub(value.getValue());
    }

    public void scale(double scale) {
        this.mVector.scale(scale);
    }

    public void invert() {
        this.mVector.invert();
    }

    public double getScalar() {
        return this.mVector.getScalar();
    }

    public void normalize() {
        this.mVector.normalize();
    }

    public String toString() {
        return this.getX() + " " + this.getY();
    }
}

