/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.FieldType;
import org.cybergarage.x3d.field.ColorRGBAValue;
import org.cybergarage.x3d.field.SFColor;

public class SFColorRGBA
extends Field {
    private ColorRGBAValue mValue = new ColorRGBAValue();

    public SFColorRGBA() {
        this.setType(FieldType.SFCOLORRGBA);
        this.setValue(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public SFColorRGBA(SFColor color) {
        this.setType(FieldType.SFCOLORRGBA);
        this.setValue(color);
    }

    public SFColorRGBA(float r, float g, float b2, float a2) {
        this.setType(FieldType.SFCOLORRGBA);
        this.setValue(r, g, b2, a2);
    }

    public SFColorRGBA(float[] value) {
        this.setType(FieldType.SFCOLORRGBA);
        this.setValue(value);
    }

    public SFColorRGBA(String value) {
        this.setType(FieldType.SFCOLORRGBA);
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(Object object) {
        ColorRGBAValue colorRGBAValue = this.mValue;
        synchronized (colorRGBAValue) {
            this.mValue = (ColorRGBAValue)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        ColorRGBAValue object;
        ColorRGBAValue colorRGBAValue = this.mValue;
        synchronized (colorRGBAValue) {
            object = this.mValue;
        }
        return object;
    }

    public void getValue(float[] value) {
        this.mValue.getValue(value);
    }

    public float[] getValue() {
        return this.mValue.getValue();
    }

    public float getRed() {
        return this.mValue.getRed();
    }

    public float getGreen() {
        return this.mValue.getGreen();
    }

    public float getBlue() {
        return this.mValue.getBlue();
    }

    public float getAlpha() {
        return this.mValue.getAlpha();
    }

    public int getValueCount() {
        return 4;
    }

    public void setValue(float r, float g, float b2, float a2, boolean doShare) {
        this.mValue.setValue(r, g, b2, a2);
        if (doShare) {
            this.postShareField(this);
        }
    }

    public void setValue(float r, float g, float b2, float a2) {
        this.setValue(r, g, b2, a2, true);
    }

    public void setValue(float[] value) {
        if (value.length < 4) {
            return;
        }
        this.setValue(value[0], value[1], value[2], value[3]);
    }

    public void setValue(SFColorRGBA color, boolean doShare) {
        this.setValue(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), doShare);
    }

    public void setValue(SFColorRGBA color) {
        this.setValue(color, true);
    }

    public void setValue(String string) {
        this.mValue.setValue(string);
    }

    public void setValue(Field field, boolean doShare) {
        if (field instanceof SFColorRGBA) {
            this.setValue((SFColorRGBA)field, doShare);
        }
    }

    public void setValue(Field field) {
        this.setValue(field, true);
    }

    public void add(float r, float g, float b2, float a2) {
        this.mValue.add(r, g, b2, a2);
    }

    public void add(float[] value) {
        this.mValue.add(value);
    }

    public void add(SFColorRGBA value) {
        this.add(value.getValue());
    }

    public void sub(float r, float g, float b2, float a2) {
        this.mValue.sub(r, g, b2, a2);
    }

    public void sub(float[] value) {
        this.mValue.sub(value);
    }

    public void sub(SFColorRGBA value) {
        this.sub(value.getValue());
    }

    public void scale(float scale) {
        this.mValue.scale(scale);
    }

    public String toString() {
        return this.getRed() + " " + this.getGreen() + " " + this.getBlue() + " " + this.getAlpha();
    }
}

