/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.sftp;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.ssh.SessionCreator;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.sftp.SftpEvent;
import ciss.phase_viewer.ssh.sftp.SftpListener;
import ciss.phase_viewer.ssh.sftp.SilentMyProgressMonitor;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Sftp {
    private static Logger logger = Logger.getLogger(Sftp.class.getName());
    private HostInfo host;
    private ChannelSftp c;
    private Session session;
    private Channel channel;
    private Vector listeners = new Vector();

    public Sftp(HostInfo host) {
        this.host = host;
    }

    public void addSftpListener(SftpListener sl) {
        this.listeners.add(sl);
    }

    public void connect() {
        try {
            logger.info("sftp connection to host: " + this.host.getName());
            this.session = SessionCreator.getSession(this.host, 5000);
            this.session.setTimeout(0);
            this.channel = this.session.openChannel("sftp");
            this.channel.connect();
        }
        catch (JSchException e) {
            logger.error("failed connection");
            e.printStackTrace();
            return;
        }
        this.c = (ChannelSftp)this.channel;
    }

    public void disconnect() {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    public Session getSession() {
        return this.session;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void lcd(String lcdpath) {
        if (this.c == null) {
            logger.info("not connected.");
            return;
        }
        try {
            this.c.lcd(lcdpath);
            logger.debug("changed local directory to: " + lcdpath);
        }
        catch (SftpException se) {
            logger.error("failed to change local directory");
        }
    }

    public void lcd(File file) {
        if (this.c == null) {
            logger.info("not connected.");
            return;
        }
        String lcdpath = file.getAbsolutePath();
        try {
            this.c.lcd(lcdpath);
            logger.debug("changed local directory to: " + lcdpath);
        }
        catch (SftpException se) {
            logger.error("failed to change local directory");
        }
    }

    public void cd(String cdpath) {
        if (this.c == null) {
            logger.info("not connected");
            return;
        }
        try {
            this.c.cd(cdpath);
            logger.debug("changed remote directory to: " + cdpath);
        }
        catch (SftpException se) {
            logger.error("failed to change remote directory");
        }
    }

    public void download(RemoteFile[] files, RemoteFile dir, boolean recursive) {
        if (this.c == null) {
            logger.info("not connected.");
            return;
        }
        dir.mkdirs();
        new Thread(new Download(files, dir, this.c, this.listeners, recursive)).start();
    }

    public void download(RemoteFile[] files, RemoteFile dir) {
        if (this.c == null) {
            logger.info("not connected.");
            return;
        }
        dir.mkdirs();
        new Thread(new Download(files, dir, this.c, this.listeners)).start();
    }

    public void upload(RemoteFile[] files, RemoteFile dir, String localDir, boolean fork) {
        if (this.c == null) {
            logger.info("not connected.");
            return;
        }
        dir.mkdirs();
        if (fork) {
            new Thread(new Upload(files, dir, localDir, this.c, this.listeners)).start();
        } else {
            Upload up = new Upload(files, dir, localDir, this.c, this.listeners);
            up.upload();
        }
    }

    public void upload(RemoteFile[] files, RemoteFile dir, String localDir) {
        this.upload(files, dir, localDir, true);
    }

    public void ls(File dir) {
        if (this.c == null) {
            logger.info("not connected.");
            return;
        }
        String path = ".";
        try {
            Vector lsvec = this.c.ls(path);
            if (lsvec != null) {
                for (int i = 0; i < lsvec.size(); ++i) {
                    logger.debug((String)lsvec.get(i));
                }
            }
        }
        catch (SftpException se) {
            logger.error("failed to perform the \"ls\" command");
        }
    }

    public ChannelSftp getChannelSftp() {
        return this.c;
    }

    public void test() {
        if (this.c != null) {
            RemoteFile remote = new RemoteFile("", this.c);
            logger.debug("rem. file: " + remote);
            RemoteFile parent = (RemoteFile)remote.getParentFile();
            logger.debug("parent of rem: " + parent);
            remote.exists();
            parent.exists();
            RemoteFile[] files = (RemoteFile[])remote.listFiles();
            if (files != null) {
                logger.debug("list of files");
                for (int i = 0; i < files.length; ++i) {
                    logger.debug(files[i]);
                }
            }
        }
    }

    private boolean checkDupli(String fname, RemoteFile dir, boolean ignoreCase) {
        File[] list = dir.listFiles();
        if (list == null || list.length == 0) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (ignoreCase && list[i].getName().equalsIgnoreCase(fname)) {
                return true;
            }
            if (!list[i].getName().equals(fname)) continue;
            return true;
        }
        return false;
    }

    private String getUniqueFileName(String origFname, RemoteFile dir, boolean ignoreCase) {
        File[] list = dir.listFiles();
        if (list == null || list.length == 0) {
            logger.debug("returning orig. name " + origFname);
            return origFname;
        }
        if (this.checkDupli(origFname, dir, ignoreCase)) {
            String[] arr;
            String[] split_by_period = origFname.split("\\.");
            String testString = "";
            if (split_by_period.length > 1) {
                for (int i = 0; i < split_by_period.length - 1; ++i) {
                    testString = testString + split_by_period[i];
                }
            } else {
                testString = split_by_period[0];
            }
            if ((arr = testString.split("_")).length <= 1 || !Utils.isNumber(arr[arr.length - 1])) {
                String newName = testString + "_1";
                if (split_by_period.length > 1) {
                    newName = newName + "." + split_by_period[split_by_period.length - 1];
                }
                return this.getUniqueFileName(newName, dir, ignoreCase);
            }
            int num = Integer.parseInt(arr[arr.length - 1]);
            String ret = "";
            for (int i = 0; i < arr.length - 1; ++i) {
                ret = ret + arr[i] + "_";
            }
            ret = ret + String.valueOf(num + 1);
            if (split_by_period.length > 1) {
                ret = ret + "." + split_by_period[split_by_period.length - 1];
            }
            return this.getUniqueFileName(ret, dir, ignoreCase);
        }
        logger.debug("returning " + origFname);
        return origFname;
    }

    class Download
    implements Runnable {
        private RemoteFile[] files;
        private RemoteFile dir;
        private ChannelSftp c;
        private Vector listeners;
        private boolean recursive = true;

        protected Download(RemoteFile[] files, RemoteFile dir, ChannelSftp c2, Vector listeners) {
            this.files = files;
            this.dir = dir;
            this.c = c2;
            this.listeners = listeners;
        }

        protected Download(RemoteFile[] files, RemoteFile dir, ChannelSftp c2, Vector listeners, boolean recursive) {
            this.files = files;
            this.dir = dir;
            this.c = c2;
            this.listeners = listeners;
            this.recursive = recursive;
        }

        public void run() {
            this.download(this.files, this.dir);
        }

        private void download(RemoteFile[] files, RemoteFile dir) {
            int i;
            if (files != null && dir != null) {
                for (i = 0; i < files.length; ++i) {
                    String downfile = files[i].getAbsolutePath();
                    if (files[i].isDirectory()) {
                        if (this.recursive || files[i].getName().trim().equals(".") || files[i].getName().trim().equals("..")) continue;
                        RemoteFile newDir = new RemoteFile(dir.getAbsolutePath(), files[i].getName());
                        newDir.mkdir();
                        this.download((RemoteFile[])files[i].listFiles(), newDir);
                        continue;
                    }
                    String toDir = dir.getAbsolutePath();
                    try {
                        int mode = 0;
                        ChaseFile cf = files[i].getChaseFile();
                        boolean ignoreCase = System.getProperty("os.name").startsWith("windows") || System.getProperty("os.name").startsWith("mac");
                        boolean dup = Sftp.this.checkDupli(new File(downfile).getName(), dir, ignoreCase);
                        logger.debug("duplicate files: " + dup);
                        boolean rename = false;
                        boolean rename_local = false;
                        String tmpfile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + new File(downfile).getName();
                        if (cf != null) {
                            if (dup && cf.getDuplicateFile().equals(ChaseFile.DO_NOTHING)) continue;
                            if (dup && (cf.getDuplicateFile().equals(ChaseFile.RENAME) || cf.getDuplicateFile().equals(ChaseFile.RENAME_LOCAL))) {
                                rename = true;
                                try {
                                    String ff = toDir + System.getProperty("file.separator") + new File(downfile).getName();
                                    if (new File(ff).exists()) {
                                        ExternalProgramExecuter.copyBinary(ff, tmpfile);
                                    }
                                }
                                catch (IOException ioe) {
                                    logger.error("failed pre-rename manipulation");
                                    ioe.printStackTrace();
                                    rename = false;
                                }
                            }
                            if (cf.getDuplicateFile().equals(ChaseFile.APPEND)) {
                                mode = 2;
                            }
                        }
                        logger.info("downloading file: " + downfile + " to " + dir.getAbsolutePath());
                        SilentMyProgressMonitor monitor = new SilentMyProgressMonitor("downloading " + new File(downfile).getName());
                        this.c.get(downfile, toDir, monitor, mode);
                        if (rename) {
                            String newName = Sftp.this.getUniqueFileName(new File(downfile).getName(), dir, ignoreCase);
                            try {
                                String fromName = toDir + System.getProperty("file.separator") + new File(downfile).getName();
                                String toName = toDir + System.getProperty("file.separator") + newName;
                                logger.debug("fromName, toName: " + fromName + ", " + toName);
                                if (cf.getDuplicateFile().equals(ChaseFile.RENAME)) {
                                    ExternalProgramExecuter.copyBinary(toDir + System.getProperty("file.separator") + new File(downfile).getName(), toDir + System.getProperty("file.separator") + newName);
                                    ExternalProgramExecuter.copyBinary(tmpfile, toDir + System.getProperty("file.separator") + new File(downfile).getName());
                                } else if (cf.getDuplicateFile().equals(ChaseFile.RENAME_LOCAL)) {
                                    ExternalProgramExecuter.copyBinary(tmpfile, toDir + System.getProperty("file.separator") + newName);
                                }
                            }
                            catch (IOException ioe) {
                                logger.error("failed post-rename manipulation.");
                                ioe.printStackTrace();
                            }
                        }
                        logger.info("... done");
                        continue;
                    }
                    catch (SftpException e) {
                        logger.error("failed to download: " + downfile);
                        e.printStackTrace();
                    }
                }
            }
            if (this.listeners != null) {
                for (i = 0; i < this.listeners.size(); ++i) {
                    ((SftpListener)this.listeners.elementAt(i)).downloadFinished(new SftpEvent(this));
                }
            }
        }
    }

    class Upload
    implements Runnable {
        private RemoteFile[] files;
        private RemoteFile dir;
        private String localDir;
        private ChannelSftp c;
        private Vector listeners;

        protected Upload(RemoteFile[] files, RemoteFile dir, String localDir, ChannelSftp c2, Vector listeners) {
            this.files = files;
            this.dir = dir;
            this.localDir = localDir;
            this.c = c2;
            this.listeners = listeners;
        }

        public void run() {
            this.upload(this.files, this.dir);
        }

        public void upload() {
            this.upload(this.files, this.dir);
        }

        private void upload(RemoteFile[] files, RemoteFile dir) {
            int i;
            if (files != null && dir != null) {
                for (i = 0; i < files.length; ++i) {
                    String upfile;
                    String tmpfile = upfile = files[i].getAbsolutePath();
                    if (files[i].isDirectory()) {
                        if (files[i].getName().trim().equals(".") || files[i].getName().trim().equals("..")) continue;
                        String dirdir = dir.getAbsolutePath();
                        RemoteFile newDir = new RemoteFile(dirdir, files[i].getName() + "/", this.c);
                        newDir.mkdir();
                        logger.debug("created newdir: " + newDir);
                        this.upload((RemoteFile[])files[i].listFiles(), newDir);
                        continue;
                    }
                    String toDir = dir.getAbsolutePath();
                    if (this.localDir != null) {
                        String tmpLocalDir = this.localDir.replaceAll("\\\\", "/").trim();
                        String tmpTargetFile = upfile.replaceAll("\\\\", "/").trim();
                        String[] tmparray = tmpTargetFile.split(tmpLocalDir);
                        logger.debug("tmpLocalDir, tmpTargetFile: " + tmpLocalDir + ", " + tmpTargetFile);
                        if (tmparray == null || tmparray.length == 0) continue;
                        String tmpTargetRelative = tmpTargetFile.substring(tmpLocalDir.length(), tmpTargetFile.length());
                        if (!tmpTargetRelative.startsWith("./")) {
                            tmpTargetRelative = "./" + tmpTargetRelative;
                        }
                        logger.debug("tmpTargetRelative: " + tmpTargetRelative);
                        toDir = toDir + new File(tmpTargetRelative).getParent().replaceAll("\\\\", "/");
                        logger.debug("toDir: " + toDir);
                    }
                    try {
                        RemoteFile tmpToDir = new RemoteFile(toDir, this.c);
                        RemoteFile test2 = new RemoteFile(toDir + "/" + new File(upfile).getName(), this.c);
                        logger.debug("does file " + test2.getAbsolutePath() + " exist? " + test2.exists());
                        ChaseFile cf = files[i].getChaseFile();
                        int mode = 0;
                        boolean ignoreCase = false;
                        boolean rename = false;
                        boolean dup = Sftp.this.checkDupli(new File(upfile).getName(), tmpToDir, ignoreCase);
                        if (cf != null && cf.getDuplicateFile().equals(ChaseFile.DO_NOTHING) && dup) continue;
                        if (cf != null && cf.getDuplicateFile().equals(ChaseFile.APPEND)) {
                            mode = 2;
                        } else if (cf != null && cf.getDuplicateFile().equals(ChaseFile.RENAME) && dup) {
                            rename = true;
                            mode = 0;
                        }
                        String tmp = "~~~____";
                        if (rename && dup) {
                            tmpfile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + new File(upfile).getName() + tmp;
                            try {
                                ExternalProgramExecuter.copy(upfile, tmpfile);
                            }
                            catch (IOException ioe) {
                                logger.error("failed pre-renme operation");
                                rename = false;
                            }
                        }
                        tmpToDir.mkdirs();
                        logger.info("uploading file: " + upfile + " to " + tmpToDir.getAbsolutePath());
                        SilentMyProgressMonitor monitor = new SilentMyProgressMonitor("uploading " + new File(upfile).getName());
                        this.c.put(tmpfile, toDir, (SftpProgressMonitor)monitor, mode);
                        if (rename && dup) {
                            new File(tmpfile).delete();
                            String newName = Sftp.this.getUniqueFileName(new File(upfile).getName(), tmpToDir, ignoreCase);
                            if (!toDir.endsWith("/")) {
                                toDir = toDir + "/";
                            }
                            logger.debug("toDir: " + toDir);
                            logger.debug("renaming " + new File(tmpfile).getName() + " to " + newName);
                            try {
                                this.c.rename(toDir + new File(tmpfile).getName(), toDir + newName);
                            }
                            catch (SftpException sexc) {
                                logger.error("failed post-rename operation.");
                                try {
                                    this.c.rm(toDir + new File(tmpfile).getName());
                                }
                                catch (Exception exc) {
                                    new File(tmpfile).delete();
                                }
                                sexc.printStackTrace();
                            }
                        }
                        logger.info("... done");
                        continue;
                    }
                    catch (SftpException e) {
                        logger.error("failed to upload: " + upfile);
                        e.printStackTrace();
                    }
                }
            }
            if (this.listeners != null) {
                for (i = 0; i < this.listeners.size(); ++i) {
                    ((SftpListener)this.listeners.elementAt(i)).uploadFinished(new SftpEvent(this));
                }
            }
        }
    }
}

