/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting.scripteditor;

import ciss.phase_viewer.common.Resources;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.scripting.ScriptDescriptionPanel;
import ciss.phase_viewer.scripting.ScriptUtils;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditor;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorCaller;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class ScriptEditorGUI
extends InternalFrameChase {
    private Logger logger = Logger.getLogger(ScriptEditor.class.getName());
    private ScriptEditorCaller parentFrame;
    private String script;
    private InputInterface inputInterface;
    private ScriptDescriptionPanel descriptionPanel;
    private JTabbedPane tabbedPane;
    private ScriptEditorPanel editorPanel;

    public ScriptEditorGUI(ScriptEditorCaller parentFrame) {
        super(new File(parentFrame.getScriptPath()).getName(), true, true, true, true, new Dimension(550, 550));
        this.script = parentFrame.getScriptPath();
        this.parentFrame = parentFrame;
        this.init();
    }

    private void init() {
        this.inputInterface = ScriptUtils.getInputInterfaceFrom(this.script);
        if (this.inputInterface == null) {
            return;
        }
        this.createGUI();
        this.revalidate();
    }

    private void createGUI() {
        Container container = this.getContentPane();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        container.setLayout(new BoxLayout(container, 1));
        container.add(this.createButtons());
        this.editorPanel = new ScriptEditorPanel(this.parentFrame);
        container.add(this.editorPanel);
    }

    private JPanel createButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel panelsub = new JPanel();
        panelsub.setLayout(new BoxLayout(panelsub, 0));
        JButton save = new JButton(Resources.getIcon("/toolbarButtonGraphics/general/Save16.gif"));
        save.setToolTipText("save to " + this.inputInterface.getFileName());
        JButton close = new JButton(Resources.getIcon("/org/javalobby/icons/16x16/Exit.gif"));
        close.setToolTipText("close");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScriptEditorGUI.this.editorPanel.save();
            }
        });
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScriptEditorGUI.this.dispose();
            }
        });
        panelsub.add(save);
        panelsub.add(close);
        panel.add((Component)panelsub, "West");
        return panel;
    }
}

