/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser.projectdirbrowser;

import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ProjectDirBrowserMenu {
    private Logger logger = Logger.getLogger(ProjectDirBrowserMenu.class.getName());
    private ProjectDirBrowser browser;
    private ProjectDirBrowserNode node;
    private ProjectInfo info;
    private Vector projbuf;

    public ProjectDirBrowserMenu(ProjectDirBrowser browser) {
        this.browser = browser;
        this.node = browser.getSelectedNode();
        if (this.node == null) {
            return;
        }
        this.info = this.node.getProjectInfo();
        this.projbuf = browser.getProjBuf();
    }

    public JMenuItem[] getMenuItems() {
        if (this.node == null) {
            return null;
        }
        Vector<JMenuItem> items = new Vector<JMenuItem>();
        JMenuItem open = new JMenuItem("open");
        open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (ProjectDirBrowserMenu.this.node != null) {
                    ProjectDirBrowserMenu.this.node.selectMe();
                    ProjectDirBrowserMenu.this.browser.saveMyProjects();
                }
            }
        });
        open.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        JMenuItem rename = new JMenuItem("rename");
        rename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectDirBrowserMenu.this.browser.bootRenamer(ProjectDirBrowserMenu.this.node);
            }
        });
        rename.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        JMenuItem cut = new JMenuItem("cut");
        cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectDirBrowserMenu.this.browser.doProjectCut(ProjectDirBrowserMenu.this.node);
            }
        });
        cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        JMenuItem copy = new JMenuItem("copy");
        copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectDirBrowserMenu.this.browser.doProjectCopy(ProjectDirBrowserMenu.this.node);
            }
        });
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        JMenuItem paste = new JMenuItem("paste");
        paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectDirBrowserMenu.this.browser.doProjectPaste();
            }
        });
        paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        paste.setEnabled(this.projbuf.size() != 0);
        JMenuItem remove = new JMenuItem("remove");
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectDirBrowserMenu.this.browser.bootProjectRemover();
            }
        });
        remove.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        JMenuItem create = new JMenuItem("create project");
        create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectDirBrowserMenu.this.browser.bootProjectCreator();
            }
        });
        create.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        JMenuItem sub = new JMenuItem("create sub project");
        sub.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectDirBrowserMenu.this.browser.bootSubProjectCreator();
            }
        });
        sub.setAccelerator(KeyStroke.getKeyStroke(78, 3));
        JMenuItem export = new JMenuItem("export project");
        export.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ProjectDirBrowserMenu.this.browser.doProjectExport();
            }
        });
        JMenuItem impor = new JMenuItem("import project");
        impor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ProjectDirBrowserMenu.this.browser.doProjectImport();
            }
        });
        JMenuItem openexp = null;
        Object cmd = null;
        if (this.info.getInfoType() == 2) {
            items.addElement(open);
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            openexp = new JMenuItem("open folder by explorer");
            items.addElement(openexp);
        } else if (System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            openexp = new JMenuItem("open directory by konqueror");
            items.addElement(openexp);
        }
        if (openexp != null) {
            openexp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectDirBrowserMenu.this.browser.openDir(ProjectDirBrowserMenu.this.info.getProjectDirectory());
                }
            });
            openexp.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        }
        JMenuItem openprompt = new JMenuItem("open terminal");
        openprompt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectDirBrowserMenu.this.browser.openDirByPrompt(ProjectDirBrowserMenu.this.info.getProjectDirectory());
            }
        });
        openprompt.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        items.addElement(openprompt);
        items.addElement(null);
        if (this.info.getInfoType() == 2 && openexp == null) {
            items.addElement(null);
        }
        if (!this.info.isEditable()) {
            Object[] ite = new JMenuItem[items.size()];
            items.copyInto(ite);
            return ite;
        }
        if (this.info.getProjectType().equals("root")) {
            items.addElement(create);
            items.addElement(null);
            items.addElement(export);
            items.addElement(impor);
        } else if (this.info.getInfoType() == 1 && !this.info.getProjectType().equals("root")) {
            items.addElement(create);
            items.addElement(sub);
            items.addElement(null);
            items.addElement(rename);
            items.addElement(cut);
            items.addElement(copy);
            items.addElement(paste);
            items.addElement(remove);
            items.addElement(null);
            items.addElement(export);
            items.addElement(impor);
        } else if (this.info.getInfoType() == 2) {
            items.addElement(sub);
            items.addElement(null);
            items.addElement(rename);
            items.addElement(cut);
            items.addElement(copy);
            items.addElement(paste);
            items.addElement(remove);
        }
        if (items.size() != 0) {
            JMenuItem[] jitems = new JMenuItem[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                jitems[i] = (JMenuItem)items.elementAt(i);
            }
            return jitems;
        }
        return null;
    }
}

