/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser.projectdirbrowser;

import ciss.phase_viewer.common.MyThread;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.main.Main;
import ciss.phase_viewer.mainpanel.ChaseGUI;
import ciss.phase_viewer.mainpanel.ChaseProgressMonitor;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.projectbrowser.ProjectBrowser;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserMenu;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeEvent;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeListener;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserRenderer;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserTree;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.NewProjectCreator;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.NewSubProjectCreator;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectRemover;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectState;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChangeEvent;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChangeListener;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

public class ProjectDirBrowser
extends JPanel
implements ProjectDirBrowserNodeChangeListener,
ProjectStateChangeListener,
Serializable {
    private Logger logger = Logger.getLogger(ProjectDirBrowser.class.getName());
    private JSplitPane splitpane;
    public static String MY_PROJECTS = System.getProperty("user.home") + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "my_projects.xml";
    private ProjectDirBrowserTree tree;
    private DefaultTreeModel treeModel;
    private ProjectDirBrowserNode rootNode;
    private ProjectBrowser parent;
    private static Document doc;
    private boolean reuse = false;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
    private Vector nodelisteners = new Vector();
    private ProjectDirBrowser browser;
    private boolean monitor = false;
    private Vector projbuf = new Vector();
    private int currentsubproject = 0;
    private int numproj = 0;

    public ProjectDirBrowser(String title) {
        this.setBorder(new TitledBorder(title));
        this.setLayout(new BoxLayout(this, 1));
        this.browser = this;
        this.reuse = new Boolean(this.gp.getProperty("project_browser_reuse_window"));
        this.nodelisteners.addElement(this);
        this.init();
    }

    public ProjectDirBrowser(String title, boolean monitor) {
        this.monitor = monitor;
        this.setBorder(new TitledBorder(title));
        this.setLayout(new BoxLayout(this, 1));
        this.browser = this;
        this.reuse = new Boolean(this.gp.getProperty("project_browser_reuse_window"));
        this.nodelisteners.addElement(this);
        this.init();
    }

    public ProjectDirBrowser(String title, ProjectDirBrowserNodeChangeListener[] listener) {
        this.setBorder(new TitledBorder(title));
        this.setLayout(new BoxLayout(this, 1));
        this.reuse = new Boolean(this.gp.getProperty("project_browser_reuse_window"));
        if (listener != null) {
            for (int i = 0; i < listener.length; ++i) {
                this.nodelisteners.addElement(listener[i]);
            }
        }
        this.init();
    }

    public void setProjectBrowser(ProjectBrowser parent) {
        this.parent = parent;
    }

    public void loadSample() {
        File sampleSpec = new File(System.getProperty("pviewer.home") + System.getProperty("file.separator") + "samples" + System.getProperty("file.separator") + "gui_samples" + System.getProperty("file.separator") + "spec.xml");
        int numdir = Utils.getTotalNumDir(new File(System.getProperty("pviewer.home") + System.getProperty("file.separator") + "samples" + System.getProperty("file.separator") + "gui_samples"));
        this.logger.debug("number of directories: " + numdir);
        ProgressBar ba = new ProgressBar(numdir, this.getRootNode());
        String versionno = Main.getDefaultPropertiesDocument().getRootElement().getChildTextTrim("version");
        if (sampleSpec.exists()) {
            this.importSub(sampleSpec, this.getRootNode(), "_ver" + versionno);
        }
        ba.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nodeSelected(ProjectDirBrowserNodeChangeEvent e) {
        ProjectManipulator component;
        ProjectInfo proj;
        ProjectDirBrowserNode node;
        block9: {
            if (e == null) return;
            if (e.getSource() == null) {
                return;
            }
            node = (ProjectDirBrowserNode)e.getSource();
            proj = node.getProjectInfo();
            component = null;
            if (proj != null && (component = ProjectManipulator.createProjectManipulator(proj)) == null) {
                return;
            }
            if (!this.reuse) {
                if (node.getProjectBrowser() == null || !node.getProjectBrowser().isVisible()) {
                    Dimension dim = proj.getInitialBrowserSize();
                    this.parent = new ProjectBrowser(dim, proj);
                    break block9;
                } else {
                    if (node.getProjectBrowser().isSelected()) return;
                    try {
                        node.getProjectBrowser().setSelected(true);
                        return;
                    }
                    catch (PropertyVetoException vpe) {
                        // empty catch block
                    }
                    return;
                }
            }
            if (this.parent == null || !this.parent.isVisible()) {
                Dimension dim = proj.getInitialBrowserSize();
                this.parent = new ProjectBrowser(dim, proj);
            }
            this.parent.setTitle(proj.getProjectName());
        }
        if (component != null) {
            component.init();
            this.parent.setProjectManipulator(component);
            this.parent.registerProjectManipulators(component);
        }
        proj.setParent(this.parent);
        node.setProjectBrowser(this.parent);
        this.parent.setAssociatedNode(node);
        this.parent.revalidate();
    }

    public void projectStateChanged(ProjectStateChangeEvent e) {
        this.updateTree();
        String selectMe = e.select();
        if (selectMe != null && selectMe.length() != 0 && this.tree.getSelectionRows() != null) {
            TreePath path = this.tree.getNextMatch(selectMe, this.tree.getSelectionRows()[0], Position.Bias.Forward);
            this.tree.setSelectionPath(path);
            this.logger.debug("new proj path: " + path);
        }
    }

    public void recreate() {
        int[] rows = this.tree.getSelectionRows();
        int row = -1;
        if (rows != null && rows.length > 0) {
            row = rows[0];
        }
        boolean bool = false;
        if (row >= 0) {
            bool = this.tree.isExpanded(row);
        }
        this.removeAll();
        this.init();
        if (row >= 0) {
            this.tree.setSelectionRow(row);
            if (bool) {
                this.tree.expandRow(row);
            }
        }
        this.revalidate();
    }

    public void updateTree() {
        this.tree.revalidate();
        this.tree.repaint();
    }

    public void updateTree(ProjectDirBrowserNode node) {
        ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
    }

    public ProjectInfo getSelectedProject() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            this.logger.warn("no project selected.");
            return null;
        }
        Object o2 = path.getLastPathComponent();
        ProjectInfo ret = null;
        if (o2 instanceof ProjectDirBrowserNode) {
            ret = ((ProjectDirBrowserNode)o2).getProjectInfo();
        }
        return ret;
    }

    public ProjectInfo getRootProject() {
        TreePath path = this.tree.getPathForRow(0);
        Object o2 = path.getPathComponent(0);
        ProjectInfo ret = null;
        if (o2 instanceof ProjectDirBrowserNode) {
            ret = ((ProjectDirBrowserNode)o2).getProjectInfo();
        }
        return ret;
    }

    public ProjectDirBrowserNode getRootNode() {
        return this.rootNode;
    }

    public ProjectDirBrowserNode getSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object o2 = path.getLastPathComponent();
        ProjectDirBrowserNode ret = null;
        if (o2 instanceof ProjectDirBrowserNode) {
            ret = (ProjectDirBrowserNode)o2;
        }
        return ret;
    }

    public JTree getTree() {
        return this.tree;
    }

    public static TreePath getPath(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    public static Document getMyProjectsDocument() {
        if (doc == null) {
            doc = ProjectBrowser.getDocument(new File(MY_PROJECTS));
        }
        return doc;
    }

    public static void saveMyProjectsDocument() {
        XMLUtils.saveDocumentTo(doc, MY_PROJECTS);
    }

    private void defineAccelerators() {
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(88, 128), "CUT");
        this.tree.getActionMap().put("CUT", new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProjectDirBrowser.this.doProjectCut(ProjectDirBrowser.this.getSelectedNode());
            }
        });
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(67, 128), "COPY");
        this.tree.getActionMap().put("COPY", new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProjectDirBrowser.this.doProjectCopy(ProjectDirBrowser.this.getSelectedNode());
            }
        });
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(86, 128), "PASTE");
        this.tree.getActionMap().put("PASTE", new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProjectDirBrowser.this.doProjectPaste();
            }
        });
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(113, 0), "RENAME");
        this.tree.getActionMap().put("RENAME", new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProjectDirBrowser.this.bootRenamer(ProjectDirBrowser.this.getSelectedNode());
            }
        });
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ACTIVATE");
        this.tree.getActionMap().put("ACTIVATE", new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProjectDirBrowserNode node = ProjectDirBrowser.this.getSelectedNode();
                if (node != null) {
                    node.selectMe();
                    ProjectDirBrowser.this.saveMyProjects();
                }
            }
        });
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(78, 2), "NEWPROJ");
        this.tree.getActionMap().put("NEWPROJ", new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProjectDirBrowser.this.bootProjectCreator();
            }
        });
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(78, 3), "NEWSUBPROJ");
        this.tree.getActionMap().put("NEWSUBPROJ", new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProjectDirBrowser.this.bootSubProjectCreator();
            }
        });
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "REMOVE");
        this.tree.getActionMap().put("REMOVE", new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProjectDirBrowser.this.bootProjectRemover();
            }
        });
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows") || os.startsWith("linux")) {
            this.tree.getInputMap().put(KeyStroke.getKeyStroke(79, 2), "OPENDIR");
            this.tree.getActionMap().put("OPENDIR", new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    ProjectDirBrowserNode node = ProjectDirBrowser.this.getSelectedNode();
                    if (node != null) {
                        ProjectDirBrowser.this.openDir(node.getProjectInfo().getProjectDirectory());
                    }
                }
            });
        }
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(84, 2), "OPENDIR_BY_PROMPT");
        this.tree.getActionMap().put("OPENDIR_BY_PROMPT", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ProjectDirBrowserNode node = ProjectDirBrowser.this.getSelectedNode();
                if (node != null) {
                    ProjectDirBrowser.this.openDirByPrompt(node.getProjectInfo().getProjectDirectory());
                }
            }
        });
    }

    private void init() {
        doc = ProjectDirBrowser.getMyProjectsDocument();
        Element root = doc.getRootElement();
        if (this.monitor) {
            this.calculateNumProjects(root);
            new Thread(new Monitor()).start();
            this.logger.debug("number of 'subprojects': " + this.numproj);
        }
        this.rootNode = new ProjectDirBrowserNode(root, this, this.monitor);
        for (int i = 0; i < this.nodelisteners.size(); ++i) {
            this.rootNode.addProjectDirBrowserNodeChangeListener((ProjectDirBrowserNodeChangeListener)this.nodelisteners.get(i));
        }
        this.logger.debug(this.rootNode);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(new MyTreeModelListener());
        this.tree = new ProjectDirBrowserTree();
        this.tree.setModel(this.treeModel);
        this.tree.addMouseListener(new MouseAdapterProjectDirBrowser());
        ProjectDirBrowserRenderer renderer = new ProjectDirBrowserRenderer();
        this.tree.setCellRenderer(renderer);
        this.tree.setShowsRootHandles(true);
        JScrollPane scrpane = new JScrollPane(this.tree);
        this.addToTree(root, this.rootNode);
        TreePath path = this.tree.getPathForRow(0);
        this.tree.expandPath(path);
        this.setExpanded(this.rootNode);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(scrpane);
        this.defineAccelerators();
        super.add(p);
    }

    private void setExpanded(ProjectDirBrowserNode node) {
        int numChild = node.getChildCount();
        for (int i = 0; i < numChild; ++i) {
            ProjectDirBrowserNode cnode = (ProjectDirBrowserNode)node.getChildAt(i);
            if (cnode.isExpanded()) {
                this.logger.debug("node is expanded...");
                this.tree.scrollPathToVisible(new TreePath(cnode.getPath()));
            }
            if (cnode.isSelected()) {
                this.logger.debug("node is selected...");
                this.tree.setSelectionPath(new TreePath(cnode.getPath()));
                cnode.selectMe();
            }
            this.setExpanded(cnode);
        }
    }

    public void requestFocus() {
        this.tree.requestFocus();
    }

    public void addToTree(Element element, ProjectDirBrowserNode node) {
        String hasSub = element.getAttributeValue("hassub");
        ++this.currentsubproject;
        boolean bhasSub = false;
        if (hasSub != null) {
            bhasSub = new Boolean(hasSub);
        }
        List list = element.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            this.logger.debug("processing nodes for element: " + list.get(i));
            Element tmpelement = (Element)list.get(i);
            String disp = tmpelement.getAttributeValue("display");
            boolean bdisp = false;
            if (disp != null) {
                bdisp = new Boolean(disp);
            }
            if (!bdisp) continue;
            ProjectDirBrowserNode tmpnode = new ProjectDirBrowserNode(tmpelement, this, this.monitor);
            if (!new File(tmpnode.getProjectInfo().getProjectDirectory()).exists()) {
                tmpelement.detach();
                continue;
            }
            for (int j2 = 0; j2 < this.nodelisteners.size(); ++j2) {
                tmpnode.addProjectDirBrowserNodeChangeListener((ProjectDirBrowserNodeChangeListener)this.nodelisteners.get(j2));
            }
            this.addToTree(tmpelement, tmpnode);
            node.add(tmpnode);
        }
    }

    public void removeCurrentNode() {
        ProjectDirBrowserNode currentNode;
        ProjectDirBrowserNode parent;
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null && (parent = (ProjectDirBrowserNode)(currentNode = (ProjectDirBrowserNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(currentNode);
            currentNode.getProjectElement().getParentElement().removeContent(currentNode.getProjectElement());
            return;
        }
    }

    public ProjectDirBrowserNode addObject(Object child) {
        ProjectDirBrowserNode parentNode = null;
        TreePath parentPath = this.tree.getSelectionPath();
        parentNode = parentPath == null ? this.rootNode : (ProjectDirBrowserNode)parentPath.getLastPathComponent();
        return this.addObject(parentNode, child, true, true);
    }

    public ProjectDirBrowserNode addObject(ProjectDirBrowserNode parent, Object child) {
        return this.addObject(parent, child, false, true);
    }

    public ProjectDirBrowserNode addObject(ProjectDirBrowserNode parent, Object child, boolean shouldBeVisible, boolean updateMyProjects) {
        ProjectDirBrowserNode childNode = null;
        Element proj = parent.getProjectElement();
        ProjectInfo info = parent.getProjectInfo();
        if (child instanceof ProjectDirBrowserNode) {
            childNode = (ProjectDirBrowserNode)child;
        }
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (updateMyProjects) {
            try {
                proj.addContent(childNode.getProjectElement());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        info.addSubProjectInfo(childNode.getProjectInfo());
        if (shouldBeVisible) {
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    public ProjectDirBrowserNode addObject(ProjectDirBrowserNode parent, Object child, boolean shouldBeVisible) {
        return this.addObject(parent, child, shouldBeVisible, true);
    }

    public void bootProjectCreator() {
        ProjectDirBrowserNode nd = this.getSelectedNode();
        if (nd == null) {
            nd = this.getRootNode();
        }
        if (nd.getProjectInfo().getInfoType() == 2) {
            this.logger.info("projects can't be created under subprojects");
            return;
        }
        if (!nd.getProjectInfo().isEditable()) {
            this.logger.info("projects can't be created under this node");
            return;
        }
        NewProjectCreator cr = new NewProjectCreator(nd, this);
        cr.addProjectStateChangeListener(this);
    }

    public void bootProjectRemover() {
        ProjectDirBrowserNode nd = this.getSelectedNode();
        if (nd == null) {
            this.logger.info("project dir not selected.");
            return;
        }
        if (nd == this.getRootNode()) {
            this.logger.info("root node can't be removed.");
            return;
        }
        if (!nd.getProjectInfo().isEditable()) {
            this.logger.info("can't remove this project.");
            return;
        }
        ProjectRemover rm = new ProjectRemover("remove", nd, this);
        rm.addProjectStateChangeListener(this);
    }

    public void bootSubProjectRemover() {
        ProjectDirBrowserNode nd = this.getSelectedNode();
        if (nd == null) {
            this.logger.info("project dir not selected.");
            return;
        }
        if (nd == this.getRootNode()) {
            this.logger.info("root node can't be removed.");
            return;
        }
        if (!nd.getProjectInfo().isEditable()) {
            this.logger.info("can't remove this project.");
            return;
        }
        if (nd.getProjectInfo().getInfoType() == 1) {
            this.logger.info("use `remove project' to remove projects.");
            return;
        }
        ProjectRemover rm = new ProjectRemover("remove sub project", nd, this);
        rm.addProjectStateChangeListener(this);
    }

    public void bootSubProjectCreator() {
        ProjectDirBrowserNode nd = this.getSelectedNode();
        if (nd == null) {
            this.logger.error("project not selected.");
            return;
        }
        if (nd == this.getRootNode()) {
            this.logger.info("sub projects can't be created under root node.");
            return;
        }
        if (!nd.getProjectInfo().isEditable()) {
            this.logger.info("sub projects can't be created under this node");
            return;
        }
        NewSubProjectCreator cr = new NewSubProjectCreator(nd, this);
        cr.addProjectStateChangeListener(this);
    }

    protected Vector getProjBuf() {
        return this.projbuf;
    }

    public void doProjectCopy(ProjectDirBrowserNode currNode) {
        if (!currNode.getProjectInfo().isEditable()) {
            this.logger.info("uneditable node.");
            return;
        }
        ProjectState state = new ProjectState(currNode, (ProjectDirBrowserNode)currNode.getParent(), ProjectState.PROJECT_COPY);
        this.projbuf.addElement(state);
    }

    public void doProjectCut(ProjectDirBrowserNode currNode) {
        if (!currNode.getProjectInfo().isEditable()) {
            this.logger.info("uneditable node.");
            return;
        }
        ProjectState state = new ProjectState(currNode, (ProjectDirBrowserNode)currNode.getParent(), ProjectState.PROJECT_CUT);
        this.projbuf.addElement(state);
        ProjectBrowser browser = currNode.getProjectBrowser();
        if (browser != null) {
            browser.dispose();
        }
        ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(currNode);
        this.updateTree();
    }

    public void doProjectPaste() {
        if (this.projbuf.size() == 0) {
            this.logger.info("no data in buffer.");
            return;
        }
        ProjectState state = (ProjectState)this.projbuf.remove(this.projbuf.size() - 1);
        ProjectDirBrowserNode nd = this.getSelectedNode();
        if (nd == null) {
            this.logger.info("node not selected.");
            this.projbuf.add(state);
            return;
        }
        ProjectInfo selected = nd.getProjectInfo();
        if (selected == null) {
            this.logger.error("projectinfo not registered.");
            this.projbuf.add(state);
            return;
        }
        if (!selected.isEditable()) {
            this.logger.info("projects/subprojects can't be added under this node.");
            return;
        }
        if (!state.getNode().getProjectInfo().isEditable()) {
            return;
        }
        if (state.getNode().getProjectInfo().getInfoType() == 1 && selected.getInfoType() == 2) {
            this.projbuf.add(state);
            this.logger.info("projects can't be added under subprojects.");
            return;
        }
        if (state.getNode().getProjectInfo().getInfoType() == 2 && selected.isRoot()) {
            this.projbuf.add(state);
            this.logger.info("subprojects can't be added under root.");
            return;
        }
        if (!ProjectBrowserUtils.changeProjectState(this, state)) {
            this.projbuf.add(state);
        }
    }

    public void bootRenamer(ProjectDirBrowserNode currNode) {
        String oldName = currNode.getProjectInfo().getProjectName();
        String newName = JOptionPane.showInternalInputDialog(Desk.getDesktop(), "input new name", "rename", -1);
        if (newName == null || newName.trim().length() == 0) {
            this.logger.info("rename canceled.");
            return;
        }
        ProjectInfo info = currNode.getProjectInfo();
        info.setProjectName(newName);
        info.setProjectDirectory(new File(info.getProjectDirectory()).getParent() + System.getProperty("file.separator") + newName);
        ProjectBrowserUtils.changeProjectState(this, new ProjectState(currNode, (ProjectDirBrowserNode)currNode.getParent(), ProjectState.PROJECT_RENAME));
    }

    public void saveMyProjects() {
        this.setShouldBeVisible(this.getRootNode());
        XMLUtils.saveDocumentTo(doc, MY_PROJECTS);
    }

    private void setShouldBeVisible(TreeNode node) {
        TreePath path = new TreePath(((DefaultMutableTreeNode)node).getPath());
        JTree tree = this.getTree();
        if (node instanceof ProjectDirBrowserNode) {
            Element elem = ((ProjectDirBrowserNode)node).getProjectElement();
            String shouldbevisible = "false";
            if (tree.isExpanded(path)) {
                shouldbevisible = "true";
            }
            elem.setAttribute(new Attribute("shouldbevisible", shouldbevisible));
            String selected = "false";
            if (tree.isPathSelected(path)) {
                selected = "true";
            }
            elem.setAttribute(new Attribute("selected", selected));
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setShouldBeVisible(node.getChildAt(i));
        }
    }

    private void calculateNumProjects(Element element) {
        List subprojects = element.getChildren("subproject");
        this.numproj += subprojects.size();
        List projects = element.getChildren("project");
        if (projects == null || projects.size() == 0) {
            return;
        }
        this.numproj += projects.size();
        for (int i = 0; i < projects.size(); ++i) {
            this.calculateNumProjects((Element)projects.get(i));
        }
    }

    protected void doProjectExport() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(1);
        if (chooser.showDialog(this, "open") != 0) {
            return;
        }
        String exportDir = chooser.getSelectedFile().getAbsolutePath();
        ProjectDirBrowserNode currNode = this.getSelectedNode();
        ProjectInfo currInfo = currNode.getProjectInfo();
        if (!Utils.copyDir(new File(currInfo.getProjectDirectory()), new File(exportDir))) {
            this.logger.error("error.");
            return;
        }
        Document document = new Document();
        Element root = new Element("projects");
        document.setRootElement(root);
        root.addContent((Element)currInfo.getProjectElement().clone());
        XMLUtils.saveDocumentTo(document, exportDir + System.getProperty("file.separator") + "spec.xml");
    }

    private void importFromDir(File dir, ProjectDirBrowserNode currNode) {
        List list = ProjectBrowserUtils.getElementFromDir(dir);
        Document document = ProjectDirBrowser.getMyProjectsDocument();
        Element rootElement = document.getRootElement();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element ele = (Element)list.get(i);
                rootElement.addContent(ele);
            }
        }
        ProjectDirBrowser.saveMyProjectsDocument();
    }

    protected void doProjectImport() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(2);
        ImportFileFilterXML ff1 = new ImportFileFilterXML();
        ImportFileFilterV1 ff2 = new ImportFileFilterV1();
        ImportFileFilterGenericFolder ff3 = new ImportFileFilterGenericFolder();
        chooser.addChoosableFileFilter(ff1);
        chooser.addChoosableFileFilter(ff2);
        chooser.setFileFilter(ff1);
        if (chooser.showDialog(this, "open") != 0) {
            return;
        }
        File specFile = chooser.getSelectedFile().getAbsoluteFile();
        ProjectDirBrowserNode currNode = this.getSelectedNode();
        javax.swing.filechooser.FileFilter ffilter = chooser.getFileFilter();
        if (ffilter instanceof ImportFileFilterXML) {
            if (!specFile.isDirectory()) {
                this.importSub(specFile, currNode);
            } else {
                this.importFromDir(specFile, currNode);
            }
        } else if (ffilter instanceof ImportFileFilterV1) {
            if (specFile.isDirectory()) {
                File foo = this.v1tov2(specFile);
                this.importSub(foo, currNode);
                foo.delete();
            } else {
                this.logger.error("you must specify a directory to import chase v1 projects.");
            }
        } else if (ffilter instanceof ImportFileFilterGenericFolder) {
            // empty if block
        }
    }

    private File v1tov2(File rootDirs) {
        File[] directories = rootDirs.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (directories == null || directories.length == 0) {
            return null;
        }
        Document document = new Document();
        Element projects = new Element("projects");
        document.setRootElement(projects);
        Element rootProj = new Element("project");
        rootProj.setAttribute(new Attribute("display", "true"));
        rootProj.setAttribute("subident", "subproject");
        rootProj.setAttribute("hassub", "true");
        rootProj.setAttribute("shouldbevisible", "false");
        rootProj.setAttribute("selected", "false");
        rootProj.addContent(new Element("name").setText(MyElement.encode(rootDirs.getName())));
        rootProj.addContent(new Element("directory").setText(MyElement.encode(rootDirs.getAbsolutePath())));
        rootProj.addContent(new Element("type").setText("chase project"));
        rootProj.addContent(new Element("date").setText(MyElement.encode(new Date(rootDirs.lastModified()).toString())));
        projects.addContent(rootProj);
        for (int i = 0; i < directories.length; ++i) {
            Element proj = this.importFromDirSub(directories[i], true);
            rootProj.addContent(proj);
        }
        File chasexml = new File(rootDirs.getParent() + System.getProperty("file.separator") + "spec.xml");
        XMLUtils.saveDocumentTo(document, chasexml);
        return chasexml;
    }

    private File importFromDir(File rootDirs) {
        File[] directories = rootDirs.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (directories == null || directories.length == 0) {
            return null;
        }
        Document document = new Document();
        Element projects = new Element("projects");
        document.setRootElement(projects);
        Element rootProj = new Element("project");
        rootProj.setAttribute(new Attribute("display", "true"));
        rootProj.setAttribute("subident", "subproject");
        rootProj.setAttribute("hassub", "true");
        rootProj.setAttribute("shouldbevisible", "false");
        rootProj.setAttribute("selected", "false");
        rootProj.addContent(new Element("name").setText(MyElement.encode(rootDirs.getName())));
        rootProj.addContent(new Element("directory").setText(MyElement.encode(rootDirs.getAbsolutePath())));
        rootProj.addContent(new Element("type").setText("chase project"));
        rootProj.addContent(new Element("date").setText(MyElement.encode(new Date(rootDirs.lastModified()).toString())));
        projects.addContent(rootProj);
        for (int i = 0; i < directories.length; ++i) {
            Element proj = this.importFromDirSub(directories[i], false);
            rootProj.addContent(proj);
        }
        File chasexml = new File(rootDirs.getParent() + System.getProperty("file.separator") + "spec.xml");
        XMLUtils.saveDocumentTo(document, chasexml);
        return chasexml;
    }

    private Element importFromDirSub(File directory, boolean v1proj) {
        File[] chasepars = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().equals("chase.par");
            }
        });
        if (v1proj && chasepars == null || chasepars.length == 0) {
            return null;
        }
        Element project = new Element("subproject");
        long lastModified = directory.lastModified();
        String date = new Date(lastModified).toString();
        project.setAttribute(new Attribute("display", "true"));
        project.setAttribute(new Attribute("shouldbevisible", "false"));
        project.setAttribute(new Attribute("selected", "false"));
        project.addContent(new Element("date").setText(MyElement.encode(date)));
        project.addContent(new Element("name").setText(MyElement.encode(directory.getName())));
        project.addContent(new Element("type").setText("phase"));
        project.addContent(new Element("directory").setText(MyElement.encode(directory.getAbsolutePath())));
        File[] subdirs = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (subdirs != null && subdirs.length != 0) {
            for (int ek = 0; ek < subdirs.length; ++ek) {
                File[] chasepars_subdir = subdirs[ek].listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().equals("chase.par");
                    }
                });
                if (chasepars_subdir != null && chasepars_subdir.length != 0) {
                    Element subelem = this.importFromDirSub(subdirs[ek], v1proj);
                    project.addContent(subelem);
                    continue;
                }
                Element ekcal = new Element("subproject");
                ekcal.setAttribute("display", "true");
                ekcal.setAttribute("shouldbevisible", "false");
                ekcal.setAttribute("selected", "false");
                ekcal.addContent(new Element("date").setText(MyElement.encode(new Date(subdirs[ek].lastModified()).toString())));
                ekcal.addContent(new Element("name").setText(subdirs[ek].getName()));
                if (v1proj) {
                    ekcal.addContent(new Element("type").setText("ekcal"));
                } else {
                    ekcal.addContent(new Element("type").setText("ekcal"));
                }
                ekcal.addContent(new Element("directory").setText(MyElement.encode(subdirs[ek].getAbsolutePath())));
                if (v1proj) {
                    Element par = new Element("associated_directory");
                    par.setAttribute("type", "parent");
                    String pardir = Utils.getRelativePath(subdirs[ek].getAbsolutePath(), directory.getAbsolutePath());
                    par.setText(MyElement.encode(pardir));
                    ekcal.addContent(par);
                }
                project.addContent(ekcal);
            }
        }
        return project;
    }

    protected void openDirByPrompt(String path) {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            MyThread th = new MyThread("cmd.exe /c start cmd.exe", "", new File(path));
        } else {
            MyThread myThread = new MyThread("xterm", "", new File(path));
        }
    }

    protected void openDir(String path) {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            MyThread thread = new MyThread("explorer " + Utils.getPathDQ(path));
        } else {
            MyThread myThread = new MyThread("konqueror " + Utils.getPathDQ(path));
        }
    }

    private void importSub(File specFile, ProjectDirBrowserNode currNode) {
        this.importSub(specFile, currNode, null);
    }

    private void importSub(File specFile, ProjectDirBrowserNode currNode, String suffix__) {
        int i;
        Document document;
        if (suffix__ == null) {
            suffix__ = "_";
        }
        if ((document = XMLUtils.getDocumentFromFile(specFile)) == null) {
            this.logger.error("invalid specfile: " + specFile.getAbsolutePath());
            return;
        }
        Element root = document.getRootElement();
        if (root == null) {
            this.logger.error("invalid specfile: " + specFile.getAbsolutePath());
            return;
        }
        List projects = root.getChildren("project");
        if (projects == null || projects.size() == 0) {
            this.logger.error("no projects in " + specFile.getAbsolutePath());
            return;
        }
        File[] files = specFile.getParentFile().listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        Element parentElement = currNode.getProjectElement();
        if (parentElement == null) {
            return;
        }
        this.logger.debug("parent dir: " + currNode.getProjectInfo().getProjectDirectory());
        File baseDir = new File(currNode.getProjectInfo().getProjectDirectory());
        File[] subfiles = baseDir.listFiles();
        for (i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            boolean boo = false;
            for (int j2 = 0; j2 < projects.size(); ++j2) {
                String nam = ((Element)projects.get(j2)).getChild("name").getTextTrim();
                if (!nam.equals(files[i].getName())) continue;
                boo = true;
            }
            String suffix = "";
            for (int j3 = 0; j3 < subfiles.length; ++j3) {
                if (!subfiles[j3].getName().equals(files[i].getName())) continue;
                suffix = suffix__;
            }
            if (!boo) continue;
            boolean aa = true;
            aa = suffix.length() != 0 ? Utils.copyDir(files[i], baseDir, files[i].getName() + suffix) : Utils.copyDir(files[i], baseDir, false);
            if (aa) continue;
            this.logger.warn("failed copy");
        }
        for (i = 0; i < projects.size(); ++i) {
            Element elem = (Element)((Element)projects.get(i)).clone();
            List li = parentElement.getChildren();
            boolean found = false;
            for (int il = 0; il < li.size(); ++il) {
                Element el = (Element)li.get(il);
                String foo = el.getChildTextTrim("name");
                if (foo == null || !foo.equals(elem.getChildTextTrim("name"))) continue;
                found = true;
                break;
            }
            if (found) {
                elem.getChild("name").setText(elem.getChildTextTrim("name") + suffix__);
            }
            parentElement.addContent(elem);
        }
        ProjectDirBrowser.saveMyProjectsDocument();
        this.recreate();
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            try {
                int index = e.getChildIndices()[0];
                node = (DefaultMutableTreeNode)node.getChildAt(index);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    class MouseAdapterProjectDirBrowser
    extends MouseAdapter {
        private Logger logger = Logger.getLogger(MouseAdapterProjectDirBrowser.class.getName());
        private ProjectInfo info;
        private ProjectDirBrowserNode node;

        MouseAdapterProjectDirBrowser() {
        }

        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            JTree tree = (JTree)e.getSource();
            TreePath path = tree.getPathForLocation(x, y);
            if (path != null) {
                this.node = (ProjectDirBrowserNode)path.getLastPathComponent();
                this.info = this.node.getProjectInfo();
                this.processMouseEvent(e);
            }
            ProjectDirBrowser.this.saveMyProjects();
        }

        private void processMouseEvent(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                this.node.selectMe();
            } else if (e.getButton() == 3) {
                this.showMenu(e);
            }
        }

        private void showMenu(MouseEvent e) {
            ProjectDirBrowserMenu menuCreator = new ProjectDirBrowserMenu(ProjectDirBrowser.this.browser);
            JPopupMenu popup = new JPopupMenu();
            JMenuItem[] items = menuCreator.getMenuItems();
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] == null) {
                        if (i == items.length - 1) continue;
                        popup.addSeparator();
                        continue;
                    }
                    popup.add(items[i]);
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class ImportFileFilterGenericFolder
    extends javax.swing.filechooser.FileFilter {
        ImportFileFilterGenericFolder() {
        }

        public boolean accept(File f) {
            return f.isDirectory();
        }

        public String getDescription() {
            return "generic folder (PHASE only)";
        }
    }

    class ImportFileFilterV1
    extends javax.swing.filechooser.FileFilter {
        ImportFileFilterV1() {
        }

        public boolean accept(File f) {
            return f.isDirectory();
        }

        public String getDescription() {
            return "CHASE-3pt version 1 project directory";
        }
    }

    class ImportFileFilterXML
    extends javax.swing.filechooser.FileFilter {
        ImportFileFilterXML() {
        }

        public boolean accept(File f) {
            String name = f.getName().trim().toLowerCase();
            return name.endsWith(".xml") || f.isDirectory();
        }

        public String getDescription() {
            return "project specification file (*.xml, *.XML)";
        }
    }

    class ProgressBar
    extends JFrame {
        private JProgressBar bar;
        private ProjectDirBrowserNode currnode;
        private Timer timer;
        private int currnumdir;

        ProgressBar(int numdir, ProjectDirBrowserNode currnode) {
            super("loading samples...");
            this.currnumdir = 0;
            this.currnode = currnode;
            this.bar = new JProgressBar(0, numdir);
            this.bar.setPreferredSize(new Dimension(300, 20));
            this.bar.setStringPainted(true);
            this.update();
            this.getContentPane().add(this.bar);
            this.pack();
            int scrx = ChaseGUI.getScreenWidth();
            int scry = ChaseGUI.getScreenHeight();
            int centerx = scrx / 2 - this.getSize().width / 2;
            int centery = scry / 2 - this.getSize().height / 2;
            this.setLocation(centerx, centery);
            this.setVisible(true);
            this.timer = new Timer(0, new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ProgressBar.this.update();
                }
            });
            this.timer.start();
        }

        void setCurrDirNum(int currnumdir) {
            this.currnumdir = currnumdir;
        }

        private void update() {
            this.bar.setValue(Utils.getTotalNumDir(new File(this.currnode.getProjectInfo().getProjectDirectory())));
        }

        public void dispose() {
            super.dispose();
            this.timer.stop();
            this.timer = null;
        }
    }

    class Monitor
    implements Runnable,
    ProgressInfo {
        Window wi;

        Monitor() {
        }

        public void run() {
            ChaseProgressMonitor mon = ChaseProgressMonitor.getMonitor();
            mon.setProgress(this);
            JFrame win = new JFrame();
            this.wi = new Window(win);
            int scrx = ChaseGUI.getScreenWidth();
            int scry = ChaseGUI.getScreenHeight();
            Dimension dim = mon.getPreferredSize();
            int centerx = (int)((double)(scrx / 2) - dim.getWidth() / 2.0);
            int centery = scry / 2 + 150;
            this.wi.setLocation(centerx, centery);
            this.wi.setSize(mon.getPreferredSize());
            this.wi.add(mon);
            this.wi.setVisible(true);
        }

        public boolean isDone() {
            return ProjectDirBrowser.this.currentsubproject >= ProjectDirBrowser.this.numproj;
        }

        public String getNameOfProgress() {
            return "loading project info...";
        }

        public int getLength() {
            return ProjectDirBrowser.this.numproj;
        }

        public String getCurrentMessage() {
            return null;
        }

        public int getCurrent() {
            return ProjectDirBrowser.this.currentsubproject;
        }

        public void done() {
            ProjectDirBrowser.this.logger.debug("!!finished loading projects!!");
            if (this.wi != null) {
                this.wi.setVisible(false);
                this.wi.dispose();
            }
        }
    }
}

