/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser;

import ciss.phase_viewer.common.MyJCheckBoxMenuItem;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.ReloadListener;
import ciss.phase_viewer.scripting.ScriptUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class TabbedProjectManipulator
extends JPanel {
    private static Logger logger = Logger.getLogger(TabbedProjectManipulator.class.getName());
    private URL property;
    private ProjectInfo info;
    private String scriptName = null;
    private Vector reloadListeners;
    private JTabbedPane tabbedPane;
    private boolean dndSupport = true;
    private Vector tabPanels = new Vector();
    private Component origGlassPane;

    public TabbedProjectManipulator(URL property, ProjectInfo info) {
        this.info = info;
        this.property = property;
        this.init();
    }

    public TabbedProjectManipulator(URL property, ProjectInfo info, boolean dndSupport) {
        this.info = info;
        this.property = property;
        this.dndSupport = dndSupport;
        this.init();
    }

    public void addToTabbedPane(JComponent component, int index) {
        this.tabbedPane.add((Component)component, index);
    }

    private void init() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.tabbedPane);
        this.parseAndAddTabs();
        this.revalidate();
    }

    public void addReloadListener(ReloadListener rlistener) {
        if (this.reloadListeners == null) {
            this.reloadListeners = new Vector();
        }
        this.reloadListeners.add(rlistener);
        logger.debug(rlistener);
    }

    public void removeReloadListener(ReloadListener rlistener) {
        if (this.reloadListeners == null) {
            return;
        }
        this.reloadListeners.remove(rlistener);
    }

    public void buttonPressed() {
        int count = this.tabbedPane.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (!(this.tabbedPane.getComponent(i) instanceof TabPanel)) continue;
            ((TabPanel)this.tabbedPane.getComponent(i)).btnPressed();
        }
    }

    private void parseAndAddTabs() {
        Element elem_tabs;
        List tab_list;
        String placement;
        String layout;
        Document doc = XMLUtils.getDocumentFromURL(this.property);
        if (doc == null) {
            logger.error("couldn't get document from " + this.property);
            return;
        }
        Element elem = doc.getRootElement();
        if (!elem.getName().equals("root")) {
            logger.error("invalid ProjectSpecification file.");
            return;
        }
        Element elem_tab = elem.getChild("tabbed_pane_properties");
        boolean wrap = new Boolean(elem_tab.getChildTextTrim("wrap"));
        if (wrap) {
            this.tabbedPane.setTabLayoutPolicy(0);
        }
        if ((layout = elem_tab.getChildTextTrim("tab_layout")) != null) {
            if (layout.equalsIgnoreCase("wrap")) {
                this.tabbedPane.setTabLayoutPolicy(0);
            } else if (layout.equalsIgnoreCase("scroll")) {
                this.tabbedPane.setTabLayoutPolicy(1);
            }
        }
        if ((placement = elem_tab.getChildTextTrim("tab_placement")) != null) {
            if (placement.equalsIgnoreCase("top")) {
                this.tabbedPane.setTabPlacement(1);
            } else if (placement.equalsIgnoreCase("left")) {
                this.tabbedPane.setTabPlacement(2);
            } else if (placement.equalsIgnoreCase("bottom")) {
                this.tabbedPane.setTabPlacement(3);
            } else if (placement.equalsIgnoreCase("right")) {
                this.tabbedPane.setTabPlacement(4);
            }
        }
        if ((tab_list = (elem_tabs = elem.getChild("tabs")).getChildren()) == null || tab_list.size() == 0) {
            logger.warn("no tab to add...");
            return;
        }
        for (int i = 0; i < tab_list.size(); ++i) {
            Element element = (Element)tab_list.get(i);
            this.addManipulator(element);
        }
        Element scrname = elem_tab.getChild("scriptname");
        if (scrname != null) {
            this.scriptName = this.info.getProjectDirectory() + System.getProperty("file.separator") + scrname.getTextTrim();
        }
        if (this.scriptName != null && new File(this.scriptName).exists()) {
            this.runScript();
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                TabbedProjectManipulator.this.updateTab();
            }
        });
        this.tabbedPane.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (TabbedProjectManipulator.this.tabbedPane instanceof DnDTabbedPane) {
                    ((DnDTabbedPane)TabbedProjectManipulator.this.tabbedPane).setGlassPane();
                }
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.tabbedPane.addMouseListener(new MouseListenerTab());
        this.updateTab();
    }

    private void updateTab() {
        Component comp = this.tabbedPane.getSelectedComponent();
        if (comp == null) {
            return;
        }
        if (this.reloadListeners != null) {
            for (int i = 0; i < this.reloadListeners.size(); ++i) {
                JComponent jc;
                Object ob = this.reloadListeners.get(i);
                if (ob == null || (jc = ((ReloadListener)ob).getReloadingComponent()) == null || comp != jc) continue;
                ((ReloadListener)ob).reload();
            }
        }
    }

    private void runScript() {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("parent", this);
        props.put("projectInfo", this.info);
        ScriptUtils.runScript(this.scriptName, props);
        logger.debug("run script: " + this.scriptName);
    }

    private void showMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        for (int i = 0; i < this.tabPanels.size(); ++i) {
            TabPanel panel = (TabPanel)this.tabPanels.elementAt(i);
            MyJCheckBoxMenuItem item = new MyJCheckBoxMenuItem(panel.toString());
            item.setState(panel.getShowTab());
            item.addActionListener(new ActionListenerPopup(panel));
            popup.add(item);
        }
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public void reload() {
        if (this.reloadListeners != null) {
            for (int i = 0; i < this.reloadListeners.size(); ++i) {
                ((ReloadListener)this.reloadListeners.get(i)).setReload(true);
            }
        }
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getSelectedIndex());
        this.updateTab();
    }

    private void addManipulator(Element element) {
        String name = element.getChildTextTrim("name");
        String iconpath = element.getChildTextTrim("iconpath");
        String loadClass = element.getChildTextTrim("loadclass");
        String description = MyElement.decode(element.getChildTextTrim("description"));
        String init_visible = MyElement.decode(element.getChildTextTrim("init_visible"));
        boolean binit_visible = true;
        if (init_visible != null && init_visible.equalsIgnoreCase("false")) {
            binit_visible = false;
        }
        logger.debug("adding " + name);
        TabPanel tabPanel = new TabPanel(this, name, loadClass, this.info, description, iconpath);
        this.addReloadListener(tabPanel);
        this.tabPanels.addElement(tabPanel);
        if (binit_visible) {
            this.tabbedPane.addTab(name, tabPanel);
            PluginLoader loader = new PluginLoader();
            if (iconpath != null && iconpath.length() != 0 && !iconpath.equals("null")) {
                URL res = null;
                try {
                    res = loader.getResource(iconpath);
                    this.tabbedPane.setIconAt(this.tabbedPane.getTabCount() - 1, new ImageIcon(res));
                }
                catch (Exception ex) {
                    logger.error("failed to resolve icon path.");
                }
            }
            if (description != null && description.length() != 0) {
                this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, description);
            }
        } else {
            tabPanel.setShowTab(false);
        }
    }

    class GhostGlassPane
    extends JPanel {
        private final AlphaComposite composite;
        private Point location = new Point(0, 0);
        private BufferedImage dragged = null;

        public GhostGlassPane() {
            this.setOpaque(false);
            this.composite = AlphaComposite.getInstance(3, 0.5f);
        }

        public void setImage(BufferedImage dragged) {
            this.dragged = dragged;
        }

        public void setPoint(Point location) {
            this.location = location;
        }

        public void paintComponent(Graphics g) {
            if (this.dragged == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(this.composite);
            double xx = this.location.getX() - (double)(this.dragged.getWidth(this) / 2);
            double yy = this.location.getY() - (double)(this.dragged.getHeight(this) / 2);
            g2.drawImage((Image)this.dragged, (int)xx, (int)yy, null);
        }
    }

    class DnDTabbedPane
    extends JTabbedPane {
        private static final int LINEWIDTH = 3;
        private String NAME = "test";
        private GhostGlassPane glassPane = new GhostGlassPane();
        private Rectangle2D lineRect = new Rectangle2D.Double();
        private Color lineColor = new Color(0, 100, 255);
        private DragSource dragSource = new DragSource();
        private DropTarget dropTarget;
        private int dragTabIndex = -1;
        private DnDTabbedPane dndTabbedPane;
        private DataFlavor FLAVOR;
        private boolean hasghost = true;

        public DnDTabbedPane(String name) {
            this.NAME = name;
            this.FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", this.NAME);
            this.dndTabbedPane = this;
            DragGestureListenerImpl dgl = new DragGestureListenerImpl();
            this.dropTarget = new DropTarget(this.glassPane, 3, new CDropTargetListener(), true);
            this.dragSource.createDefaultDragGestureRecognizer(this, 3, dgl);
            TabbedProjectManipulator.this.origGlassPane = TabbedProjectManipulator.this.info.getParent().getGlassPane();
            this.setGlassPane();
        }

        void setGlassPane() {
            TabbedProjectManipulator.this.info.getParent().setGlassPane(this.glassPane);
        }

        public void setPaintGhost(boolean flag) {
            this.hasghost = flag;
        }

        public boolean hasGhost() {
            return this.hasghost;
        }

        private int getTargetTabIndex(Point pt) {
            Point p = (Point)pt.clone();
            SwingUtilities.convertPointToScreen(p, this.glassPane);
            SwingUtilities.convertPointFromScreen(p, this);
            for (int i = 0; i < this.getTabCount(); ++i) {
                Rectangle rect = this.getBoundsAt(i);
                rect.setRect(rect.x - rect.width / 2, rect.y, rect.width, rect.height);
                if (!rect.contains(p)) continue;
                return i;
            }
            Rectangle rect = this.getBoundsAt(this.getTabCount() - 1);
            rect.setRect(rect.x + rect.width / 2, rect.y, rect.width + 100, rect.height);
            if (rect.contains(p)) {
                return this.getTabCount();
            }
            return -1;
        }

        private void convertTab(int prev, int next) {
            if (next < 0 || prev == next) {
                return;
            }
            Component cmp = this.getComponentAt(prev);
            String str = this.getTitleAt(prev);
            if (next == this.getTabCount()) {
                this.remove(prev);
                this.addTab(str, cmp);
                this.setSelectedIndex(this.getTabCount() - 1);
            } else if (prev > next) {
                this.remove(prev);
                this.insertTab(str, null, cmp, null, next);
                this.setSelectedIndex(next);
            } else {
                this.remove(prev);
                this.insertTab(str, null, cmp, null, next - 1);
                this.setSelectedIndex(next - 1);
            }
        }

        private void initTargetLine(int next) {
            if (next < 0 || this.dragTabIndex == next || next - this.dragTabIndex == 1) {
                this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
            } else if (next == this.getTabCount()) {
                Rectangle rect = this.getBoundsAt(this.getTabCount() - 1);
                this.lineRect.setRect(rect.x + rect.width - 1, rect.y, 3.0, rect.height);
            } else if (next == 0) {
                Rectangle rect = this.getBoundsAt(0);
                this.lineRect.setRect(-1.0, rect.y, 3.0, rect.height);
            } else {
                Rectangle rect = this.getBoundsAt(next - 1);
                this.lineRect.setRect(rect.x + rect.width - 1, rect.y, 3.0, rect.height);
            }
            this.repaint();
        }

        private void initGlassPane(Component c2, Point pt) {
            Point p = (Point)pt.clone();
            this.dragTabIndex = this.indexAtLocation(p.x, p.y);
            if (this.hasGhost()) {
                Rectangle rect = this.getBoundsAt(this.dragTabIndex);
                BufferedImage image = new BufferedImage(c2.getWidth(), c2.getHeight(), 2);
                Graphics g = image.getGraphics();
                c2.paint(g);
                image = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
                this.glassPane.setImage(image);
            }
            this.glassPane.setVisible(true);
            SwingUtilities.convertPointToScreen(p, c2);
            SwingUtilities.convertPointFromScreen(p, this.glassPane);
            this.glassPane.setPoint(p);
        }

        private Rectangle getTabAreaBound() {
            Rectangle lastTab = this.getUI().getTabBounds(this, this.getTabCount() - 1);
            return new Rectangle(0, 0, this.getWidth(), lastTab.y + lastTab.height);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.dragTabIndex >= 0) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(this.lineColor);
                g2.fill(this.lineRect);
            }
        }

        class CDropTargetListener
        implements DropTargetListener {
            CDropTargetListener() {
            }

            public void dragEnter(DropTargetDragEvent e) {
                if (this.isDragAcceptable(e)) {
                    e.acceptDrag(e.getDropAction());
                } else {
                    e.rejectDrag();
                }
            }

            public void dragExit(DropTargetEvent e) {
            }

            public void dropActionChanged(DropTargetDragEvent e) {
            }

            public void dragOver(DropTargetDragEvent e) {
                DnDTabbedPane.this.initTargetLine(DnDTabbedPane.this.getTargetTabIndex(e.getLocation()));
                if (DnDTabbedPane.this.hasGhost()) {
                    DnDTabbedPane.this.glassPane.setPoint(e.getLocation());
                    DnDTabbedPane.this.glassPane.repaint();
                }
            }

            public void drop(DropTargetDropEvent e) {
                Transferable t = e.getTransferable();
                DataFlavor[] f = t.getTransferDataFlavors();
                if (this.isDropAcceptable(e)) {
                    DnDTabbedPane.this.convertTab(DnDTabbedPane.this.dragTabIndex, DnDTabbedPane.this.getTargetTabIndex(e.getLocation()));
                    e.dropComplete(true);
                } else {
                    e.dropComplete(false);
                }
                DnDTabbedPane.this.repaint();
            }

            public boolean isDragAcceptable(DropTargetDragEvent e) {
                Transferable t = e.getTransferable();
                if (t == null) {
                    return false;
                }
                DataFlavor[] f = e.getCurrentDataFlavors();
                return t.isDataFlavorSupported(f[0]) && DnDTabbedPane.this.dragTabIndex >= 0;
            }

            public boolean isDropAcceptable(DropTargetDropEvent e) {
                Transferable t = e.getTransferable();
                if (t == null) {
                    return false;
                }
                DataFlavor[] f = t.getTransferDataFlavors();
                Point p = (Point)e.getLocation().clone();
                return t.isDataFlavorSupported(f[0]) && DnDTabbedPane.this.dragTabIndex >= 0 && DnDTabbedPane.this.dragTabIndex != DnDTabbedPane.this.indexAtLocation(p.x, p.y);
            }
        }

        class TransferableImpl
        implements Transferable {
            TransferableImpl() {
            }

            public Object getTransferData(DataFlavor flavor) {
                return DnDTabbedPane.this.dndTabbedPane;
            }

            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] f = new DataFlavor[]{DnDTabbedPane.this.FLAVOR};
                return f;
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.getHumanPresentableName().equals(DnDTabbedPane.this.NAME);
            }
        }

        class DragSourceListenerImpl
        implements DragSourceListener {
            DragSourceListenerImpl() {
            }

            public void dragEnter(DragSourceDragEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            public void dragExit(DragSourceEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                DnDTabbedPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                DnDTabbedPane.this.glassPane.setPoint(new Point(-1000, -1000));
                DnDTabbedPane.this.glassPane.repaint();
            }

            public void dragOver(DragSourceDragEvent e) {
                Point p = (Point)e.getLocation().clone();
                SwingUtilities.convertPointFromScreen(p, DnDTabbedPane.this);
                if (DnDTabbedPane.this.getTabAreaBound().contains(p)) {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                } else {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                }
            }

            public void dragDropEnd(DragSourceDropEvent e) {
                DnDTabbedPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                DnDTabbedPane.this.dragTabIndex = -1;
                if (DnDTabbedPane.this.hasGhost()) {
                    DnDTabbedPane.this.glassPane.setVisible(false);
                    DnDTabbedPane.this.glassPane.setImage(null);
                }
            }

            public void dropActionChanged(DragSourceDragEvent e) {
            }
        }

        class DragGestureListenerImpl
        implements DragGestureListener {
            DragSourceListenerImpl dsl;
            TransferableImpl t;

            DragGestureListenerImpl() {
                this.dsl = new DragSourceListenerImpl();
                this.t = new TransferableImpl();
            }

            public void dragGestureRecognized(DragGestureEvent e) {
                DnDTabbedPane.this.initGlassPane(e.getComponent(), e.getDragOrigin());
                try {
                    e.startDrag(DragSource.DefaultMoveDrop, this.t, this.dsl);
                }
                catch (InvalidDnDOperationException idoe) {
                    idoe.printStackTrace();
                }
            }
        }
    }

    class TabPanel
    extends JPanel
    implements ReloadListener {
        private Logger logger = Logger.getLogger(TabPanel.class.getName());
        private String loadClass;
        private ProjectInfo info;
        private ProjectManipulator manip = null;
        private TabbedProjectManipulator parent;
        private boolean reload = false;
        private String name;
        private boolean showTab = true;
        private String description;
        private String iconpath;

        protected TabPanel(TabbedProjectManipulator parent, String name, String loadClass, ProjectInfo info, String description, String iconpath) {
            this.parent = parent;
            this.name = name;
            this.loadClass = loadClass;
            this.info = info;
            this.description = description;
            this.iconpath = iconpath;
            this.setLayout(new GridLayout());
        }

        protected void btnPressed() {
            if (this.manip != null) {
                this.manip.buttonPressed();
            }
        }

        protected String getDescription() {
            return this.description;
        }

        protected String getIconPath() {
            return this.iconpath;
        }

        public void reload() {
            if (this.manip == null || this.reload) {
                this.manip = (ProjectManipulator)PluginLoader.instantiate(this.loadClass, new Object[]{this.info});
                if (this.manip != null) {
                    this.manip.init();
                    this.info.getParent().registerProjectManipulators(this.manip);
                    this.logger.debug("adding " + this.loadClass);
                    this.removeAll();
                    boolean in_scr = false;
                    Container parentComp = this.getParent();
                    if (parentComp instanceof JScrollPane) {
                        in_scr = true;
                    }
                    if (!in_scr) {
                        JScrollPane pane = new JScrollPane(this.manip);
                        this.manip.setPreferredSize(pane.getPreferredSize());
                        this.add(pane);
                    } else {
                        this.add(this.manip);
                    }
                    this.manip.postInit();
                }
            }
            this.reload = false;
        }

        protected void setShowTab(boolean showTab) {
            this.showTab = showTab;
        }

        protected boolean getShowTab() {
            return this.showTab;
        }

        public void setReload(boolean reload) {
            this.reload = reload;
        }

        public JComponent getReloadingComponent() {
            return this;
        }

        public String toString() {
            return this.name;
        }
    }

    class ActionListenerPopup
    implements ActionListener {
        private TabPanel tabPanel;

        ActionListenerPopup(TabPanel tabPanel) {
            this.tabPanel = tabPanel;
        }

        public void actionPerformed(ActionEvent ae) {
            JCheckBoxMenuItem mi = (JCheckBoxMenuItem)ae.getSource();
            if (!this.tabPanel.getShowTab()) {
                TabbedProjectManipulator.this.tabbedPane.addTab(this.tabPanel.toString(), this.tabPanel);
                String iconpath = this.tabPanel.getIconPath();
                String description = this.tabPanel.getDescription();
                if (iconpath != null && iconpath.length() != 0) {
                    URL res = null;
                    try {
                        PluginLoader loader = new PluginLoader();
                        res = loader.getResource(iconpath);
                        TabbedProjectManipulator.this.tabbedPane.setIconAt(TabbedProjectManipulator.this.tabbedPane.getTabCount() - 1, new ImageIcon(res));
                    }
                    catch (Exception ex) {
                        logger.error("failed to resolve icon path.");
                    }
                }
                if (description != null && description.length() != 0) {
                    TabbedProjectManipulator.this.tabbedPane.setToolTipTextAt(TabbedProjectManipulator.this.tabbedPane.getTabCount() - 1, description);
                }
                this.tabPanel.setShowTab(true);
            } else {
                TabbedProjectManipulator.this.tabbedPane.remove(this.tabPanel);
                this.tabPanel.setShowTab(false);
            }
            if (TabbedProjectManipulator.this.tabbedPane.getTabCount() != 0) {
                TabbedProjectManipulator.this.tabbedPane.setSelectedIndex(0);
                TabbedProjectManipulator.this.updateTab();
            }
        }
    }

    class MouseListenerTab
    extends MouseAdapter {
        MouseListenerTab() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                TabbedProjectManipulator.this.showMenu(e);
            }
        }
    }
}

