/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis.perlscriptexecuters;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlScriptOption;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PerlScript {
    private Logger logger = Logger.getLogger(PerlScript.class.getName());
    private String scriptFile;
    private Vector options;
    private File workDir;
    private String[] command;

    public PerlScript(String scriptFile, File workDir) {
        this.scriptFile = scriptFile;
        this.workDir = workDir;
    }

    public void addOptions(PerlScriptOption option) {
        if (this.options == null) {
            this.options = new Vector();
        }
        this.options.addElement(option);
    }

    public PerlScriptOption[] getOptions() {
        Object[] opts = new PerlScriptOption[this.options.size()];
        this.options.copyInto(opts);
        return opts;
    }

    public void setCommand(String[] command) {
        this.command = command;
    }

    protected BufferedReader[] exec() {
        String com = this.getPerlScript(this.scriptFile);
        for (int i = 0; i < this.command.length; ++i) {
            if (this.command[i].equals(PerlScriptOption.OPTION)) {
                for (int j2 = 0; j2 < this.options.size(); ++j2) {
                    PerlScriptOption opt = (PerlScriptOption)this.options.get(j2);
                    com = com + " " + opt.generateOptions();
                }
                continue;
            }
            com = com + " " + this.command[i];
        }
        this.logger.info("executing: " + com);
        BufferedReader[] ret = null;
        try {
            ret = ExternalProgramExecuter.executeGetBR(com, this.workDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private String getPerlScript(String name) {
        String ret = "";
        String FS = System.getProperty("file.separator");
        GlobalProperties pm = PropertiesManager.getGlobalProperties(0);
        ret = System.getProperty("pviewer.home") + FS + pm.getProperty("phasetoolsdir") + FS + name;
        if (!new File(ret).exists()) {
            ret = name;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            ret = "perl.exe " + Utils.getPathDQ(ret);
        }
        return ret;
    }
}

