/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import java.util.EventObject;
import javax.swing.JTextField;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

public class TextFieldPhase
extends JTextField
implements Command,
InputInterfaceEntryChangeListener {
    private static Logger logger = Logger.getLogger(TextFieldPhase.class.getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;
    private boolean isDoubleQuoted = false;

    public TextFieldPhase(int columns, String[] inputSpecifications, InputInterface inputinterface, boolean isDoubleQuoted) {
        super(columns);
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.isDoubleQuoted = isDoubleQuoted;
        inputinterface.addInputInterfaceEntryChangeListener(this);
        logger.debug("inputSpec: " + inputSpecifications[0] + " is DQ? " + this.isDoubleQuoted);
    }

    public void execute(EventObject e) {
        this.inputinterface.selectRoot();
        String inp = this.inputSpecifications[0];
        InputInterfacePrimitiveEntry entry = this.inputinterface.getInputInterfacePrimitiveEntry(inp);
        String[] fname = inp.split("\\.");
        String name = fname[fname.length - 1];
        String value = super.getText().trim();
        entry.saveState();
        entry.setName(name);
        entry.setValue(value);
        entry.setDoubleQuoted(this.isDoubleQuoted);
        logger.debug(" primitive entry: " + entry);
        if (value.length() == 0) {
            this.inputinterface.removeEntry(entry, this);
        } else {
            this.inputinterface.replaceEntry(entry, this);
        }
    }

    public void inputInterfaceInitialized() {
    }

    public void inputInterfaceInitializing() {
        int i;
        CaretListener[] lists = this.getCaretListeners();
        for (i = 0; i < lists.length; ++i) {
            this.removeCaretListener(lists[i]);
        }
        this.setText("");
        for (i = 0; i < lists.length; ++i) {
            this.addCaretListener(lists[i]);
        }
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent evt) {
        int i;
        logger.debug("at inputInterfaceEntryChanged... evt.getTag(): " + evt.getTag());
        if (evt.getSource() == this) {
            return;
        }
        String tag = evt.getTag();
        InputInterfaceEntry entry = evt.getEntry();
        if (entry.getEntryType() != 0) {
            return;
        }
        InputInterfacePrimitiveEntry pentry = (InputInterfacePrimitiveEntry)entry;
        String fullName = tag + "." + pentry.getName();
        logger.debug("caught change of inputinterface object at: " + fullName + " and I'm " + this.inputSpecifications[0]);
        logger.debug("specifically, the change is : " + pentry.getValue());
        CaretListener[] listeners = this.getCaretListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.removeCaretListener(listeners[i]);
        }
        for (i = 0; i < this.inputSpecifications.length; ++i) {
            if (!fullName.trim().equalsIgnoreCase(this.inputSpecifications[i].trim())) continue;
            this.setText(pentry.getValue());
            break;
        }
        for (i = 0; i < listeners.length; ++i) {
            this.addCaretListener(listeners[i]);
        }
    }
}

