/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfaceUnits;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class ComboBoxPhaseUnit
extends JComboBox
implements Command,
InputInterfaceEntryChangeListener {
    private static Logger logger = Logger.getLogger(ComboBoxPhaseUnit.class.getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;
    private String[] choices;
    private int unitType;
    private boolean writeAll = true;
    public static final int LONGTIME = 1;
    public static final int TIME = 2;
    public static final int LENGTH = 3;
    public static final int ENERGY = 4;
    public static final int FORCE = 5;

    public ComboBoxPhaseUnit(String[] choices, String[] inputSpecifications, InputInterface inputinterface, int unitType) {
        super(choices);
        this.choices = choices;
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.unitType = unitType;
        inputinterface.addInputInterfaceEntryChangeListener(this);
    }

    public void execute(EventObject e) {
        this.inputinterface.selectRoot();
        logger.debug(super.getSelectedItem());
        int inpSpecLength = 1;
        if (this.writeAll) {
            inpSpecLength = this.inputSpecifications.length;
        }
        for (int is = 0; is < inpSpecLength; ++is) {
            String inp = this.inputSpecifications[is];
            InputInterfaceUnits units = this.inputinterface.getInputInterfaceUnits(inp);
            units.saveState();
            String newText = (String)super.getSelectedItem();
            String[] fname = this.inputSpecifications[0].split("\\.");
            String name = fname[fname.length - 1];
            if (newText != null && !newText.equals(ConstParameters.NO_SELECTION)) {
                String[] unitName = new String[]{newText};
                units.setName(name);
                units.setUnits(unitName);
                this.inputinterface.replaceEntry(units, this);
                logger.debug("replaced unit at: " + units.getName());
                continue;
            }
            this.inputinterface.removeEntry(units, this);
            logger.debug("removed unit at: " + units.getName());
        }
    }

    public void inputInterfaceInitializing() {
        int i;
        ActionListener[] lists = this.getActionListeners();
        for (i = 0; i < lists.length; ++i) {
            this.removeActionListener(lists[i]);
        }
        this.setSelectedIndex(0);
        for (i = 0; i < lists.length; ++i) {
            this.addActionListener(lists[i]);
        }
    }

    public void inputInterfaceInitialized() {
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent evt) {
        int i;
        if (evt.getSource() == this || evt.getEntry() == null) {
            return;
        }
        String tag = evt.getTag();
        InputInterfaceEntry entry = evt.getEntry();
        if (entry.getEntryType() != 3) {
            return;
        }
        logger.debug("at inputInterfaceEntryChanged");
        InputInterfaceUnits uentry = (InputInterfaceUnits)entry;
        String fullName = tag + ".units";
        ActionListener[] listeners = this.getActionListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.removeActionListener(listeners[i]);
        }
        for (i = 0; i < this.inputSpecifications.length; ++i) {
            logger.debug("inputSpec : " + this.inputSpecifications[i] + " uentry : name: " + fullName + " val: " + uentry.getUnits()[0]);
            if (!fullName.trim().equalsIgnoreCase(this.inputSpecifications[i].trim())) continue;
            this.setSelectedItem(uentry.getUnits()[0]);
            break;
        }
        for (i = 0; i < listeners.length; ++i) {
            this.addActionListener(listeners[i]);
        }
    }

    public void writeAllEntries(boolean writeAll) {
        this.writeAll = writeAll;
    }
}

