/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.outputinterface;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.mainpanel.ChaseProgressMonitor;
import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputInterface;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class OutputParser
implements Serializable,
ProgressInfo {
    private Logger logger = Logger.getLogger(OutputParser.class.getName());
    protected Vector fileNames;
    protected String fileName;
    protected Vector voutputData = new Vector();
    protected LineNumberReader reader;
    protected LineNumberReader[] readers;
    private OutputInterface parent;
    protected int numLines;
    protected boolean isDone = false;
    private Vector parserListeners = new Vector();
    private boolean parsed = false;
    protected boolean invokeNewThread = true;

    public OutputParser(String fileName) {
        this.fileName = fileName;
        this.fileNames = new Vector();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        Object[] boo = new String[this.fileNames.size()];
        this.fileNames.copyInto(boo);
        return boo;
    }

    public void addFile(String file) {
        this.fileNames.add(file);
    }

    public void resetFiles() {
        this.fileNames = new Vector();
    }

    public void addParserListener(OutputParserListener listener) {
        for (int i = 0; i < this.parserListeners.size(); ++i) {
            if (listener != this.parserListeners.get(i)) continue;
            return;
        }
        this.parserListeners.addElement(listener);
    }

    public boolean getParsed() {
        return this.parsed;
    }

    public void setParsed(boolean parsed) {
        this.parsed = parsed;
    }

    public void doParse() {
        int i;
        if (this.parsed) {
            return;
        }
        this.initializeOutputDataVector();
        if (new File(this.fileName).exists()) {
            try {
                FileReader freader = new FileReader(this.fileName);
                this.reader = new LineNumberReader(freader);
            }
            catch (IOException ioe) {
                this.logger.error("failed to open file: " + this.fileName);
                ioe.printStackTrace();
            }
            this.numLines = Utils.getNumLines(this.fileName);
            if (this.numLines < 0) {
                this.numLines = 0;
            }
        }
        for (i = 0; i < this.fileNames.size(); ++i) {
            this.numLines += Utils.getNumLines(this.fileNames.get(i).toString());
        }
        this.readers = new LineNumberReader[this.fileNames.size()];
        for (i = 0; i < this.fileNames.size(); ++i) {
            this.reader = this.readers[i];
            try {
                FileReader freader = new FileReader(this.fileNames.get(i).toString());
                this.readers[i] = new LineNumberReader(freader);
                continue;
            }
            catch (IOException ioe) {
                this.logger.error("failed to open file: " + this.fileNames.get(i).toString());
                ioe.printStackTrace();
            }
        }
        ChaseProgressMonitor monitor = ChaseProgressMonitor.getMonitor();
        monitor.setProgress(this);
        if (this.invokeNewThread) {
            new Thread(new Parse()).start();
        } else {
            this.parse();
            for (int i2 = 0; i2 < this.parserListeners.size(); ++i2) {
                ((OutputParserListener)this.parserListeners.get(i2)).parseFinished();
            }
            this.isDone = false;
            monitor.stop();
        }
        this.parsed = true;
    }

    protected abstract boolean parse();

    public void addOutputData(OutputData outputData) {
        this.voutputData.addElement(outputData);
    }

    public OutputInterface getParent() {
        return this.parent;
    }

    void setParent(OutputInterface parent) {
        this.parent = parent;
    }

    public void initializeOutputDataVector() {
        this.voutputData = new Vector();
    }

    public OutputData[] getOutputData() {
        if (this.voutputData == null || this.voutputData.size() == 0) {
            return null;
        }
        Object[] ret = new OutputData[this.voutputData.size()];
        this.voutputData.copyInto(ret);
        return ret;
    }

    public OutputData[] getOutputDataCustom() {
        return null;
    }

    public String[] getGenericData(String key) {
        return new String[]{""};
    }

    public String[][] getGenericData2D(String key) {
        return new String[][]{{""}, {""}};
    }

    public int getLength() {
        return this.numLines;
    }

    public int getCurrent() {
        if (this.reader == null) {
            return 0;
        }
        return this.reader.getLineNumber();
    }

    public boolean isDone() {
        return this.isDone;
    }

    public String getNameOfProgress() {
        return "reading " + new File(this.fileName).getName();
    }

    public void done() {
    }

    class Parse
    implements Runnable {
        Parse() {
        }

        public void run() {
            boolean ret = OutputParser.this.parse();
            for (int i = 0; i < OutputParser.this.parserListeners.size(); ++i) {
                ((OutputParserListener)OutputParser.this.parserListeners.get(i)).parseFinished();
            }
            ChaseProgressMonitor.getMonitor().stop();
            OutputParser.this.isDone = false;
        }
    }
}

