/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface.inputinterfacetable;

import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpecManager;
import ciss.phase_viewer.inputinterface.inputinterfacetable.RightClickItems;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class InputInterfaceTableSpec
implements Serializable {
    private static Logger logger = Logger.getLogger(InputInterfaceTableSpec.class.getName());
    private String ID;
    private InputInterfaceTableColumns[] columns;
    private int num_rows = -1;
    private boolean undo_each_column = true;
    private InputInterfaceTableSpecManager parent;
    private boolean non_tabular = false;
    private boolean row_oriented = false;
    private String[] non_tabular_cols;
    private String cell_editor;
    private RightClickItems[] ritems;

    protected InputInterfaceTableSpec(Element element, InputInterfaceTableSpecManager parent) {
        this.ID = element.getName();
        this.parent = parent;
        this.num_rows = this.parseGetNumRows(element);
        this.undo_each_column = this.parseUndoEachColumns(element);
        this.non_tabular = this.parseNonTabular(element);
        if (this.non_tabular) {
            this.parseNonTabularBlock(element);
        }
        this.parseRightClickItems(element);
        this.createTableColumns(element);
    }

    public int getNumRows() {
        return this.num_rows;
    }

    public boolean undoEachColumns() {
        return this.undo_each_column;
    }

    public InputInterfaceTableSpecManager getInputInterfaceTableSpecManager() {
        return this.parent;
    }

    public String getID() {
        return this.ID;
    }

    public InputInterfaceTableColumns[] getTableColumns() {
        return this.columns;
    }

    public InputInterfaceTableColumns getTableColumn(String name) {
        if (this.columns == null) {
            return null;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getName().equalsIgnoreCase(name)) continue;
            return this.columns[i];
        }
        return null;
    }

    public boolean nonTabular() {
        return this.non_tabular;
    }

    public boolean isRowOriented() {
        return this.row_oriented;
    }

    public String[] getColumnNamesForNonTabularData() {
        return this.non_tabular_cols;
    }

    public RightClickItems[] getRightClickItems() {
        return this.ritems;
    }

    private int parseGetNumRows(Element element) {
        String srow = element.getChildTextTrim("num_rows");
        if (srow == null || srow.length() == 0) {
            return -1;
        }
        int ret = -1;
        try {
            ret = Integer.parseInt(srow);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
        return ret;
    }

    private boolean parseRightClickItems(Element element) {
        Element rightclick = element.getChild("right_click_items");
        if (rightclick == null) {
            return false;
        }
        List list = rightclick.getChildren("item");
        if (list == null || list.size() == 0) {
            return false;
        }
        Vector<RightClickItems> rightclickitems = new Vector<RightClickItems>();
        for (int i = 0; i < list.size(); ++i) {
            Element item = (Element)list.get(i);
            String name = item.getChildTextTrim("name");
            String text = item.getChildTextTrim("text");
            String tool = item.getChildTextTrim("tooltiptext");
            RightClickItems items = new RightClickItems(name, text, tool);
            logger.debug(items);
            rightclickitems.addElement(items);
        }
        if (rightclickitems.size() == 0) {
            return false;
        }
        this.ritems = new RightClickItems[rightclickitems.size()];
        rightclickitems.copyInto(this.ritems);
        return true;
    }

    private boolean parseUndoEachColumns(Element element) {
        String eachcol = element.getChildTextTrim("undo_each_column");
        if (eachcol == null || eachcol.length() == 0) {
            return true;
        }
        return new Boolean(eachcol);
    }

    private boolean parseNonTabular(Element element) {
        Element nontabular = element.getChild("non_tabular_data");
        return nontabular != null;
    }

    private void parseNonTabularBlock(Element element) {
        Element nontabular = element.getChild("non_tabular_data");
        String srow_oriented = nontabular.getChildTextTrim("row_oriented");
        this.row_oriented = srow_oriented != null && new Boolean(srow_oriented) != false;
        String scols = nontabular.getChildTextTrim("columns");
        if (scols != null) {
            this.non_tabular_cols = scols.split(",");
        }
        Element celleditor = nontabular.getChild("cell_editor");
        this.cell_editor = celleditor.getChildTextTrim("type");
    }

    private void createTableColumns(Element element) {
        List column = element.getChildren("column");
        if (column == null) {
            return;
        }
        this.columns = new InputInterfaceTableColumns[column.size()];
        for (int i = 0; i < column.size(); ++i) {
            this.columns[i] = new InputInterfaceTableColumns((Element)column.get(i), this);
            if (this.cell_editor == null || this.cell_editor.trim().length() == 0) continue;
            this.columns[i].setCellEditor(this.cell_editor);
        }
    }
}

