/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface.inputinterfacetable;

import ciss.phase_viewer.inputinterface.inputinterfacetable.ComboBoxChoices;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpec;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class InputInterfaceTableColumns {
    private Logger logger = Logger.getLogger(InputInterfaceTableColumns.class.getName());
    public static String TEXT_FIELD = "textfield";
    public static String COMBO_BOX = "combobox";
    public static String CHECK_BOX = "checkbox";
    private String name;
    private boolean first_letter_is_capital = false;
    private String input_specification;
    private boolean ignore_on_save = false;
    private String cell_editor;
    private String[] choices = new String[]{""};
    private String defaultValue;
    private String toolTipText;
    private boolean hideable = false;
    private boolean has_apply_to_all = false;
    private boolean is_editable = true;
    private InputInterfaceTableSpec parent;
    private ComboBoxChoices choi;
    private boolean format = false;
    private String formatter = "0.000000";
    private DecimalFormat decimalFormat;
    private String defaultEditor;

    protected InputInterfaceTableColumns(Element element, InputInterfaceTableSpec parent) {
        this.input_specification = this.name = element.getChildTextTrim("name");
        this.parent = parent;
        this.parse(element);
    }

    public InputInterfaceTableSpec getTableSpec() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getInputSpecifications() {
        return this.input_specification;
    }

    public String getCellEditor() {
        return this.cell_editor;
    }

    public String getDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.defaultValue;
    }

    public String[] getChoices() {
        if (this.choi != null) {
            this.choices = (String[])this.choi.getChoices();
            for (int i = 0; i < this.choices.length; ++i) {
                this.logger.debug(i + " th choice: " + this.choices[i]);
            }
        }
        return this.choices;
    }

    public String getToolTipAssociatedWithChoice(int index) {
        if (this.choi == null) {
            return "";
        }
        return this.choi.getToolTipTexts(index);
    }

    public String getToolTip() {
        return this.toolTipText;
    }

    public boolean isFirstLetterCaps() {
        return this.first_letter_is_capital;
    }

    public boolean isHideable() {
        return this.hideable;
    }

    public boolean hasApplytoAll() {
        return this.has_apply_to_all;
    }

    public boolean isEditable() {
        return this.is_editable;
    }

    public boolean ignoreOnSave() {
        return this.ignore_on_save;
    }

    public boolean format() {
        return this.format;
    }

    public void setCellEditor(String cellEditor) {
        this.cell_editor = cellEditor;
    }

    public DecimalFormat getFormatter() {
        return this.decimalFormat;
    }

    private void parse(Element element) {
        String str;
        Element tmp = element.getChild("cell_editor");
        this.parseCellEditor(tmp);
        this.input_specification = this.parseString("input_specification", element, this.input_specification);
        this.toolTipText = this.parseString("tooltiptext", element, this.toolTipText);
        this.first_letter_is_capital = this.parseBool("first_letter_is_capital", element, this.first_letter_is_capital);
        this.ignore_on_save = this.parseBool("ignore_on_save", element, this.ignore_on_save);
        this.hideable = this.parseBool("hideable", element, this.hideable);
        this.has_apply_to_all = this.parseBool("has_apply_to_all", element, this.has_apply_to_all);
        this.format = this.parseBool("format", element, this.format);
        if (this.format && (str = this.parseString("formatter", element, this.formatter)) != null) {
            this.formatter = str;
            this.decimalFormat = new DecimalFormat(this.formatter);
        }
        this.logger.debug(this);
    }

    private String parseString(String tag, Element element, String defaultString) {
        if (element == null) {
            return defaultString;
        }
        String ret = defaultString;
        Element tmp = element.getChild(tag);
        if (tmp != null) {
            ret = tmp.getValue().trim();
        }
        return ret;
    }

    private boolean parseBool(String tag, Element element, boolean defaultBool) {
        boolean ret = defaultBool;
        if (element == null) {
            return defaultBool;
        }
        Element tmp = element.getChild(tag);
        if (tmp != null) {
            this.logger.debug(this.getName() + " at parse Bool: " + tag + " " + tmp.getValue());
            ret = new Boolean(tmp.getValue().trim());
        }
        return ret;
    }

    private void parseCellEditor(Element element) {
        if (element == null) {
            return;
        }
        this.cell_editor = element.getChildTextTrim("type");
        if (this.cell_editor == null || !this.cell_editor.equalsIgnoreCase(TEXT_FIELD) && !this.cell_editor.equalsIgnoreCase(COMBO_BOX) && !this.cell_editor.equalsIgnoreCase(CHECK_BOX)) {
            this.cell_editor = TEXT_FIELD;
        }
        if (this.cell_editor.equalsIgnoreCase(COMBO_BOX)) {
            this.is_editable = false;
            String foo = element.getChildTextTrim("choices");
            if (foo != null) {
                if (foo.equalsIgnoreCase("FROM_CLASS")) {
                    Object obj = this.loadFrom(element.getChildTextTrim("loadclass"), element.getChildTextTrim("args"));
                    if (obj != null && obj instanceof ComboBoxChoices) {
                        this.choi = (ComboBoxChoices)obj;
                    }
                } else {
                    String[] bar = foo.split(",");
                    this.choices = bar;
                }
            }
        }
        this.is_editable = this.parseBool("editable", element, this.is_editable);
        this.defaultValue = element.getChildTextTrim("default_value");
    }

    private Object loadFrom(String loadClass, String arg) {
        Object obj = null;
        Object[] oargs = null;
        if (arg != null) {
            String[] args = arg.split(",");
            oargs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                oargs[i] = args[i].trim().equals("INPUT_INTERFACE") ? this.parent.getInputInterfaceTableSpecManager().getInputInterface() : args[i];
            }
        }
        if (oargs != null) {
            for (int i = 0; i < oargs.length; ++i) {
                this.logger.debug("arg: " + oargs[i]);
            }
        }
        try {
            Class<?> cla = this.getClass().getClassLoader().loadClass(loadClass);
            Constructor<?>[] constructor = cla.getDeclaredConstructors();
            obj = constructor[0].newInstance(oargs);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Exception ex) {
            this.logger.error("failed to load class: " + loadClass);
            ex.printStackTrace();
        }
        return obj;
    }

    public String toString() {
        String ret = this.getName();
        ret = ret + " has apply-to-all check box? " + Boolean.valueOf(this.has_apply_to_all);
        return ret;
    }
}

