/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.UndoRedoEvent;
import ciss.phase_viewer.inputinterface.UndoRedoListener;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

class UndoRedo
implements InputInterfaceEntryChangeListener {
    private Logger logger = Logger.getLogger(UndoRedo.class.getName());
    private InputInterface inputInterface;
    private Stack undoStack = new Stack();
    private Stack undoTagStack = new Stack();
    private Stack redoStack = new Stack();
    private Stack redoTagStack = new Stack();
    private boolean undoing = false;
    private Vector undoRedoListeners = new Vector();

    protected UndoRedo(InputInterface inputInterface) {
        this.inputInterface = inputInterface;
    }

    protected void clear() {
        this.undoStack = new Stack();
        this.undoTagStack = new Stack();
        this.redoStack = new Stack();
        this.redoTagStack = new Stack();
        this.stateChanged(new UndoRedoEvent(UndoRedoEvent.STACK_UPDATE, this.inputInterface, this.undoStack.size(), this.redoStack.size()));
    }

    public void addUndoRedoListener(UndoRedoListener listener) {
        this.undoRedoListeners.addElement(listener);
    }

    private void stateChanged(UndoRedoEvent e) {
        for (int i = 0; i < this.undoRedoListeners.size(); ++i) {
            ((UndoRedoListener)this.undoRedoListeners.elementAt(i)).undoRedoStateChanged(e);
        }
    }

    protected void addEntry(String tag, InputInterfaceEntry entry) {
        this.undoTagStack.push(tag);
        this.undoStack.push(entry);
        this.stateChanged(new UndoRedoEvent(UndoRedoEvent.STACK_UPDATE, this.inputInterface, this.undoStack.size(), this.redoStack.size(), entry));
    }

    protected void undo() {
        if (!this.undoStack.empty() && !this.undoTagStack.empty()) {
            String tag = (String)this.undoTagStack.pop();
            InputInterfaceEntry entry = (InputInterfaceEntry)this.undoStack.pop();
            this.doIt(tag, entry, true);
            this.stateChanged(new UndoRedoEvent(UndoRedoEvent.UNDO, this.inputInterface, this.undoStack.size(), this.redoStack.size()));
        } else {
            this.logger.info("no data to \"undo\".");
        }
    }

    protected void redo() {
        if (!this.redoStack.empty() && !this.redoTagStack.empty()) {
            String tag = (String)this.redoTagStack.pop();
            InputInterfaceEntry entry = (InputInterfaceEntry)this.redoStack.pop();
            this.doIt(tag, entry, false);
            this.stateChanged(new UndoRedoEvent(UndoRedoEvent.REDO, this.inputInterface, this.undoStack.size(), this.redoStack.size()));
        } else {
            this.logger.info("no data to \"redo\".");
        }
    }

    private void doIt(String tag, InputInterfaceEntry entry, boolean undo) {
        if (undo) {
            this.redoStack.push(entry);
            this.redoTagStack.push(tag);
        }
        this.inputInterface.setUpdateUndoStack(!undo);
        if (undo) {
            this.logger.debug("undoing tag: " + tag + " entry: " + entry);
            entry.undo();
        } else {
            entry.redo();
        }
        this.inputInterface.selectRoot();
        this.inputInterface.selectBlock(tag);
        this.inputInterface.replaceEntry(entry, this, true);
        this.inputInterface.setUpdateUndoStack(true);
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
    }

    public void inputInterfaceInitialized() {
    }

    public void inputInterfaceInitializing() {
    }
}

