/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface;

import ciss.phase_viewer.inputinterface.EntryTokenizer;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceBlock;
import ciss.phase_viewer.inputinterface.InputInterfaceDefaults;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceUnits;
import ciss.phase_viewer.inputinterface.Utils;
import ciss.phase_viewer.inputinterface.filestate.FileStateChangeEvent;
import ciss.phase_viewer.inputinterface.filestate.FileStateListener;
import ciss.phase_viewer.inputinterface.filestate.FileStateObserver;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpecManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DataManager
implements Serializable,
FileStateListener {
    private static final long serialVersionUID = 1L;
    private InputInterface input;
    private InputInterfaceBlock rootBlock;
    private String fileName;
    public static String RBRACE = "\\}";
    public static String ENTRY = "[\\w[*][(][)][=][+][-][.][,][<][>][\\s][\\\\][:][/][\"]]+[^#]";
    public static String LBRACE = "[\\w[\\\\][-][.][\\s]]+\\{";
    public static String LBRACE_NO_IDENT = "\\{";
    public static String SPACE = "\\s";
    public static String[] COMMENT = new String[]{"[!]", "/{2,}"};
    public static String BIKKURIHASH = "!#";
    public static String HASH = "#";
    public static String AST = "*";
    public static String blockStart = "blockStart";
    public static String blockEnd = "blockEnd";
    public static String entry = "entry";
    public static String comment = "comment";
    public static String tableStart = "tableStart";
    public static String tableEntry = "tableEntry";
    public static String tableEnd = "tableEnd";
    public static String TAG = "tag";
    public static String DEFAULT = "default";
    public static String UNITS = "units";
    public static String[] CELL_VECTORS = new String[]{"a_vector", "b_vector", "c_vector"};
    private boolean inTable = false;
    private String[] tableIdentifiers;
    private Vector tableData = new Vector();
    private EntryTokenizer tokenizer = new EntryTokenizer();
    private Logger logger;
    private boolean caseSensitive = true;
    private InputInterfaceTableSpecManager manager;
    private String fullName = "";
    private URL url;
    private FileStateObserver obs;
    private int blcount = 0;
    private int numBlocks = 0;
    private boolean iDidIt = false;

    public DataManager(String fileName) {
        this.fileName = fileName;
        this.input = new InputInterface();
        this.rootBlock = new InputInterfaceBlock();
        this.rootBlock.setName("filename comes here");
        this.logger = Logger.getLogger(this.getClass());
        this.url = DataManager.class.getResource("/ciss/phase_viewer/inputinterface/inputinterfacetable/DefaultInputInterfaceTableSpec.xml");
        this.manager = new InputInterfaceTableSpecManager(this.url, this.input);
    }

    public DataManager(String fileName, URL url) {
        this.fileName = fileName;
        this.url = url;
        this.input = new InputInterface();
        this.manager = new InputInterfaceTableSpecManager(url, this.input);
        this.rootBlock = new InputInterfaceBlock();
        this.rootBlock.setName("filename comes here");
        this.logger = Logger.getLogger(this.getClass());
        this.registerToFileStateObserver();
    }

    public DataManager(String fileName, URL url, boolean initObserver) {
        this.fileName = fileName;
        this.url = url;
        this.input = new InputInterface();
        this.manager = new InputInterfaceTableSpecManager(url, this.input);
        this.rootBlock = new InputInterfaceBlock();
        this.rootBlock.setName("filename comes here");
        this.logger = Logger.getLogger(this.getClass());
        if (!initObserver) {
            return;
        }
        this.registerToFileStateObserver();
    }

    public void unregisterFromFileStateObserver() {
        if (this.obs == null) {
            return;
        }
        this.obs.removeFileStateListener(this);
    }

    public void registerToFileStateObserver() {
        if (this.obs != null) {
            return;
        }
        this.logger.debug("registering to FileStateObserver");
        File dirdir = new File(this.fileName).getParentFile();
        if (dirdir != null && dirdir.exists() && dirdir.isDirectory()) {
            this.obs = new FileStateObserver(new File(this.fileName).getParent(), new String[]{new File(this.fileName).getName()}, 10L);
            this.obs.addFileStateListener(this);
        }
    }

    public DataManager(String fileName, boolean caseSensitive) {
        this.fileName = fileName;
        this.caseSensitive = caseSensitive;
        this.input = new InputInterface();
        this.rootBlock = new InputInterfaceBlock();
        this.rootBlock.setName("filename comes here");
        this.logger = Logger.getLogger(this.getClass());
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setWSisDelimiter(boolean wid) {
        this.tokenizer.setWSisDelimiter(wid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse() {
        String line;
        if (this.manager != null && this.input.getInputInterfaceTableSpecManager() == null) {
            this.input.setInputInterfaceTableSpecManager(this.manager);
        }
        this.input.setFileName(this.fileName);
        if (!new File(this.fileName).exists()) {
            return false;
        }
        this.input.initialize();
        this.rootBlock = this.input.getRootList();
        this.input.setUpdateUndoStack(false);
        BufferedReader br = null;
        boolean valtoks = true;
        Vector<String> temp = new Vector<String>();
        try {
            br = new BufferedReader(new FileReader(this.fileName));
            while ((line = br.readLine()) != null) {
                temp.add(line);
            }
        }
        catch (Exception exc) {
            if (valtoks) {
                this.logger.error("failed to parse: " + this.fileName);
                exc.printStackTrace();
                this.input.clearUndoRedo();
                this.input.setUpdateUndoStack(true);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ioe) {
                this.logger.error("failed to close file: " + this.fileName);
            }
        }
        for (int it = 0; it < temp.size(); ++it) {
            line = (String)temp.get(it);
            Vector tokens = this.tokenize(line);
            for (int i = 0; i < tokens.size(); ++i) {
                String[] token = (String[])tokens.get(i);
                String tokenKind = token[1];
                this.logger.debug("token: " + token[0]);
                this.logger.debug("tokenKind: " + token[1]);
                if (tokenKind.equals(blockStart)) {
                    this.startBlock(token[0]);
                    continue;
                }
                if (tokenKind.equals(blockEnd)) {
                    if (this.inTable) {
                        this.registerTableData();
                        this.inTable = false;
                    }
                    this.endBlock();
                    continue;
                }
                this.registerEntry(token[0], token[1]);
            }
        }
        if (this.numBlocks == 0) {
            return false;
        }
        if (valtoks && this.blcount == 0) {
            this.logger.debug("calling InputInterface.replaceAst()");
            this.input.replaceAst();
            this.input.clearUndoRedo();
            this.input.intialized();
            this.input.setUpdateUndoStack(true);
        }
        return true;
    }

    public InputInterface getInputInterface() {
        return this.input;
    }

    private void startBlock(String token) {
        this.logger.debug("starting block: " + token);
        String blockName = token.replaceAll(LBRACE_NO_IDENT, "").trim();
        this.fullName = this.fullName.trim().length() == 0 ? blockName : this.fullName + "." + blockName;
        InputInterfaceBlock block = new InputInterfaceBlock(blockName, new String(this.fullName));
        this.input.addBlock(block);
        ++this.blcount;
        ++this.numBlocks;
    }

    private void endBlock() {
        int ind = this.fullName.lastIndexOf(".");
        if (ind < 0) {
            ind = 0;
        }
        this.fullName = this.fullName.substring(0, ind);
        this.input.selectParentBlock();
        --this.blcount;
    }

    private void registerTableData() {
        InputInterfaceTable tableEntry = new InputInterfaceTable(this.input.getCurrentBlock().getName(), this.tableIdentifiers, this.tableData);
        this.input.replaceEntry(tableEntry, null, false);
        this.logger.debug("registered table data");
        this.logger.debug("name of table: " + this.input.getCurrentBlock().getName());
    }

    private void registerEntry(String token, String tokenKind) {
        this.tokenizer.setTokens(token, tokenKind);
        Vector results = this.tokenizer.getResults();
        if (results == null) {
            return;
        }
        for (int i = 0; i < results.size(); ++i) {
            String[] res = (String[])results.get(i);
            if (tokenKind.equals(tableStart)) {
                this.tableIdentifiers = res;
                continue;
            }
            if (tokenKind.equals(tableEntry)) {
                this.tableData.addElement(res);
                continue;
            }
            if (tokenKind.equals(entry)) {
                InputInterfacePrimitiveEntry entry = new InputInterfacePrimitiveEntry(Utils.stripDQ(res[0]), Utils.stripDQ(res[1]), Utils.stripDQ(res[2]));
                entry.setDoubleQuoted(Utils.isDoubleQuoted(res[1]));
                entry.setFullName(this.input.getCurrentBlock().getFullName() + "." + Utils.stripDQ(res[0]));
                this.input.replaceEntry(entry, null, false);
                continue;
            }
            if (tokenKind.equals(DEFAULT)) {
                InputInterfaceDefaults defs = new InputInterfaceDefaults(this.input.getCurrentBlock().getName(), res);
                defs.setFullName(this.input.getCurrentBlock().getFullName());
                this.input.replaceEntry(defs, null, false);
                continue;
            }
            if (!tokenKind.equals(UNITS)) continue;
            InputInterfaceUnits units = new InputInterfaceUnits(this.input.getCurrentBlock().getName(), res);
            units.setFullName(this.input.getCurrentBlock().getFullName());
            this.input.replaceEntry(units, null, false);
        }
    }

    private Vector tokenize(String line) {
        String[] token;
        String[] token2;
        Vector<String[]> tokens = new Vector<String[]>();
        line = !this.caseSensitive ? line.toLowerCase().trim() : line.trim();
        String line_new = line.replaceAll(BIKKURIHASH, HASH);
        if (!line_new.equals(line)) {
            this.logger.debug("replaced !# to #");
            line = line_new;
        }
        for (int j = 0; j < COMMENT.length; ++j) {
            String[] comments = line.split(COMMENT[j]);
            if (comments.length < 1) {
                return tokens;
            }
            line = comments[0];
        }
        Pattern pattern = Pattern.compile(LBRACE);
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            token2 = new String[]{matcher.group(), blockStart};
            tokens.addElement(token2);
            this.logger.debug("found lbrace: " + token2[0]);
        }
        if (line.indexOf(HASH) >= 0) {
            token2 = this.parseLinesWithHash(line);
            tokens.addElement(token2);
            return tokens;
        }
        pattern = Pattern.compile(ENTRY);
        matcher = pattern.matcher(line);
        String entryName = new String();
        String notify = new String();
        if (this.inTable) {
            entryName = tableEntry;
            notify = "found table entry: ";
        } else {
            entryName = entry;
            notify = "found primitive entry: ";
        }
        while (matcher.find() && this.blcount != 0) {
            token = new String[2];
            String matchString = matcher.group();
            if (matchString.trim().endsWith("{")) continue;
            token[0] = matchString.replaceAll("}", "");
            token[1] = entryName;
            tokens.addElement(token);
            this.logger.debug(notify + matchString);
        }
        pattern = Pattern.compile(RBRACE);
        matcher = pattern.matcher(line);
        while (matcher.find()) {
            token = new String[]{matcher.group(), blockEnd};
            tokens.addElement(token);
            this.logger.debug("found rbrace: " + token[0]);
        }
        return tokens;
    }

    private String[] parseLinesWithHash(String line) {
        String[] token = new String[2];
        int hashStart = line.indexOf(HASH);
        String parseString = line.substring(hashStart + 1, line.length());
        if (parseString.startsWith(TAG)) {
            token[0] = line;
            token[1] = tableStart;
            this.inTable = true;
            this.tableData = new Vector();
        } else if (parseString.startsWith(DEFAULT)) {
            token[0] = line;
            token[1] = DEFAULT;
        } else if (parseString.startsWith(UNITS)) {
            token[0] = line;
            token[1] = UNITS;
        } else {
            token[0] = line;
            token[1] = comment;
        }
        return token;
    }

    public static void main(String[] args) {
        DataManager datamanager = null;
        if (args.length != 0) {
            datamanager = new DataManager(args[0]);
            datamanager.parse();
        } else {
            System.err.println("must specify file name!");
            System.exit(0);
        }
        InputInterface input = datamanager.getInputInterface();
        input.scanList();
        if (args.length >= 2) {
            input.saveTo(new File(args[1]));
        }
    }

    public void fileStateChanged(FileStateChangeEvent fe) {
        this.logger.debug("at fileStateChanged");
        if (this.input.block) {
            return;
        }
        if (!new File(this.fileName).exists()) {
            return;
        }
        if (!this.input.iSavedIt && this.url != null) {
            this.input.selectRoot();
            this.parse();
            this.input.setState(false);
        } else {
            this.input.iSavedIt = false;
        }
    }
}

