/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.imageviewer;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.imageviewer.ImageViewerBooter;
import ciss.phase_viewer.inputinterface.filestate.FileStateChangeEvent;
import ciss.phase_viewer.inputinterface.filestate.FileStateListener;
import ciss.phase_viewer.inputinterface.filestate.FileStateObserver;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ImageLoaderPanel
extends JPanel
implements FileStateListener {
    private Logger logger = Logger.getLogger(ImageLoaderPanel.class.getName());
    private String dir;
    private Vector imagefiles_wk;
    private String[] imagefiles;
    private String[] imagefiles_selected;
    private JTextArea labeldir;
    private File file;
    private JButton btndir;
    private JButton btnshow;
    private JButton btnclose;
    private JPanel plist;
    private JPanel pbtn;
    private JList list;
    private JScrollPane scrpane;
    private final String DEFAULT_RESOLUTION = "100";
    private JTextField ipres;
    private int pageNum = 0;
    private int page = 0;

    public ImageLoaderPanel(String dir) {
        this.dir = dir;
        this.file = new File(dir);
        this.init();
        if (this.file.exists() && this.file.isDirectory()) {
            FileStateObserver obs = new FileStateObserver(dir, new String[]{".+"});
            obs.addFileStateListener(this);
        }
    }

    private void init() {
        ImageLoaderPanel p = this;
        this.setImageFiles();
        p.setLayout(new BoxLayout(p, 1));
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        this.ipres = new JTextField(12);
        GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
        String res = "100";
        try {
            res = gp.getProperty("image_viewer_default_resolution");
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.ipres.setText(res);
        textPanel.add((Component)new JLabel("resolution(ps,eps,pdf): "), "West");
        textPanel.add((Component)this.ipres, "Center");
        JPanel panel2 = new JPanel();
        panel2.add(textPanel);
        this.file = new File(this.dir);
        JLabel labeldir = new JLabel("current directory: " + this.file.toString());
        labeldir.setBackground(Color.cyan);
        labeldir.setForeground(Color.blue);
        p.add(labeldir);
        this.list = new JList<String>(this.imagefiles);
        Font font = new Font("Serif", 0, 14);
        this.list.setFont(font);
        this.scrpane = new JScrollPane(this.list);
        p.add(this.scrpane);
        JButton btndir = new JButton("select directory");
        JButton btnshow = new JButton("show selected image(s)");
        this.pbtn = new JPanel();
        this.pbtn.setLayout(new BoxLayout(this.pbtn, 0));
        this.pbtn.add((Component)panel2, "West");
        this.pbtn.add((Component)btndir, "Center");
        this.pbtn.add((Component)btnshow, "East");
        p.add(this.pbtn);
        btnshow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageLoaderPanel.this.bootImageViewer();
            }
        });
        btndir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageLoaderPanel.this.selectDir();
                ImageLoaderPanel.this.redraw();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getButton() == 1 && me.getClickCount() == 2) {
                    ImageLoaderPanel.this.bootImageViewer();
                }
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ImageLoaderPanel.this.bootImageViewer();
                }
            }
        });
    }

    private void bootImageViewer() {
        this.logger.info("booting imageviewer ...");
        if (this.list.getSelectedValues().length > 0) {
            if (!this.dir.endsWith(File.separator)) {
                this.dir = this.dir + File.separator;
            }
            this.imagefiles_selected = new String[this.list.getSelectedValues().length];
            for (int i = 0; i < this.list.getSelectedValues().length; ++i) {
                this.imagefiles_selected[i] = this.dir + this.list.getSelectedValues()[i].toString();
            }
            int ires = 100;
            String res = this.ipres.getText();
            try {
                ires = Integer.parseInt(res);
            }
            catch (Exception exc) {
                ires = 100;
            }
            ImageViewerBooter bt = new ImageViewerBooter(ires, this.imagefiles_selected);
            new Thread(bt).start();
        }
    }

    private void setImageFiles() {
        if (this.file.isDirectory()) {
            int i;
            this.imagefiles_wk = new Vector();
            for (i = 0; i < this.file.list().length; ++i) {
                String name = this.file.list()[i];
                if (!name.toLowerCase().endsWith(".jpg") && !name.toLowerCase().endsWith(".jpeg") && !name.toLowerCase().endsWith(".png") && !name.toLowerCase().endsWith(".eps") && !name.toLowerCase().endsWith(".ps") && !name.toLowerCase().endsWith(".pdf") && !name.toLowerCase().endsWith(".gif") && !name.toLowerCase().endsWith(".tif") && !name.toLowerCase().endsWith(".tiff") && !name.toLowerCase().endsWith(".bmp")) continue;
                this.imagefiles_wk.addElement(name);
            }
            this.imagefiles = new String[this.imagefiles_wk.size()];
            for (i = 0; i < this.imagefiles_wk.size(); ++i) {
                this.imagefiles[i] = (String)this.imagefiles_wk.get(i);
            }
        } else {
            this.imagefiles = new String[1];
            this.imagefiles[0] = "";
        }
    }

    private void selectDir() {
        ChaseFileChooser fdlg = new ChaseFileChooser("media");
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("Open");
        fdlg.setFileSelectionMode(1);
        if (fdlg.showDialog(this, "open") != 0) {
            return;
        }
        this.dir = fdlg.getSelectedFile().getAbsolutePath();
        this.file = new File(this.dir);
    }

    private void redraw() {
        this.removeAll();
        this.init();
        this.revalidate();
    }

    public void fileStateChanged(FileStateChangeEvent fe) {
        this.redraw();
    }
}

